/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.credentials.factory;

import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processors.gcp.credentials.factory.CredentialsStrategy;
import org.apache.nifi.processors.gcp.credentials.factory.strategies.ComputeEngineCredentialsStrategy;
import org.apache.nifi.processors.gcp.credentials.factory.strategies.ExplicitApplicationDefaultCredentialsStrategy;
import org.apache.nifi.processors.gcp.credentials.factory.strategies.ImplicitApplicationDefaultCredentialsStrategy;
import org.apache.nifi.processors.gcp.credentials.factory.strategies.JsonFileServiceAccountCredentialsStrategy;
import org.apache.nifi.processors.gcp.credentials.factory.strategies.JsonStringServiceAccountCredentialsStrategy;

public class CredentialsFactory {
    private final List<CredentialsStrategy> strategies = new ArrayList<CredentialsStrategy>();

    public CredentialsFactory() {
        this.strategies.add(new ExplicitApplicationDefaultCredentialsStrategy());
        this.strategies.add(new JsonFileServiceAccountCredentialsStrategy());
        this.strategies.add(new JsonStringServiceAccountCredentialsStrategy());
        this.strategies.add(new ComputeEngineCredentialsStrategy());
        this.strategies.add(new ImplicitApplicationDefaultCredentialsStrategy());
    }

    public CredentialsStrategy selectPrimaryStrategy(Map<PropertyDescriptor, String> properties) {
        for (CredentialsStrategy strategy : this.strategies) {
            if (!strategy.canCreatePrimaryCredential(properties)) continue;
            return strategy;
        }
        return null;
    }

    public CredentialsStrategy selectPrimaryStrategy(ValidationContext validationContext) {
        Map properties = validationContext.getProperties();
        return this.selectPrimaryStrategy(properties);
    }

    public Collection<ValidationResult> validate(ValidationContext validationContext) {
        CredentialsStrategy selectedStrategy = this.selectPrimaryStrategy(validationContext);
        ArrayList<ValidationResult> validationFailureResults = new ArrayList<ValidationResult>();
        for (CredentialsStrategy strategy : this.strategies) {
            Collection<ValidationResult> strategyValidationFailures = strategy.validate(validationContext, selectedStrategy);
            if (strategyValidationFailures == null) continue;
            validationFailureResults.addAll(strategyValidationFailures);
        }
        return validationFailureResults;
    }

    public GoogleCredentials getGoogleCredentials(Map<PropertyDescriptor, String> properties, HttpTransportFactory transportFactory) throws IOException {
        CredentialsStrategy primaryStrategy = this.selectPrimaryStrategy(properties);
        return primaryStrategy.getGoogleCredentials(properties, transportFactory);
    }
}

