/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.drive;

import java.util.Optional;
import java.util.function.Function;
import org.apache.nifi.processors.gcp.drive.GoogleDriveAttributes;
import org.apache.nifi.processors.gcp.drive.GoogleDriveFileInfo;
import org.apache.nifi.serialization.record.Record;

public enum GoogleDriveFlowFileAttribute {
    ID("drive.id", GoogleDriveFileInfo::getId),
    FILENAME(GoogleDriveAttributes.FILENAME, GoogleDriveFileInfo::getName),
    SIZE("drive.size", fileInfo -> Optional.ofNullable(fileInfo.getSize()).map(String::valueOf).orElse(null)),
    TIMESTAMP("drive.timestamp", fileInfo -> Optional.ofNullable(fileInfo.getTimestamp()).map(String::valueOf).orElse(null)),
    MIME_TYPE(GoogleDriveAttributes.MIME_TYPE, GoogleDriveFileInfo::getMimeType);

    private final String name;
    private final Function<GoogleDriveFileInfo, String> fromFileInfo;

    private GoogleDriveFlowFileAttribute(String attributeName, Function<GoogleDriveFileInfo, String> fromFileInfo) {
        this.name = attributeName;
        this.fromFileInfo = fromFileInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getValue(Record record) {
        return record.getAsString(this.name);
    }

    public String getValue(GoogleDriveFileInfo fileInfo) {
        return this.fromFileInfo.apply(fileInfo);
    }
}

