/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.bigquery.proto;

import com.google.cloud.bigquery.storage.v1.BigDecimalByteStringEncoder;
import com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ProtoUtils {
    public static DynamicMessage createMessage(Descriptors.Descriptor descriptor, Map<String, Object> valueMap, TableSchema tableSchema) {
        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        block6: for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            String name = field.getName();
            Object value = valueMap.get(name);
            if (value == null) continue;
            switch (field.getType()) {
                case MESSAGE: {
                    if (field.isRepeated()) {
                        List<Object> collection = value.getClass().isArray() ? Arrays.asList((Object[])value) : (List<Object>)value;
                        collection.forEach(act -> builder.addRepeatedField(field, (Object)ProtoUtils.createMessage(field.getMessageType(), (Map)act, tableSchema)));
                        continue block6;
                    }
                    builder.setField(field, (Object)ProtoUtils.createMessage(field.getMessageType(), (Map)value, tableSchema));
                    continue block6;
                }
                case INT64: {
                    if (value instanceof Integer) {
                        value = (long)((Integer)value).intValue();
                    }
                    ProtoUtils.setField(value, field, builder);
                    continue block6;
                }
                case DOUBLE: {
                    if (value instanceof Float) {
                        value = Double.valueOf(value.toString());
                    }
                    ProtoUtils.setField(value, field, builder);
                    continue block6;
                }
                case BYTES: {
                    if (value instanceof Integer) {
                        value = new BigDecimal((Integer)value);
                    } else if (value instanceof Long) {
                        value = new BigDecimal((Long)value);
                    } else if (value instanceof Float || value instanceof Double) {
                        value = new BigDecimal(value.toString());
                    }
                    if (value instanceof BigDecimal) {
                        if (tableSchema.getFields(field.getIndex()).getType().equals((Object)TableFieldSchema.Type.BIGNUMERIC)) {
                            value = BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)((BigDecimal)value));
                        } else if (tableSchema.getFields(field.getIndex()).getType().equals((Object)TableFieldSchema.Type.NUMERIC)) {
                            value = BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)((BigDecimal)value));
                        }
                    }
                    ProtoUtils.setField(value, field, builder);
                    continue block6;
                }
            }
            ProtoUtils.setField(value, field, builder);
        }
        return builder.build();
    }

    private static void setField(Object value, Descriptors.FieldDescriptor field, DynamicMessage.Builder builder) {
        if (field.isRepeated()) {
            List<Object> collection = value.getClass().isArray() ? Arrays.asList((Object[])value) : (List<Object>)value;
            collection.forEach(act -> builder.addRepeatedField(field, act));
        } else {
            builder.setField(field, value);
        }
    }
}

