/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BigQueryUtils {
    private static final Type gsonSchemaType = new TypeToken<List<Map>>(){}.getType();

    public static Field mapToField(Map fMap) {
        String typeStr = fMap.get("type").toString();
        String nameStr = fMap.get("name").toString();
        String modeStr = fMap.get("mode").toString();
        LegacySQLTypeName type = null;
        if (typeStr.equals("BOOLEAN")) {
            type = LegacySQLTypeName.BOOLEAN;
        } else if (typeStr.equals("STRING")) {
            type = LegacySQLTypeName.STRING;
        } else if (typeStr.equals("BYTES")) {
            type = LegacySQLTypeName.BYTES;
        } else if (typeStr.equals("INTEGER")) {
            type = LegacySQLTypeName.INTEGER;
        } else if (typeStr.equals("FLOAT")) {
            type = LegacySQLTypeName.FLOAT;
        } else if (typeStr.equals("TIMESTAMP") || typeStr.equals("DATE") || typeStr.equals("TIME") || typeStr.equals("DATETIME")) {
            type = LegacySQLTypeName.TIMESTAMP;
        } else if (typeStr.equals("RECORD")) {
            type = LegacySQLTypeName.RECORD;
        }
        return Field.newBuilder((String)nameStr, (LegacySQLTypeName)type, (Field[])new Field[0]).setMode(Field.Mode.valueOf((String)modeStr)).build();
    }

    public static List<Field> listToFields(List<Map> m_fields) {
        ArrayList<Field> fields = new ArrayList<Field>(m_fields.size());
        for (Map m : m_fields) {
            fields.add(BigQueryUtils.mapToField(m));
        }
        return fields;
    }

    public static Schema schemaFromString(String schemaStr) {
        if (schemaStr == null) {
            return null;
        }
        Gson gson = new Gson();
        List fields = (List)gson.fromJson(schemaStr, gsonSchemaType);
        return Schema.of(BigQueryUtils.listToFields(fields));
    }
}

