/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.bigquery.proto;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ProtoUtils {
    public static DynamicMessage createMessage(Descriptors.Descriptor descriptor, Map<String, Object> valueMap) {
        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            List<Object> collection;
            String name = field.getName();
            Object value = valueMap.get(name);
            if (value == null) continue;
            if (Descriptors.FieldDescriptor.Type.MESSAGE.equals((Object)field.getType())) {
                if (field.isRepeated()) {
                    collection = value.getClass().isArray() ? Arrays.asList((Object[])value) : (List<Object>)value;
                    collection.forEach(act -> builder.addRepeatedField(field, (Object)ProtoUtils.createMessage(field.getMessageType(), (Map)act)));
                    continue;
                }
                builder.setField(field, (Object)ProtoUtils.createMessage(field.getMessageType(), (Map)value));
                continue;
            }
            if (value instanceof Integer && field.getType() == Descriptors.FieldDescriptor.Type.INT64) {
                value = (long)((Integer)value).intValue();
            }
            if (field.isRepeated()) {
                collection = value.getClass().isArray() ? Arrays.asList((Object[])value) : (List<Object>)value;
                collection.forEach(act -> builder.addRepeatedField(field, act));
                continue;
            }
            builder.setField(field, value);
        }
        return builder.build();
    }
}

