/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.controller.AbstractComponentNode;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.TerminationAwareLogger;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.flow.ExternalControllerServiceReference;
import org.apache.nifi.flow.ParameterProviderReference;
import org.apache.nifi.flow.VersionedFlowCoordinates;
import org.apache.nifi.flow.VersionedParameterContext;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.registry.ComponentVariableRegistry;
import org.apache.nifi.registry.flow.FlowRegistryBucket;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.FlowRegistryClientConfigurationContext;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.registry.flow.FlowRegistryClientUserContext;
import org.apache.nifi.registry.flow.FlowRegistryException;
import org.apache.nifi.registry.flow.FlowRegistryInvalidException;
import org.apache.nifi.registry.flow.RegisteredFlow;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshotMetadata;
import org.apache.nifi.registry.flow.StandardFlowRegistryClientConfigurationContext;
import org.apache.nifi.util.CharacterFilterUtils;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardFlowRegistryClientNode
extends AbstractComponentNode
implements FlowRegistryClientNode {
    private static final Logger logger = LoggerFactory.getLogger(StandardFlowRegistryClientNode.class);
    private final FlowManager flowManager;
    private final Authorizable parent;
    private final AtomicReference<LoggableComponent<FlowRegistryClient>> client = new AtomicReference();
    private final ControllerServiceProvider serviceProvider;
    private volatile String description;

    public StandardFlowRegistryClientNode(Authorizable parent, FlowManager flowManager, LoggableComponent<FlowRegistryClient> client, String id, ValidationContextFactory validationContextFactory, ControllerServiceProvider serviceProvider, String componentType, String componentCanonicalClass, ComponentVariableRegistry variableRegistry, ReloadComponent reloadComponent, ExtensionManager extensionManager, ValidationTrigger validationTrigger, boolean isExtensionMissing) {
        super(id, validationContextFactory, serviceProvider, componentType, componentCanonicalClass, variableRegistry, reloadComponent, extensionManager, validationTrigger, isExtensionMissing);
        this.parent = parent;
        this.flowManager = flowManager;
        this.serviceProvider = serviceProvider;
        this.client.set(client);
    }

    public Authorizable getParentAuthorizable() {
        return this.parent;
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.Controller, (String)this.getIdentifier(), (String)this.getName());
    }

    public String getProcessGroupIdentifier() {
        return null;
    }

    protected List<ValidationResult> validateConfig() {
        return Collections.emptyList();
    }

    public void verifyModifiable() throws IllegalStateException {
    }

    protected ParameterContext getParameterContext() {
        return null;
    }

    public void reload(Set<URL> additionalUrls) throws Exception {
        String additionalResourcesFingerprint = ClassLoaderUtils.generateAdditionalUrlsFingerprint(additionalUrls, (String)this.determineClasloaderIsolationKey());
        this.setAdditionalResourcesFingerprint(additionalResourcesFingerprint);
        this.getReloadComponent().reload((FlowRegistryClientNode)this, this.getCanonicalClassName(), this.getBundleCoordinate(), additionalUrls);
    }

    public BundleCoordinate getBundleCoordinate() {
        return this.client.get().getBundleCoordinate();
    }

    public ConfigurableComponent getComponent() {
        return this.client.get().getComponent();
    }

    public TerminationAwareLogger getLogger() {
        return this.client.get().getLogger();
    }

    public Class<?> getComponentClass() {
        return ((FlowRegistryClient)this.client.get().getComponent()).getClass();
    }

    public boolean isRestricted() {
        return this.getComponentClass().isAnnotationPresent(Restricted.class);
    }

    public boolean isDeprecated() {
        return this.getComponentClass().isAnnotationPresent(DeprecationNotice.class);
    }

    public boolean isValidationNecessary() {
        return this.getValidationStatus() != ValidationStatus.VALID;
    }

    public ParameterLookup getParameterLookup() {
        return ParameterLookup.EMPTY;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = CharacterFilterUtils.filterInvalidXmlCharacters((String)description);
    }

    public boolean isStorageLocationApplicable(String location) {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), this.client.getClass(), (String)this.getIdentifier());){
            boolean bl = ((FlowRegistryClient)this.client.get().getComponent()).isStorageLocationApplicable(this.getConfigurationContext(), location);
            return bl;
        }
    }

    public Set<FlowRegistryBucket> getBuckets(FlowRegistryClientUserContext context) throws FlowRegistryException, IOException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).getBuckets(this.getConfigurationContext(context)));
    }

    public FlowRegistryBucket getBucket(FlowRegistryClientUserContext context, String bucketId) throws FlowRegistryException, IOException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).getBucket(this.getConfigurationContext(context), bucketId));
    }

    public RegisteredFlow registerFlow(FlowRegistryClientUserContext context, RegisteredFlow flow) throws FlowRegistryException, IOException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).registerFlow(this.getConfigurationContext(context), flow));
    }

    public RegisteredFlow deregisterFlow(FlowRegistryClientUserContext context, String bucketId, String flowId) throws FlowRegistryException, IOException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).deregisterFlow(this.getConfigurationContext(context), bucketId, flowId));
    }

    public RegisteredFlow getFlow(FlowRegistryClientUserContext context, String bucketId, String flowId) throws FlowRegistryException, IOException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).getFlow(this.getConfigurationContext(context), bucketId, flowId));
    }

    public Set<RegisteredFlow> getFlows(FlowRegistryClientUserContext context, String bucketId) throws FlowRegistryException, IOException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).getFlows(this.getConfigurationContext(context), bucketId));
    }

    public RegisteredFlowSnapshot getFlowContents(FlowRegistryClientUserContext context, String bucketId, String flowId, int version, boolean fetchRemoteFlows) throws FlowRegistryException, IOException {
        RegisteredFlowSnapshot flowSnapshot = this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).getFlowContents(this.getConfigurationContext(context), bucketId, flowId, version));
        if (fetchRemoteFlows) {
            VersionedProcessGroup contents = flowSnapshot.getFlowContents();
            for (VersionedProcessGroup child : contents.getProcessGroups()) {
                this.populateVersionedContentsRecursively(context, child);
            }
        }
        return flowSnapshot;
    }

    public RegisteredFlowSnapshot registerFlowSnapshot(FlowRegistryClientUserContext context, RegisteredFlow flow, VersionedProcessGroup snapshot, Map<String, ExternalControllerServiceReference> externalControllerServices, Map<String, VersionedParameterContext> parameterContexts, Map<String, ParameterProviderReference> parameterProviderReferences, String comments, int expectedVersion) throws FlowRegistryException, IOException {
        RegisteredFlowSnapshot registeredFlowSnapshot = this.createRegisteredFlowSnapshot(context, flow, snapshot, externalControllerServices, parameterContexts, parameterProviderReferences, comments, expectedVersion);
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).registerFlowSnapshot(this.getConfigurationContext(context), registeredFlowSnapshot));
    }

    public Set<RegisteredFlowSnapshotMetadata> getFlowVersions(FlowRegistryClientUserContext context, String bucketId, String flowId) throws FlowRegistryException, IOException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).getFlowVersions(this.getConfigurationContext(context), bucketId, flowId));
    }

    public int getLatestVersion(FlowRegistryClientUserContext context, String bucketId, String flowId) throws FlowRegistryException, IOException {
        return this.execute(() -> ((FlowRegistryClient)this.client.get().getComponent()).getLatestVersion(this.getConfigurationContext(context), bucketId, flowId));
    }

    public void setComponent(LoggableComponent<FlowRegistryClient> component) {
        this.client.set(component);
    }

    private <T> T execute(FlowRegistryClientAction<T> action) throws FlowRegistryException, IOException {
        ValidationStatus validationStatus = this.getValidationStatus();
        if (validationStatus != ValidationStatus.VALID) {
            List validationResults = this.getValidationErrors();
            if (validationResults == null) {
                validationResults = Collections.emptyList();
            }
            List validationProblems = validationResults.stream().map(e -> e.getExplanation()).collect(Collectors.toList());
            throw new FlowRegistryInvalidException(validationProblems);
        }
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), this.client.getClass(), (String)this.getIdentifier());){
            T t = action.execute();
            return t;
        }
    }

    private FlowRegistryClientConfigurationContext getConfigurationContext() {
        return new StandardFlowRegistryClientConfigurationContext(null, this.getRawPropertyValues(), this, (ControllerServiceLookup)this.serviceProvider);
    }

    private FlowRegistryClientConfigurationContext getConfigurationContext(FlowRegistryClientUserContext clientContext) {
        String userIdentity = clientContext.getNiFiUserIdentity().orElse(null);
        return new StandardFlowRegistryClientConfigurationContext(userIdentity, this.getRawPropertyValues(), this, (ControllerServiceLookup)this.serviceProvider);
    }

    private String extractIdentity(FlowRegistryClientUserContext context) {
        return context.getNiFiUserIdentity().orElse(null);
    }

    private void populateVersionedContentsRecursively(FlowRegistryClientUserContext context, VersionedProcessGroup group) throws IOException, FlowRegistryException {
        if (group == null) {
            return;
        }
        VersionedFlowCoordinates coordinates = group.getVersionedFlowCoordinates();
        if (coordinates != null) {
            RegisteredFlowSnapshot snapshot = this.fetchFlowContents(context, coordinates, true);
            VersionedProcessGroup contents = snapshot.getFlowContents();
            group.setVersionedFlowCoordinates(coordinates);
            group.setComments(contents.getComments());
            group.setConnections(contents.getConnections());
            group.setControllerServices(contents.getControllerServices());
            group.setFunnels(contents.getFunnels());
            group.setInputPorts(contents.getInputPorts());
            group.setLabels(contents.getLabels());
            group.setOutputPorts(contents.getOutputPorts());
            group.setProcessGroups(contents.getProcessGroups());
            group.setProcessors(contents.getProcessors());
            group.setRemoteProcessGroups(contents.getRemoteProcessGroups());
            group.setVariables(contents.getVariables());
            group.setParameterContextName(contents.getParameterContextName());
            group.setFlowFileConcurrency(contents.getFlowFileConcurrency());
            group.setFlowFileOutboundPolicy(contents.getFlowFileOutboundPolicy());
            group.setDefaultFlowFileExpiration(contents.getDefaultFlowFileExpiration());
            group.setDefaultBackPressureObjectThreshold(contents.getDefaultBackPressureObjectThreshold());
            group.setDefaultBackPressureDataSizeThreshold(contents.getDefaultBackPressureDataSizeThreshold());
            coordinates.setLatest(Boolean.valueOf(snapshot.isLatest()));
        }
        for (VersionedProcessGroup child : group.getProcessGroups()) {
            this.populateVersionedContentsRecursively(context, child);
        }
    }

    private RegisteredFlowSnapshot fetchFlowContents(FlowRegistryClientUserContext context, VersionedFlowCoordinates coordinates, boolean fetchRemoteFlows) throws FlowRegistryException {
        String storageLocation = coordinates.getStorageLocation() == null ? coordinates.getRegistryUrl() : coordinates.getStorageLocation();
        String bucketId = coordinates.getBucketId();
        String flowId = coordinates.getFlowId();
        int version = coordinates.getVersion();
        List<FlowRegistryClientNode> clientNodes = this.getRegistryClientsForInternalFlow(storageLocation);
        for (FlowRegistryClientNode clientNode : clientNodes) {
            try {
                logger.debug("Attempting to fetch flow for Bucket [{}] Flow [{}] Version [{}] using {}", new Object[]{bucketId, flowId, version, clientNode});
                RegisteredFlowSnapshot snapshot = clientNode.getFlowContents(context, bucketId, flowId, version, fetchRemoteFlows);
                coordinates.setRegistryId(clientNode.getIdentifier());
                logger.debug("Successfully fetched flow for Bucket [{}] Flow [{}] Version [{}] using {}", new Object[]{bucketId, flowId, version, clientNode});
                return snapshot;
            }
            catch (Exception e) {
                logger.debug("Failed to fetch flow", (Throwable)e);
            }
        }
        throw new FlowRegistryException(String.format("Could not find any Registry Client that was able to fetch flow with Bucket [%s] Flow [%s] Version [%s] with Storage Location [%s]", bucketId, flowId, version, storageLocation));
    }

    private List<FlowRegistryClientNode> getRegistryClientsForInternalFlow(String storageLocation) {
        ArrayList<FlowRegistryClientNode> matchingClients = new ArrayList<FlowRegistryClientNode>(this.flowManager.getAllFlowRegistryClients());
        matchingClients.sort(Comparator.comparing(client -> client.isStorageLocationApplicable(storageLocation) ? -1 : 1));
        return matchingClients;
    }

    private RegisteredFlowSnapshot createRegisteredFlowSnapshot(FlowRegistryClientUserContext context, RegisteredFlow flow, VersionedProcessGroup snapshot, Map<String, ExternalControllerServiceReference> externalControllerServices, Map<String, VersionedParameterContext> parameterContexts, Map<String, ParameterProviderReference> parameterProviderReferences, String comments, int expectedVersion) {
        RegisteredFlowSnapshotMetadata metadata = new RegisteredFlowSnapshotMetadata();
        metadata.setBucketIdentifier(flow.getBucketIdentifier());
        metadata.setFlowIdentifier(flow.getIdentifier());
        metadata.setAuthor(this.extractIdentity(context));
        metadata.setTimestamp(System.currentTimeMillis());
        metadata.setVersion(expectedVersion);
        metadata.setComments(comments);
        RegisteredFlowSnapshot registeredFlowSnapshot = new RegisteredFlowSnapshot();
        registeredFlowSnapshot.setFlowContents(snapshot);
        registeredFlowSnapshot.setExternalControllerServices(externalControllerServices);
        registeredFlowSnapshot.setParameterContexts(parameterContexts);
        registeredFlowSnapshot.setFlowEncodingVersion("1.0");
        registeredFlowSnapshot.setSnapshotMetadata(metadata);
        registeredFlowSnapshot.setParameterProviders(parameterProviderReferences);
        return registeredFlowSnapshot;
    }

    private static interface FlowRegistryClientAction<T> {
        public T execute() throws FlowRegistryException, IOException;
    }
}

