/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.parameter.ParameterProviderLookup;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterProvider;
import org.apache.nifi.parameter.ParameterProviderConfiguration;
import org.apache.nifi.parameter.ParameterReference;
import org.apache.nifi.parameter.ParameterReferenceManager;
import org.apache.nifi.parameter.ParameterUpdate;
import org.apache.nifi.parameter.StandardParameterUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardParameterContext
implements ParameterContext {
    private static final Logger logger = LoggerFactory.getLogger(StandardParameterContext.class);
    private final String id;
    private final ParameterReferenceManager parameterReferenceManager;
    private final ParameterProviderLookup parameterProviderLookup;
    private final Authorizable parentAuthorizable;
    private String name;
    private long version = 0L;
    private final Map<ParameterDescriptor, Parameter> parameters = new LinkedHashMap<ParameterDescriptor, Parameter>();
    private final List<ParameterContext> inheritedParameterContexts = new ArrayList<ParameterContext>();
    private ParameterProvider parameterProvider;
    private ParameterProviderConfiguration parameterProviderConfiguration;
    private volatile String description;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();

    protected StandardParameterContext(String id, String name, ParameterReferenceManager parameterReferenceManager, Authorizable parentAuthorizable, ParameterProviderLookup parameterProviderLookup, ParameterProviderConfiguration parameterProviderConfiguration) {
        this.id = Objects.requireNonNull(id);
        this.name = Objects.requireNonNull(name);
        this.parameterReferenceManager = parameterReferenceManager;
        this.parentAuthorizable = parentAuthorizable;
        this.parameterProviderLookup = parameterProviderLookup;
        this.configureParameterProvider(parameterProviderConfiguration);
    }

    public String getIdentifier() {
        return this.id;
    }

    public String getProcessGroupIdentifier() {
        return null;
    }

    public String getName() {
        this.readLock.lock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setName(String name) {
        this.writeLock.lock();
        try {
            ++this.version;
            this.name = name;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameters(Map<String, Parameter> updatedParameters) {
        this.writeLock.lock();
        try {
            ++this.version;
            Map<ParameterDescriptor, Parameter> currentEffectiveParameters = this.getEffectiveParameters();
            Map<ParameterDescriptor, Parameter> effectiveProposedParameters = this.getEffectiveParameters(this.getProposedParameters(updatedParameters));
            Map<String, Parameter> effectiveParameterUpdates = this.getEffectiveParameterUpdates(currentEffectiveParameters, effectiveProposedParameters);
            this.verifyCanSetParameters(effectiveParameterUpdates, true);
            this.updateParameters(this.parameters, updatedParameters, true);
            HashMap<String, ParameterUpdate> parameterUpdates = new HashMap<String, ParameterUpdate>(this.updateParameters(currentEffectiveParameters, effectiveParameterUpdates, false));
            this.alertReferencingComponents(parameterUpdates);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Map<ParameterDescriptor, Parameter> getProposedParameters(Map<String, Parameter> proposedParameterUpdates) {
        HashMap<ParameterDescriptor, Parameter> proposedParameters = new HashMap<ParameterDescriptor, Parameter>(this.parameters);
        for (Map.Entry<String, Parameter> entry : proposedParameterUpdates.entrySet()) {
            String parameterName = entry.getKey();
            Parameter parameter = entry.getValue();
            if (parameter == null) {
                Optional<Parameter> existingParameter = this.getParameter(parameterName);
                existingParameter.ifPresent(value -> proposedParameters.remove(value.getDescriptor()));
                continue;
            }
            proposedParameters.remove(parameter.getDescriptor());
            proposedParameters.put(parameter.getDescriptor(), parameter);
        }
        return proposedParameters;
    }

    private void alertReferencingComponents(Map<String, ParameterUpdate> parameterUpdates) {
        if (!parameterUpdates.isEmpty()) {
            logger.debug("Parameter Context {} was updated. {} parameters changed ({}). Notifying all affected components.", new Object[]{this, parameterUpdates.size(), parameterUpdates});
            for (ProcessGroup processGroup : this.parameterReferenceManager.getProcessGroupsBound((ParameterContext)this)) {
                try {
                    processGroup.onParameterContextUpdated(parameterUpdates);
                }
                catch (Exception e) {
                    logger.error("Failed to notify {} that Parameter Context was updated", (Object)processGroup, (Object)e);
                }
            }
        } else {
            logger.debug("Parameter Context {} was updated. {} parameters changed ({}). No existing components are affected.", new Object[]{this, parameterUpdates.size(), parameterUpdates});
        }
    }

    private Map<String, ParameterUpdate> updateParameters(Map<ParameterDescriptor, Parameter> currentParameters, Map<String, Parameter> updatedParameters, boolean performUpdate) {
        HashMap<String, ParameterUpdate> parameterUpdates = new HashMap<String, ParameterUpdate>();
        for (Map.Entry<String, Parameter> entry : updatedParameters.entrySet()) {
            Parameter oldParameter;
            String parameterName = entry.getKey();
            Parameter parameter = entry.getValue();
            if (parameter == null) {
                ParameterDescriptor parameterDescriptor = new ParameterDescriptor.Builder().name(parameterName).build();
                oldParameter = performUpdate ? currentParameters.remove(parameterDescriptor) : currentParameters.get(parameterDescriptor);
                parameterUpdates.put(parameterName, new StandardParameterUpdate(parameterName, oldParameter.getValue(), null, parameterDescriptor.isSensitive()));
                continue;
            }
            Parameter updatedParameter = this.createFullyPopulatedParameter(parameter);
            if (performUpdate) {
                oldParameter = currentParameters.remove(updatedParameter.getDescriptor());
                currentParameters.put(updatedParameter.getDescriptor(), updatedParameter);
            } else {
                oldParameter = currentParameters.get(updatedParameter.getDescriptor());
            }
            if (oldParameter != null && Objects.equals(oldParameter.getValue(), updatedParameter.getValue())) continue;
            String previousValue = oldParameter == null ? null : oldParameter.getValue();
            parameterUpdates.put(parameterName, new StandardParameterUpdate(parameterName, previousValue, updatedParameter.getValue(), updatedParameter.getDescriptor().isSensitive()));
        }
        return parameterUpdates;
    }

    private Parameter createFullyPopulatedParameter(Parameter proposedParameter) {
        ParameterDescriptor descriptor = this.getFullyPopulatedDescriptor(proposedParameter);
        String value = this.getFullyPopulatedValue(proposedParameter);
        return new Parameter(descriptor, value, proposedParameter.getParameterContextId(), Boolean.valueOf(proposedParameter.isProvided()));
    }

    private String getFullyPopulatedValue(Parameter proposedParameter) {
        return proposedParameter.getValue();
    }

    private ParameterDescriptor getFullyPopulatedDescriptor(Parameter proposedParameter) {
        ParameterDescriptor descriptor = proposedParameter.getDescriptor();
        if (descriptor.getDescription() != null) {
            return descriptor;
        }
        Parameter oldParameter = this.parameters.get(proposedParameter.getDescriptor());
        if (proposedParameter.isProvided()) {
            String description = oldParameter == null ? null : oldParameter.getDescriptor().getDescription();
            return new ParameterDescriptor.Builder().from(descriptor).description(description).build();
        }
        return oldParameter == null ? descriptor : oldParameter.getDescriptor();
    }

    public long getVersion() {
        this.readLock.lock();
        try {
            long l = this.version;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Parameter> getParameter(String parameterName) {
        this.readLock.lock();
        try {
            ParameterDescriptor descriptor = new ParameterDescriptor.Builder().name(parameterName).build();
            Optional<Parameter> optional = this.getParameter(descriptor);
            return optional;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.getEffectiveParameters().isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Parameter> getParameter(ParameterDescriptor parameterDescriptor) {
        this.readLock.lock();
        try {
            ParameterDescriptor unescaped = this.unescape(parameterDescriptor);
            Optional<Parameter> optional = Optional.ofNullable((this.inheritedParameterContexts.isEmpty() ? this.parameters : this.getEffectiveParameters()).get(unescaped));
            return optional;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private ParameterDescriptor unescape(ParameterDescriptor descriptor) {
        String parameterName = descriptor.getName().trim();
        if (parameterName.startsWith("'") && parameterName.endsWith("'") || parameterName.startsWith("\"") && parameterName.endsWith("\"")) {
            String stripped = parameterName.substring(1, parameterName.length() - 1);
            return new ParameterDescriptor.Builder().from(descriptor).name(stripped).build();
        }
        return descriptor;
    }

    public Map<ParameterDescriptor, Parameter> getParameters() {
        this.readLock.lock();
        try {
            LinkedHashMap<ParameterDescriptor, Parameter> linkedHashMap = new LinkedHashMap<ParameterDescriptor, Parameter>(this.parameters);
            return linkedHashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Map<ParameterDescriptor, Parameter> getEffectiveParameters() {
        this.readLock.lock();
        try {
            Map<ParameterDescriptor, Parameter> map = this.getEffectiveParameters(this.inheritedParameterContexts);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Map<String, Parameter> getEffectiveParameterUpdates(Map<String, Parameter> parameterUpdates, List<ParameterContext> inheritedParameterContexts) {
        Objects.requireNonNull(parameterUpdates, "Parameter Updates must be specified");
        Objects.requireNonNull(inheritedParameterContexts, "Inherited parameter contexts must be specified");
        Map<ParameterDescriptor, Parameter> currentEffectiveParameters = this.getEffectiveParameters();
        Map<ParameterDescriptor, Parameter> effectiveProposedParameters = this.getEffectiveParameters(inheritedParameterContexts, this.getProposedParameters(parameterUpdates));
        return this.getEffectiveParameterUpdates(currentEffectiveParameters, effectiveProposedParameters);
    }

    private Map<ParameterDescriptor, Parameter> getEffectiveParameters(Map<ParameterDescriptor, Parameter> proposedParameters) {
        return this.getEffectiveParameters(this.inheritedParameterContexts, proposedParameters);
    }

    private Map<ParameterDescriptor, Parameter> getEffectiveParameters(List<ParameterContext> parameterContexts) {
        return this.getEffectiveParameters(parameterContexts, this.parameters);
    }

    private Map<ParameterDescriptor, Parameter> getEffectiveParameters(List<ParameterContext> parameterContexts, Map<ParameterDescriptor, Parameter> proposedParameters) {
        return this.getEffectiveParameters(parameterContexts, proposedParameters, new HashMap<ParameterDescriptor, List<Parameter>>());
    }

    private Map<ParameterDescriptor, Parameter> getEffectiveParameters(List<ParameterContext> parameterContexts, Map<ParameterDescriptor, Parameter> proposedParameters, Map<ParameterDescriptor, List<Parameter>> allOverrides) {
        LinkedHashMap<ParameterDescriptor, Parameter> effectiveParameters = new LinkedHashMap<ParameterDescriptor, Parameter>();
        for (int i = parameterContexts.size() - 1; i >= 0; --i) {
            ParameterContext parameterContext = parameterContexts.get(i);
            this.combineOverrides(allOverrides, this.overrideParameters(effectiveParameters, parameterContext.getEffectiveParameters(), parameterContext));
        }
        this.combineOverrides(allOverrides, this.overrideParameters(effectiveParameters, proposedParameters, this));
        return effectiveParameters;
    }

    private void combineOverrides(Map<ParameterDescriptor, List<Parameter>> existingOverrides, Map<ParameterDescriptor, List<Parameter>> newOverrides) {
        for (Map.Entry<ParameterDescriptor, List<Parameter>> entry : newOverrides.entrySet()) {
            ParameterDescriptor key = entry.getKey();
            List existingOverrideList = existingOverrides.computeIfAbsent(key, k -> new ArrayList());
            existingOverrideList.addAll((Collection)entry.getValue());
        }
    }

    private Map<ParameterDescriptor, List<Parameter>> overrideParameters(Map<ParameterDescriptor, Parameter> existingParameters, Map<ParameterDescriptor, Parameter> overridingParameters, ParameterContext overridingContext) {
        HashMap<ParameterDescriptor, List<Parameter>> allOverrides = new HashMap<ParameterDescriptor, List<Parameter>>();
        for (Map.Entry<ParameterDescriptor, Parameter> entry : existingParameters.entrySet()) {
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            parameters.add(entry.getValue());
            allOverrides.put(entry.getKey(), parameters);
        }
        for (Map.Entry<ParameterDescriptor, Parameter> entry : overridingParameters.entrySet()) {
            ParameterDescriptor overridingParameterDescriptor = entry.getKey();
            Parameter overridingParameter = entry.getValue();
            if (existingParameters.containsKey(overridingParameterDescriptor)) {
                Parameter existingParameter = existingParameters.get(overridingParameterDescriptor);
                ParameterDescriptor existingParameterDescriptor = existingParameter.getDescriptor();
                if (existingParameterDescriptor.isSensitive() && !overridingParameterDescriptor.isSensitive()) {
                    throw new IllegalStateException(String.format("Cannot add ParameterContext because Sensitive Parameter [%s] would be overridden by a Non Sensitive Parameter with the same name", existingParameterDescriptor.getName()));
                }
                if (!existingParameterDescriptor.isSensitive() && overridingParameterDescriptor.isSensitive()) {
                    throw new IllegalStateException(String.format("Cannot add ParameterContext because Non Sensitive Parameter [%s] would be overridden by a Sensitive Parameter with the same name", existingParameterDescriptor.getName()));
                }
            }
            if (overridingParameter.getParameterContextId() == null) {
                overridingParameter = new Parameter(overridingParameter, overridingContext.getIdentifier());
            }
            allOverrides.computeIfAbsent(overridingParameterDescriptor, p -> new ArrayList()).add(overridingParameter);
            existingParameters.put(overridingParameterDescriptor, overridingParameter);
        }
        return allOverrides;
    }

    public ParameterReferenceManager getParameterReferenceManager() {
        return this.parameterReferenceManager;
    }

    public ParameterProviderLookup getParameterProviderLookup() {
        return this.parameterProviderLookup;
    }

    public ParameterProvider getParameterProvider() {
        this.readLock.lock();
        try {
            ParameterProvider parameterProvider = this.parameterProvider;
            return parameterProvider;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureParameterProvider(ParameterProviderConfiguration parameterProviderConfiguration) {
        if (parameterProviderConfiguration == null) {
            return;
        }
        this.parameterProviderConfiguration = parameterProviderConfiguration;
        this.writeLock.lock();
        try {
            ParameterProviderNode parameterProviderNode = this.parameterProviderLookup.getParameterProvider(parameterProviderConfiguration.getParameterProviderId());
            if (parameterProviderNode == null) {
                throw new IllegalArgumentException(String.format("Could not configure Parameter Provider %s, which could not be found", parameterProviderConfiguration.getParameterProviderId()));
            }
            boolean hasUserEnteredParameters = this.parameters.values().stream().anyMatch(parameter -> !parameter.isProvided());
            if (hasUserEnteredParameters) {
                throw new IllegalArgumentException(String.format("A Parameter Provider [%s] cannot be set since there are already user-entered parameters in Context [%s]", this.parameterProvider.getIdentifier(), this.name));
            }
            this.parameterProvider = parameterProviderNode.getParameterProvider();
            this.registerParameterProvider(this.parameterProvider);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ParameterProviderConfiguration getParameterProviderConfiguration() {
        this.readLock.lock();
        try {
            ParameterProviderConfiguration parameterProviderConfiguration = this.parameterProviderConfiguration;
            return parameterProviderConfiguration;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void registerParameterProvider(ParameterProvider parameterProvider) {
        ParameterProviderNode parameterProviderNode = this.getParameterProviderNode(parameterProvider);
        parameterProviderNode.addReference((ParameterContext)this);
    }

    private ParameterProviderNode getParameterProviderNode(ParameterProvider parameterProvider) {
        ParameterProviderNode parameterProviderNode = this.parameterProviderLookup.getParameterProvider(parameterProvider.getIdentifier());
        if (parameterProviderNode == null) {
            throw new IllegalStateException(String.format("Parameter Provider Node is missing for Parameter Provider [%s]", parameterProvider.getIdentifier()));
        }
        return parameterProviderNode;
    }

    private void verifyNoCycles(List<ParameterContext> parameterContexts) {
        Stack<String> traversedIds = new Stack<String>();
        traversedIds.push(this.id);
        this.verifyNoCycles(traversedIds, parameterContexts);
    }

    private void verifyNoCycles(Stack<String> traversedIds, List<ParameterContext> parameterContexts) {
        for (ParameterContext parameterContext : parameterContexts) {
            String id = parameterContext.getIdentifier();
            if (traversedIds.contains(id)) {
                throw new IllegalStateException(String.format("Circular references in Parameter Contexts not allowed. [%s] was detected in a cycle.", parameterContext.getName()));
            }
            traversedIds.push(id);
            this.verifyNoCycles(traversedIds, parameterContext.getInheritedParameterContexts());
            traversedIds.pop();
        }
    }

    public void verifyCanUpdateParameterContext(Map<String, Parameter> parameterUpdates, List<ParameterContext> inheritedParameterContexts) {
        this.verifyCanUpdateParameterContext(parameterUpdates, inheritedParameterContexts, false);
    }

    private void verifyCanUpdateParameterContext(Map<String, Parameter> parameterUpdates, List<ParameterContext> inheritedParameterContexts, boolean duringUpdate) {
        this.verifyProvidedParameters(parameterUpdates);
        if (inheritedParameterContexts == null) {
            return;
        }
        this.verifyNoCycles(inheritedParameterContexts);
        Map<ParameterDescriptor, Parameter> currentEffectiveParameters = this.getEffectiveParameters();
        Map<String, Parameter> effectiveParameterUpdates = this.getEffectiveParameterUpdates(parameterUpdates, inheritedParameterContexts);
        try {
            this.verifyCanSetParameters(currentEffectiveParameters, effectiveParameterUpdates, duringUpdate);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(String.format("Could not update inherited Parameter Contexts for Parameter Context [%s] because: %s", this.name, e.getMessage()), e);
        }
    }

    private void verifyProvidedParameters(Map<String, Parameter> parameterUpdates) {
        parameterUpdates.forEach((parameterName, parameter) -> {
            if (this.parameterProvider != null && parameter != null && !parameter.isProvided()) {
                throw new IllegalArgumentException(String.format("Cannot make user-entered updates to Parameter Context [%s] parameter [%s] because its parameters are provided by Parameter Provider [%s]", this.name, parameterName, this.parameterProvider.getIdentifier()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInheritedParameterContexts(List<ParameterContext> inheritedParameterContexts) {
        if (inheritedParameterContexts == null || inheritedParameterContexts.equals(this.inheritedParameterContexts)) {
            return;
        }
        this.verifyCanUpdateParameterContext(Collections.emptyMap(), inheritedParameterContexts, true);
        HashMap<String, ParameterUpdate> parameterUpdates = new HashMap<String, ParameterUpdate>();
        this.writeLock.lock();
        try {
            ++this.version;
            Map<ParameterDescriptor, Parameter> currentEffectiveParameters = this.getEffectiveParameters();
            Map<ParameterDescriptor, Parameter> effectiveProposedParameters = this.getEffectiveParameters(inheritedParameterContexts);
            Map<String, Parameter> effectiveParameterUpdates = this.getEffectiveParameterUpdates(currentEffectiveParameters, effectiveProposedParameters);
            this.inheritedParameterContexts.clear();
            this.inheritedParameterContexts.addAll(inheritedParameterContexts);
            parameterUpdates.putAll(this.updateParameters(currentEffectiveParameters, effectiveParameterUpdates, false));
        }
        finally {
            this.writeLock.unlock();
        }
        this.alertReferencingComponents(parameterUpdates);
    }

    private Map<String, Parameter> getEffectiveParameterUpdates(Map<ParameterDescriptor, Parameter> currentEffectiveParameters, Map<ParameterDescriptor, Parameter> effectiveProposedParameters) {
        HashMap<String, Parameter> effectiveParameterUpdates = new HashMap<String, Parameter>();
        for (Map.Entry<ParameterDescriptor, Parameter> entry : effectiveProposedParameters.entrySet()) {
            ParameterDescriptor proposedParameterDescriptor = entry.getKey();
            Parameter proposedParameter = entry.getValue();
            if (currentEffectiveParameters.containsKey(proposedParameterDescriptor)) {
                Parameter currentParameter = currentEffectiveParameters.get(proposedParameterDescriptor);
                if (currentParameter.equals((Object)proposedParameter) && currentParameter.getDescriptor().isSensitive() == proposedParameter.getDescriptor().isSensitive() && StringUtils.equals((CharSequence)currentParameter.getDescriptor().getDescription(), (CharSequence)proposedParameter.getDescriptor().getDescription())) continue;
                effectiveParameterUpdates.put(proposedParameterDescriptor.getName(), proposedParameter);
                continue;
            }
            effectiveParameterUpdates.put(proposedParameterDescriptor.getName(), proposedParameter);
        }
        for (Map.Entry<ParameterDescriptor, Parameter> entry : currentEffectiveParameters.entrySet()) {
            ParameterDescriptor currentParameterDescriptor = entry.getKey();
            if (effectiveProposedParameters.containsKey(currentParameterDescriptor)) continue;
            Parameter parameter = entry.getValue();
            if (parameter.isProvided() && this.hasReferencingComponents(parameter)) {
                logger.info("Provided parameter [{}] was removed from the source, but it is referenced by a component, so the parameter will be preserved", (Object)currentParameterDescriptor.getName());
                continue;
            }
            effectiveParameterUpdates.put(currentParameterDescriptor.getName(), null);
        }
        return effectiveParameterUpdates;
    }

    private boolean hasReferencingComponents(Parameter parameter) {
        if (parameter == null) {
            return false;
        }
        String parameterName = parameter.getDescriptor().getName();
        return this.parameterReferenceManager.getProcessorsReferencing((ParameterContext)this, parameterName).size() > 0 || this.parameterReferenceManager.getControllerServicesReferencing((ParameterContext)this, parameterName).size() > 0;
    }

    public List<ParameterContext> getInheritedParameterContexts() {
        this.readLock.lock();
        try {
            ArrayList<ParameterContext> arrayList = new ArrayList<ParameterContext>(this.inheritedParameterContexts);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<String> getInheritedParameterContextNames() {
        this.readLock.lock();
        try {
            List<String> list = this.inheritedParameterContexts.stream().map(ParameterContext::getName).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inheritsFrom(String parameterContextId) {
        this.readLock.lock();
        try {
            if (!this.inheritedParameterContexts.isEmpty()) {
                for (ParameterContext inheritedParameterContext : this.inheritedParameterContexts) {
                    if (inheritedParameterContext.getIdentifier().equals(parameterContextId)) {
                        boolean bl = true;
                        return bl;
                    }
                    if (!inheritedParameterContext.inheritsFrom(parameterContextId)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void verifyCanSetParameters(Map<String, Parameter> updatedParameters) {
        this.verifyCanSetParameters(updatedParameters, false);
    }

    private void verifyCanSetParameters(Map<String, Parameter> updatedParameters, boolean duringUpdate) {
        this.verifyCanSetParameters(this.parameters, updatedParameters, duringUpdate);
    }

    public void verifyCanSetParameters(Map<ParameterDescriptor, Parameter> currentParameters, Map<String, Parameter> updatedParameters, boolean duringUpdate) {
        boolean updatingUserEnteredParameters = updatedParameters.values().stream().anyMatch(parameter -> parameter != null && !parameter.isProvided());
        if (this.parameterProvider != null && updatingUserEnteredParameters) {
            throw new IllegalArgumentException(String.format("Parameters for Context [%s] cannot be manually updated because they are provided by Parameter Provider [%s]", this.name, this.parameterProvider.getIdentifier()));
        }
        for (Map.Entry<String, Parameter> entry : updatedParameters.entrySet()) {
            String parameterName = entry.getKey();
            Parameter parameter2 = entry.getValue();
            if (parameter2 == null) {
                this.validateReferencingComponents(parameterName, null, duringUpdate);
                continue;
            }
            if (!Objects.equals(parameterName, parameter2.getDescriptor().getName())) {
                throw new IllegalArgumentException("Parameter '" + parameterName + "' was specified with the wrong key in the Map");
            }
            this.validateSensitiveFlag(currentParameters, parameter2);
            this.validateReferencingComponents(parameterName, parameter2, duringUpdate);
        }
    }

    private void validateSensitiveFlag(Map<ParameterDescriptor, Parameter> currentParameters, Parameter updatedParameter) {
        ParameterDescriptor updatedDescriptor = updatedParameter.getDescriptor();
        Parameter existingParameter = currentParameters.get(updatedDescriptor);
        if (existingParameter == null) {
            return;
        }
        ParameterDescriptor existingDescriptor = existingParameter.getDescriptor();
        if (existingDescriptor.isSensitive() != updatedDescriptor.isSensitive() && updatedParameter.getValue() != null) {
            String updatedSensitiveDescription;
            String existingSensitiveDescription = existingDescriptor.isSensitive() ? "sensitive" : "not sensitive";
            String string = updatedSensitiveDescription = updatedDescriptor.isSensitive() ? "sensitive" : "not sensitive";
            if (existingParameter.isProvided() && updatedParameter.isProvided()) {
                return;
            }
            throw new IllegalStateException("Cannot update Parameters because doing so would change Parameter '" + existingDescriptor.getName() + "' from " + existingSensitiveDescription + " to " + updatedSensitiveDescription);
        }
    }

    private void validateReferencingComponents(String parameterName, Parameter parameter, boolean duringUpdate) {
        boolean isDeletion = parameter == null;
        String action = isDeletion ? "remove" : "update";
        for (ProcessorNode procNode : this.parameterReferenceManager.getProcessorsReferencing((ParameterContext)this, parameterName)) {
            if (procNode.isRunning() && (isDeletion || duringUpdate)) {
                throw new IllegalStateException("Cannot " + action + " parameter '" + parameterName + "' because it is referenced by " + procNode + ", which is currently running");
            }
            if (parameter == null) continue;
            this.validateParameterSensitivity(parameter, (ComponentNode)procNode);
        }
        for (ControllerServiceNode serviceNode : this.parameterReferenceManager.getControllerServicesReferencing((ParameterContext)this, parameterName)) {
            ControllerServiceState serviceState = serviceNode.getState();
            if (serviceState != ControllerServiceState.DISABLED && (isDeletion || duringUpdate)) {
                throw new IllegalStateException("Cannot " + action + " parameter '" + parameterName + "' because it is referenced by " + serviceNode + ", which currently has a state of " + serviceState);
            }
            if (parameter == null) continue;
            this.validateParameterSensitivity(parameter, (ComponentNode)serviceNode);
        }
    }

    private void validateParameterSensitivity(Parameter parameter, ComponentNode componentNode) {
        String paramName = parameter.getDescriptor().getName();
        for (Map.Entry entry : componentNode.getProperties().entrySet()) {
            PropertyConfiguration configuration = (PropertyConfiguration)entry.getValue();
            if (configuration == null) continue;
            for (ParameterReference reference : configuration.getParameterReferences()) {
                if (!parameter.getDescriptor().getName().equals(reference.getParameterName())) continue;
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getKey();
                if (propertyDescriptor.isSensitive() && !parameter.getDescriptor().isSensitive()) {
                    throw new IllegalStateException("Cannot add Parameter with name '" + paramName + "' unless that Parameter is Sensitive because a Parameter with that name is already referenced from a Sensitive Property");
                }
                if (propertyDescriptor.isSensitive() || !parameter.getDescriptor().isSensitive()) continue;
                throw new IllegalStateException("Cannot add Parameter with name '" + paramName + "' unless that Parameter is Not Sensitive because a Parameter with that name is already referenced from a Property that is not Sensitive");
            }
        }
    }

    public String toString() {
        return "StandardParameterContext[name=" + this.name + "]";
    }

    public void authorize(Authorizer authorizer, RequestAction action, NiFiUser user) throws AccessDeniedException {
        super.authorize(authorizer, action, user);
        if (RequestAction.READ == action) {
            for (ParameterContext parameterContext : this.inheritedParameterContexts) {
                parameterContext.authorize(authorizer, action, user);
            }
            if (this.parameterProvider != null) {
                this.authorizeParameterProviderRead(authorizer, this.parameterProvider, user);
            }
        }
    }

    public boolean isAuthorized(Authorizer authorizer, RequestAction action, NiFiUser user) {
        try {
            this.authorize(authorizer, action, user);
            return true;
        }
        catch (AccessDeniedException e) {
            return false;
        }
    }

    private void authorizeParameterProviderRead(Authorizer authorizer, ParameterProvider parameterProvider, NiFiUser user) {
        ParameterProviderNode parameterProviderNode = this.parameterProviderLookup.getParameterProvider(parameterProvider.getIdentifier());
        if (parameterProviderNode != null) {
            parameterProviderNode.authorize(authorizer, RequestAction.READ, user);
        }
    }

    public Authorizable getParentAuthorizable() {
        return new Authorizable(){

            public Authorizable getParentAuthorizable() {
                return StandardParameterContext.this.parentAuthorizable;
            }

            public Resource getResource() {
                return ResourceFactory.getParameterContextsResource();
            }
        };
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.ParameterContext, (String)this.getIdentifier(), (String)this.getName());
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(StandardParameterContext.class)) {
            StandardParameterContext other = (StandardParameterContext)obj;
            return this.getIdentifier().equals(other.getIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getClass().getName()).append((Object)this.getIdentifier()).toHashCode();
    }

    public static class Builder {
        private String id;
        private String name;
        private ParameterReferenceManager parameterReferenceManager;
        private Authorizable parentAuthorizable;
        private ParameterProviderLookup parameterProviderLookup;
        private ParameterProviderConfiguration parameterProviderConfiguration;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder parameterReferenceManager(ParameterReferenceManager parameterReferenceManager) {
            this.parameterReferenceManager = parameterReferenceManager;
            return this;
        }

        public Builder parentAuthorizable(Authorizable parentAuthorizable) {
            this.parentAuthorizable = parentAuthorizable;
            return this;
        }

        public Builder parameterProviderLookup(ParameterProviderLookup parameterProviderLookup) {
            this.parameterProviderLookup = parameterProviderLookup;
            return this;
        }

        public Builder parameterProviderConfiguration(ParameterProviderConfiguration parameterProviderConfiguration) {
            this.parameterProviderConfiguration = parameterProviderConfiguration;
            return this;
        }

        public StandardParameterContext build() {
            return new StandardParameterContext(this.id, this.name, this.parameterReferenceManager, this.parentAuthorizable, this.parameterProviderLookup, this.parameterProviderConfiguration);
        }
    }
}

