/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.state.manager;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.attribute.expression.language.VariableImpact;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceContext;
import org.apache.nifi.components.resource.ResourceReferenceFactory;
import org.apache.nifi.components.resource.StandardResourceContext;
import org.apache.nifi.components.resource.StandardResourceReferenceFactory;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.components.state.StateProvider;
import org.apache.nifi.components.state.StateProviderInitializationContext;
import org.apache.nifi.components.state.annotation.StateProviderContext;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.state.ConfigParseException;
import org.apache.nifi.controller.state.StandardStateManager;
import org.apache.nifi.controller.state.StandardStateProviderInitializationContext;
import org.apache.nifi.controller.state.config.StateManagerConfiguration;
import org.apache.nifi.controller.state.config.StateProviderConfiguration;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.ExpressionLanguageAwareParameterParser;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.parameter.ParameterTokenList;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.processor.StandardValidationContext;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.security.util.StandardTlsConfiguration;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardStateManagerProvider
implements StateManagerProvider {
    private static final Logger logger = LoggerFactory.getLogger(StandardStateManagerProvider.class);
    private static StateManagerProvider provider;
    private static NiFiProperties nifiProperties;
    private final ConcurrentMap<String, StateManager> stateManagers = new ConcurrentHashMap<String, StateManager>();
    private final StateProvider localStateProvider;
    private final StateProvider clusterStateProvider;

    public StandardStateManagerProvider(StateProvider localStateProvider, StateProvider clusterStateProvider) {
        this.localStateProvider = localStateProvider;
        this.clusterStateProvider = clusterStateProvider;
    }

    protected StateProvider getLocalStateProvider() {
        return this.localStateProvider;
    }

    protected StateProvider getClusterStateProvider() {
        return this.clusterStateProvider;
    }

    public static synchronized StateManagerProvider create(NiFiProperties properties, VariableRegistry variableRegistry, ExtensionManager extensionManager, ParameterLookup parameterLookup) throws ConfigParseException, IOException {
        nifiProperties = properties;
        if (provider != null) {
            return provider;
        }
        StateProvider localProvider = StandardStateManagerProvider.createLocalStateProvider(properties, variableRegistry, extensionManager, parameterLookup);
        StateProvider clusterProvider = properties.isNode() ? StandardStateManagerProvider.createClusteredStateProvider(properties, variableRegistry, extensionManager, parameterLookup) : null;
        provider = new StandardStateManagerProvider(localProvider, clusterProvider);
        return provider;
    }

    public static synchronized void resetProvider() {
        provider = null;
    }

    private static StateProvider createLocalStateProvider(NiFiProperties properties, VariableRegistry variableRegistry, ExtensionManager extensionManager, ParameterLookup parameterLookup) throws IOException, ConfigParseException {
        File configFile = properties.getStateManagementConfigFile();
        return StandardStateManagerProvider.createStateProvider(configFile, Scope.LOCAL, properties, variableRegistry, extensionManager, parameterLookup);
    }

    private static StateProvider createClusteredStateProvider(NiFiProperties properties, VariableRegistry variableRegistry, ExtensionManager extensionManager, ParameterLookup parameterLookup) throws IOException, ConfigParseException {
        File configFile = properties.getStateManagementConfigFile();
        return StandardStateManagerProvider.createStateProvider(configFile, Scope.CLUSTER, properties, variableRegistry, extensionManager, parameterLookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StateProvider createStateProvider(File configFile, Scope scope, NiFiProperties properties, VariableRegistry variableRegistry, ExtensionManager extensionManager, ParameterLookup parameterLookup) throws ConfigParseException, IOException {
        PropertyDescriptor descriptor;
        PropertyConfiguration configuration;
        VariableImpact variableImpact;
        ParameterTokenList references;
        SSLContext sslContext;
        StateProvider provider;
        String oppositeScopeXmlElementName;
        String providerXmlElementName;
        String providerDescription;
        String providerIdPropertyName;
        String providerId;
        switch (scope) {
            case CLUSTER: {
                providerId = properties.getClusterStateProviderId();
                providerIdPropertyName = "nifi.state.management.provider.cluster";
                providerDescription = "Cluster State Provider";
                providerXmlElementName = "cluster-provider";
                oppositeScopeXmlElementName = "local-provider";
                break;
            }
            case LOCAL: {
                providerId = properties.getLocalStateProviderId();
                providerIdPropertyName = "nifi.state.management.provider.local";
                providerDescription = "Local State Provider";
                providerXmlElementName = "local-provider";
                oppositeScopeXmlElementName = "cluster-provider";
                break;
            }
            default: {
                throw new AssertionError((Object)("Attempted to create State Provider for unknown Scope: " + scope));
            }
        }
        if (!configFile.exists()) {
            throw new IllegalStateException("Cannot create " + providerDescription + " because the State Management Configuration File " + configFile + " does not exist");
        }
        if (!configFile.canRead()) {
            throw new IllegalStateException("Cannot create " + providerDescription + " because the State Management Configuration File " + configFile + " cannot be read");
        }
        if (providerId == null) {
            if (scope == Scope.CLUSTER) {
                throw new IllegalStateException("Cannot create Cluster State Provider because the '" + providerIdPropertyName + "' property is missing from the NiFi Properties file. In order to run NiFi in a cluster, the " + providerIdPropertyName + " property must be configured in nifi.properties");
            }
            throw new IllegalStateException("Cannot create " + providerDescription + " because the '" + providerIdPropertyName + "' property is missing from the NiFi Properties file");
        }
        if (providerId.trim().isEmpty()) {
            throw new IllegalStateException("Cannot create " + providerDescription + " because the '" + providerIdPropertyName + "' property in the NiFi Properties file has no value set. This is a required property and must reference the identifier of one of the " + providerXmlElementName + " elements in the State Management Configuration File (" + configFile + ")");
        }
        StateManagerConfiguration config = StateManagerConfiguration.parse(configFile);
        StateProviderConfiguration providerConfig = config.getStateProviderConfiguration(providerId);
        if (providerConfig == null) {
            throw new IllegalStateException("Cannot create " + providerDescription + " because the '" + providerIdPropertyName + "' property in the NiFi Properties file is set to '" + providerId + "', but there is no " + providerXmlElementName + " entry in the State Management Configuration File (" + configFile + ") with this id");
        }
        if (providerConfig.getScope() != scope) {
            throw new IllegalStateException("Cannot create " + providerDescription + " because the '" + providerIdPropertyName + "' property in the NiFi Properties file is set to '" + providerId + "', but this id is assigned to a " + oppositeScopeXmlElementName + " entry in the State Management Configuration File (" + configFile + "), rather than a " + providerXmlElementName + " entry");
        }
        String providerClassName = providerConfig.getClassName();
        try {
            provider = StandardStateManagerProvider.instantiateStateProvider(extensionManager, providerClassName);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create " + providerDescription + " of type " + providerClassName, e);
        }
        if (!ArrayUtils.contains((Object[])provider.getSupportedScopes(), (Object)scope)) {
            throw new RuntimeException("Cannot use " + providerDescription + " (" + providerClassName + ") as it only supports scope(s) " + ArrayUtils.toString((Object)provider.getSupportedScopes()) + " but instance is configured to use scope " + scope);
        }
        TlsConfiguration standardTlsConfiguration = StandardTlsConfiguration.fromNiFiProperties((NiFiProperties)properties);
        try {
            sslContext = SslContextFactory.createSslContext((TlsConfiguration)standardTlsConfiguration);
        }
        catch (TlsException e) {
            logger.error("Encountered an error configuring TLS for state manager: ", (Throwable)e);
            throw new IllegalStateException("Error configuring TLS for state manager", e);
        }
        ExpressionLanguageAwareParameterParser parser = new ExpressionLanguageAwareParameterParser();
        HashMap<PropertyDescriptor, PropertyValue> propertyMap = new HashMap<PropertyDescriptor, PropertyValue>();
        HashMap<PropertyDescriptor, PropertyConfiguration> propertyStringMap = new HashMap<PropertyDescriptor, PropertyConfiguration>();
        StandardResourceReferenceFactory resourceReferenceFactory = new StandardResourceReferenceFactory();
        for (PropertyDescriptor propertyDescriptor : provider.getPropertyDescriptors()) {
            StandardResourceContext resourceContext = new StandardResourceContext((ResourceReferenceFactory)resourceReferenceFactory, propertyDescriptor);
            propertyMap.put(propertyDescriptor, (PropertyValue)new StandardPropertyValue((ResourceContext)resourceContext, propertyDescriptor.getDefaultValue(), null, parameterLookup, variableRegistry));
            references = parser.parseTokens(propertyDescriptor.getDefaultValue());
            variableImpact = Query.prepare((String)propertyDescriptor.getDefaultValue()).getVariableImpact();
            configuration = new PropertyConfiguration(propertyDescriptor.getDefaultValue(), references, references.toReferenceList(), variableImpact);
            propertyStringMap.put(propertyDescriptor, configuration);
        }
        for (Map.Entry entry : providerConfig.getProperties().entrySet()) {
            descriptor = provider.getPropertyDescriptor((String)entry.getKey());
            references = parser.parseTokens((String)entry.getValue());
            variableImpact = Query.prepare((String)((String)entry.getValue())).getVariableImpact();
            configuration = new PropertyConfiguration((String)entry.getValue(), references, references.toReferenceList(), variableImpact);
            propertyStringMap.put(descriptor, configuration);
            StandardResourceContext resourceContext = new StandardResourceContext((ResourceReferenceFactory)resourceReferenceFactory, descriptor);
            propertyMap.put(descriptor, (PropertyValue)new StandardPropertyValue((ResourceContext)resourceContext, (String)entry.getValue(), null, parameterLookup, variableRegistry));
        }
        SimpleProcessLogger logger = new SimpleProcessLogger(providerId, provider);
        StandardStateProviderInitializationContext standardStateProviderInitializationContext = new StandardStateProviderInitializationContext(providerId, propertyMap, sslContext, logger);
        descriptor = provider;
        synchronized (descriptor) {
            provider.initialize((StateProviderInitializationContext)standardStateProviderInitializationContext);
        }
        StandardValidationContext validationContext = new StandardValidationContext(null, propertyStringMap, null, null, null, variableRegistry, null, true);
        Collection results = provider.validate((ValidationContext)validationContext);
        StringBuilder validationFailures = new StringBuilder();
        int invalidCount = 0;
        for (ValidationResult result : results) {
            if (result.isValid()) continue;
            validationFailures.append(result.toString()).append("\n");
            ++invalidCount;
        }
        if (invalidCount > 0) {
            throw new IllegalStateException("Could not initialize State Providers because the " + providerDescription + " is not valid. The following " + invalidCount + " Validation Errors occurred:\n" + validationFailures.toString() + "\nPlease check the configuration of the " + providerDescription + " with ID [" + providerId.trim() + "] in the file " + configFile.getAbsolutePath());
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performMethodInjection(Object instance, Class stateProviderClass) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Method method : stateProviderClass.getMethods()) {
            if (!method.isAnnotationPresent(StateProviderContext.class)) continue;
            boolean isAccessible = method.isAccessible();
            method.setAccessible(true);
            try {
                Class<?> argumentType;
                Class<?>[] argumentTypes = method.getParameterTypes();
                if (argumentTypes.length != 1 || !NiFiProperties.class.isAssignableFrom(argumentType = argumentTypes[0])) continue;
                method.invoke(instance, nifiProperties);
            }
            finally {
                method.setAccessible(isAccessible);
            }
        }
        Class parentClass = stateProviderClass.getSuperclass();
        if (parentClass != null && StateProvider.class.isAssignableFrom(parentClass)) {
            StandardStateManagerProvider.performMethodInjection(instance, parentClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StateProvider instantiateStateProvider(ExtensionManager extensionManager, String type) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            List bundles = extensionManager.getBundles(type);
            if (bundles.size() == 0) {
                throw new IllegalStateException(String.format("The specified class '%s' is not known to this nifi.", type));
            }
            if (bundles.size() > 1) {
                throw new IllegalStateException(String.format("Multiple bundles found for the specified class '%s', only one is allowed.", type));
            }
            Bundle bundle = (Bundle)bundles.get(0);
            ClassLoader detectedClassLoaderForType = bundle.getClassLoader();
            Class<?> rawClass = Class.forName(type, true, detectedClassLoaderForType);
            Thread.currentThread().setContextClassLoader(detectedClassLoaderForType);
            Class<StateProvider> mgrClass = rawClass.asSubclass(StateProvider.class);
            StateProvider provider = mgrClass.newInstance();
            try {
                StandardStateManagerProvider.performMethodInjection(provider, mgrClass);
            }
            catch (InvocationTargetException e) {
                logger.error(String.format("Failed to inject nifi.properties to the '%s' state provider.", type), (Throwable)e);
            }
            StateProvider stateProvider = StandardStateManagerProvider.withNarClassLoader(provider);
            return stateProvider;
        }
        finally {
            if (ctxClassLoader != null) {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
        }
    }

    private static StateProvider withNarClassLoader(final StateProvider stateProvider) {
        return new StateProvider(){

            public void initialize(StateProviderInitializationContext context) throws IOException {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    stateProvider.initialize(context);
                }
            }

            public void shutdown() {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    stateProvider.shutdown();
                }
            }

            public void setState(Map<String, String> state, String componentId) throws IOException {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    stateProvider.setState(state, componentId);
                }
            }

            public StateMap getState(String componentId) throws IOException {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    StateMap stateMap = stateProvider.getState(componentId);
                    return stateMap;
                }
            }

            public boolean replace(StateMap oldValue, Map<String, String> newValue, String componentId) throws IOException {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    boolean bl = stateProvider.replace(oldValue, newValue, componentId);
                    return bl;
                }
            }

            public void clear(String componentId) throws IOException {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    stateProvider.clear(componentId);
                }
            }

            public void onComponentRemoved(String componentId) throws IOException {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    stateProvider.onComponentRemoved(componentId);
                }
            }

            public void enable() {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    stateProvider.enable();
                }
            }

            public void disable() {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    stateProvider.disable();
                }
            }

            public boolean isEnabled() {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    boolean bl = stateProvider.isEnabled();
                    return bl;
                }
            }

            public Scope[] getSupportedScopes() {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    Scope[] scopeArray = stateProvider.getSupportedScopes();
                    return scopeArray;
                }
            }

            public Collection<ValidationResult> validate(ValidationContext context) {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    Collection collection = stateProvider.validate(context);
                    return collection;
                }
            }

            public PropertyDescriptor getPropertyDescriptor(String name) {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    PropertyDescriptor propertyDescriptor = stateProvider.getPropertyDescriptor(name);
                    return propertyDescriptor;
                }
            }

            public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    stateProvider.onPropertyModified(descriptor, oldValue, newValue);
                }
            }

            public List<PropertyDescriptor> getPropertyDescriptors() {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    List list = stateProvider.getPropertyDescriptors();
                    return list;
                }
            }

            public String getIdentifier() {
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    String string = stateProvider.getIdentifier();
                    return string;
                }
            }
        };
    }

    public synchronized StateManager getStateManager(String componentId) {
        StateManager stateManager = (StateManager)this.stateManagers.get(componentId);
        if (stateManager != null) {
            return stateManager;
        }
        stateManager = new StandardStateManager(this.localStateProvider, this.clusterStateProvider, componentId);
        this.stateManagers.put(componentId, stateManager);
        return stateManager;
    }

    public synchronized void shutdown() {
        this.localStateProvider.shutdown();
        if (this.clusterStateProvider != null) {
            this.clusterStateProvider.shutdown();
        }
    }

    public void enableClusterProvider() {
        this.clusterStateProvider.enable();
    }

    public void disableClusterProvider() {
        this.clusterStateProvider.disable();
    }

    public void onComponentRemoved(String componentId) {
        StateManager mgr = (StateManager)this.stateManagers.remove(componentId);
        if (mgr == null) {
            return;
        }
        try {
            mgr.clear(Scope.CLUSTER);
        }
        catch (Exception e) {
            logger.warn("Component with ID {} was removed from NiFi instance but failed to clear clustered state for the component", (Object)componentId, (Object)e);
        }
        try {
            mgr.clear(Scope.LOCAL);
        }
        catch (Exception e) {
            logger.warn("Component with ID {} was removed from NiFi instance but failed to clear local state for the component", (Object)componentId, (Object)e);
        }
        try {
            this.localStateProvider.onComponentRemoved(componentId);
        }
        catch (Exception e) {
            logger.warn("Component with ID {} was removed from NiFi instance but failed to cleanup resources used to maintain its local state", (Object)componentId, (Object)e);
        }
        if (this.clusterStateProvider != null) {
            try {
                this.clusterStateProvider.onComponentRemoved(componentId);
            }
            catch (Exception e) {
                logger.warn("Component with ID {} was removed from NiFi instance but failed to cleanup resources used to maintain its clustered state", (Object)componentId, (Object)e);
            }
        }
    }
}

