/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.flow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.parameter.ParameterProviderLookup;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterContextManager;
import org.apache.nifi.parameter.ParameterProviderConfiguration;
import org.apache.nifi.parameter.ReferenceOnlyParameterContext;
import org.apache.nifi.parameter.StandardParameterContext;
import org.apache.nifi.parameter.StandardParameterReferenceManager;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.util.ReflectionUtils;

public abstract class AbstractFlowManager
implements FlowManager {
    private final ConcurrentMap<String, ProcessGroup> allProcessGroups = new ConcurrentHashMap<String, ProcessGroup>();
    private final ConcurrentMap<String, ProcessorNode> allProcessors = new ConcurrentHashMap<String, ProcessorNode>();
    private final ConcurrentMap<String, Connection> allConnections = new ConcurrentHashMap<String, Connection>();
    private final ConcurrentMap<String, Port> allInputPorts = new ConcurrentHashMap<String, Port>();
    private final ConcurrentMap<String, Port> allOutputPorts = new ConcurrentHashMap<String, Port>();
    private final ConcurrentMap<String, Funnel> allFunnels = new ConcurrentHashMap<String, Funnel>();
    private final ConcurrentMap<String, ReportingTaskNode> allReportingTasks = new ConcurrentHashMap<String, ReportingTaskNode>();
    private final ConcurrentMap<String, ParameterProviderNode> allParameterProviders = new ConcurrentHashMap<String, ParameterProviderNode>();
    private final ConcurrentMap<String, FlowRegistryClientNode> allFlowRegistryClients = new ConcurrentHashMap<String, FlowRegistryClientNode>();
    private final FlowFileEventRepository flowFileEventRepository;
    private final ParameterContextManager parameterContextManager;
    private final BooleanSupplier flowInitializedCheck;
    private volatile ControllerServiceProvider controllerServiceProvider;
    private volatile ProcessGroup rootGroup;
    private final ThreadLocal<Boolean> withParameterContextResolution = ThreadLocal.withInitial(() -> false);

    public AbstractFlowManager(FlowFileEventRepository flowFileEventRepository, ParameterContextManager parameterContextManager, BooleanSupplier flowInitializedCheck) {
        this.flowFileEventRepository = flowFileEventRepository;
        this.parameterContextManager = parameterContextManager;
        this.flowInitializedCheck = flowInitializedCheck;
    }

    public void initialize(ControllerServiceProvider controllerServiceProvider) {
        this.controllerServiceProvider = controllerServiceProvider;
    }

    public ProcessGroup getGroup(String id) {
        return (ProcessGroup)this.allProcessGroups.get(Objects.requireNonNull(id));
    }

    public void onProcessGroupAdded(ProcessGroup group) {
        this.allProcessGroups.put(group.getIdentifier(), group);
    }

    public void onProcessGroupRemoved(ProcessGroup group) {
        this.allProcessGroups.remove(group.getIdentifier());
    }

    public void onProcessorAdded(ProcessorNode procNode) {
        this.allProcessors.put(procNode.getIdentifier(), procNode);
    }

    public void onProcessorRemoved(ProcessorNode procNode) {
        String identifier = procNode.getIdentifier();
        this.flowFileEventRepository.purgeTransferEvents(identifier);
        this.allProcessors.remove(identifier);
    }

    public Set<ProcessorNode> findAllProcessors(Predicate<ProcessorNode> filter) {
        return this.allProcessors.values().stream().filter(filter).collect(Collectors.toSet());
    }

    public Connectable findConnectable(String id) {
        ProcessorNode procNode = this.getProcessorNode(id);
        if (procNode != null) {
            return procNode;
        }
        Port inPort = this.getInputPort(id);
        if (inPort != null) {
            return inPort;
        }
        Port outPort = this.getOutputPort(id);
        if (outPort != null) {
            return outPort;
        }
        Funnel funnel = this.getFunnel(id);
        if (funnel != null) {
            return funnel;
        }
        RemoteGroupPort remoteGroupPort = this.getRootGroup().findRemoteGroupPort(id);
        return remoteGroupPort;
    }

    public ProcessorNode getProcessorNode(String id) {
        return (ProcessorNode)this.allProcessors.get(id);
    }

    public void onConnectionAdded(Connection connection) {
        this.allConnections.put(connection.getIdentifier(), connection);
        if (this.isFlowInitialized()) {
            connection.getFlowFileQueue().startLoadBalancing();
        }
    }

    protected boolean isFlowInitialized() {
        return this.flowInitializedCheck.getAsBoolean();
    }

    public void onConnectionRemoved(Connection connection) {
        String identifier = connection.getIdentifier();
        this.flowFileEventRepository.purgeTransferEvents(identifier);
        this.allConnections.remove(identifier);
    }

    public Connection getConnection(String id) {
        return (Connection)this.allConnections.get(id);
    }

    public Set<Connection> findAllConnections() {
        return new HashSet<Connection>(this.allConnections.values());
    }

    public void setRootGroup(ProcessGroup rootGroup) {
        if (this.rootGroup != null && this.rootGroup.isEmpty()) {
            this.allProcessGroups.remove(this.rootGroup.getIdentifier());
        }
        this.rootGroup = rootGroup;
        this.allProcessGroups.put("root", rootGroup);
        this.allProcessGroups.put(rootGroup.getIdentifier(), rootGroup);
    }

    public ProcessGroup getRootGroup() {
        return this.rootGroup;
    }

    public String getRootGroupId() {
        return this.rootGroup.getIdentifier();
    }

    public boolean areGroupsSame(String id1, String id2) {
        if (id1 == null || id2 == null) {
            return false;
        }
        if (id1.equals(id2)) {
            return true;
        }
        String comparable1 = id1.equals("root") ? this.getRootGroupId() : id1;
        String comparable2 = id2.equals("root") ? this.getRootGroupId() : id2;
        return comparable1.equals(comparable2);
    }

    public Map<String, Integer> getComponentCounts() {
        LinkedHashMap<String, Integer> componentCounts = new LinkedHashMap<String, Integer>();
        componentCounts.put("Processors", this.allProcessors.size());
        componentCounts.put("Controller Services", this.getAllControllerServices().size());
        componentCounts.put("Reporting Tasks", this.getAllReportingTasks().size());
        componentCounts.put("Process Groups", this.allProcessGroups.size() - 2);
        componentCounts.put("Remote Process Groups", this.getRootGroup().findAllRemoteProcessGroups().size());
        componentCounts.put("Parameter Providers", this.getAllParameterProviders().size());
        componentCounts.put("Flow Registry Clients", this.getAllFlowRegistryClients().size());
        int localInputPorts = 0;
        int publicInputPorts = 0;
        for (Port port : this.allInputPorts.values()) {
            if (port instanceof PublicPort) {
                ++publicInputPorts;
                continue;
            }
            ++localInputPorts;
        }
        int localOutputPorts = 0;
        int publicOutputPorts = 0;
        for (Port port : this.allOutputPorts.values()) {
            if (port instanceof PublicPort) {
                ++localOutputPorts;
                continue;
            }
            ++publicOutputPorts;
        }
        componentCounts.put("Local Input Ports", localInputPorts);
        componentCounts.put("Local Output Ports", localOutputPorts);
        componentCounts.put("Public Input Ports", publicInputPorts);
        componentCounts.put("Public Output Ports", publicOutputPorts);
        return componentCounts;
    }

    public void purge() {
        this.verifyCanPurge();
        ProcessGroup rootGroup = this.getRootGroup();
        for (ProcessGroup group : rootGroup.findAllProcessGroups()) {
            group.getTemplates().forEach(arg_0 -> ((ProcessGroup)group).removeTemplate(arg_0));
        }
        rootGroup.getTemplates().forEach(arg_0 -> ((ProcessGroup)rootGroup).removeTemplate(arg_0));
        rootGroup.getConnections().forEach(arg_0 -> ((ProcessGroup)rootGroup).removeConnection(arg_0));
        rootGroup.getProcessors().forEach(arg_0 -> ((ProcessGroup)rootGroup).removeProcessor(arg_0));
        rootGroup.getFunnels().forEach(arg_0 -> ((ProcessGroup)rootGroup).removeFunnel(arg_0));
        rootGroup.getInputPorts().forEach(arg_0 -> ((ProcessGroup)rootGroup).removeInputPort(arg_0));
        rootGroup.getOutputPorts().forEach(arg_0 -> ((ProcessGroup)rootGroup).removeOutputPort(arg_0));
        rootGroup.getLabels().forEach(arg_0 -> ((ProcessGroup)rootGroup).removeLabel(arg_0));
        rootGroup.getRemoteProcessGroups().forEach(arg_0 -> ((ProcessGroup)rootGroup).removeRemoteProcessGroup(arg_0));
        rootGroup.getProcessGroups().forEach(arg_0 -> ((ProcessGroup)rootGroup).removeProcessGroup(arg_0));
        rootGroup.getControllerServices(false).forEach(arg_0 -> ((ControllerServiceProvider)this.controllerServiceProvider).removeControllerService(arg_0));
        this.getRootControllerServices().forEach(arg_0 -> ((AbstractFlowManager)this).removeRootControllerService(arg_0));
        this.getAllReportingTasks().forEach(this::removeReportingTask);
        this.getAllParameterProviders().forEach(this::removeParameterProvider);
        this.getAllFlowRegistryClients().forEach(arg_0 -> ((AbstractFlowManager)this).removeFlowRegistryClientNode(arg_0));
        for (ParameterContext parameterContext : this.parameterContextManager.getParameterContexts()) {
            this.parameterContextManager.removeParameterContext(parameterContext.getIdentifier());
        }
        LogRepositoryFactory.purge();
    }

    private void verifyCanPurge() {
        for (ControllerServiceNode serviceNode : this.getAllControllerServices()) {
            serviceNode.verifyCanDelete();
        }
        for (ReportingTaskNode reportingTask : this.getAllReportingTasks()) {
            reportingTask.verifyCanDelete();
        }
        for (ParameterProviderNode parameterProvider : this.getAllParameterProviders()) {
            parameterProvider.verifyCanDelete();
        }
        ProcessGroup rootGroup = this.getRootGroup();
        rootGroup.verifyCanDelete(true, true);
    }

    public Set<ControllerServiceNode> getAllControllerServices() {
        HashSet<ControllerServiceNode> allServiceNodes = new HashSet<ControllerServiceNode>();
        allServiceNodes.addAll(this.controllerServiceProvider.getNonRootControllerServices());
        allServiceNodes.addAll(this.getRootControllerServices());
        return allServiceNodes;
    }

    public ControllerServiceNode getControllerServiceNode(String id) {
        return this.controllerServiceProvider.getControllerServiceNode(id);
    }

    public void onInputPortAdded(Port inputPort) {
        this.allInputPorts.put(inputPort.getIdentifier(), inputPort);
    }

    public void onInputPortRemoved(Port inputPort) {
        String identifier = inputPort.getIdentifier();
        this.flowFileEventRepository.purgeTransferEvents(identifier);
        this.allInputPorts.remove(identifier);
    }

    public Port getInputPort(String id) {
        return (Port)this.allInputPorts.get(id);
    }

    public void onOutputPortAdded(Port outputPort) {
        this.allOutputPorts.put(outputPort.getIdentifier(), outputPort);
    }

    public void onOutputPortRemoved(Port outputPort) {
        String identifier = outputPort.getIdentifier();
        this.flowFileEventRepository.purgeTransferEvents(identifier);
        this.allOutputPorts.remove(identifier);
    }

    public Port getOutputPort(String id) {
        return (Port)this.allOutputPorts.get(id);
    }

    public void onFunnelAdded(Funnel funnel) {
        this.allFunnels.put(funnel.getIdentifier(), funnel);
    }

    public void onFunnelRemoved(Funnel funnel) {
        String identifier = funnel.getIdentifier();
        this.flowFileEventRepository.purgeTransferEvents(identifier);
        this.allFunnels.remove(identifier);
    }

    public Funnel getFunnel(String id) {
        return (Funnel)this.allFunnels.get(id);
    }

    public ProcessorNode createProcessor(String type, String id, BundleCoordinate coordinate) {
        return this.createProcessor(type, id, coordinate, true);
    }

    public ProcessorNode createProcessor(String type, String id, BundleCoordinate coordinate, boolean firstTimeAdded) {
        return this.createProcessor(type, id, coordinate, Collections.emptySet(), firstTimeAdded, true, null);
    }

    public ReportingTaskNode createReportingTask(String type, BundleCoordinate bundleCoordinate) {
        return this.createReportingTask(type, bundleCoordinate, true);
    }

    public ReportingTaskNode createReportingTask(String type, BundleCoordinate bundleCoordinate, boolean firstTimeAdded) {
        return this.createReportingTask(type, UUID.randomUUID().toString(), bundleCoordinate, firstTimeAdded);
    }

    public ReportingTaskNode createReportingTask(String type, String id, BundleCoordinate bundleCoordinate, boolean firstTimeAdded) {
        return this.createReportingTask(type, id, bundleCoordinate, Collections.emptySet(), firstTimeAdded, true, null);
    }

    public ReportingTaskNode getReportingTaskNode(String taskId) {
        return (ReportingTaskNode)this.allReportingTasks.get(taskId);
    }

    public ParameterProviderNode createParameterProvider(String type, String id, BundleCoordinate bundleCoordinate, boolean firstTimeAdded) {
        return this.createParameterProvider(type, id, bundleCoordinate, Collections.emptySet(), firstTimeAdded, true);
    }

    public void removeReportingTask(ReportingTaskNode reportingTaskNode) {
        ReportingTaskNode existing = (ReportingTaskNode)this.allReportingTasks.get(reportingTaskNode.getIdentifier());
        if (existing == null || existing != reportingTaskNode) {
            throw new IllegalStateException("Reporting Task " + reportingTaskNode + " does not exist in this Flow");
        }
        reportingTaskNode.verifyCanDelete();
        Class<?> taskClass = reportingTaskNode.getReportingTask().getClass();
        try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), taskClass, (String)reportingTaskNode.getReportingTask().getIdentifier());){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)reportingTaskNode.getReportingTask(), reportingTaskNode.getConfigurationContext());
        }
        for (Map.Entry entry : reportingTaskNode.getEffectivePropertyValues().entrySet()) {
            ControllerServiceNode serviceNode;
            String value;
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (descriptor.getControllerServiceDefinition() == null || (value = entry.getValue() == null ? descriptor.getDefaultValue() : (String)entry.getValue()) == null || (serviceNode = this.controllerServiceProvider.getControllerServiceNode(value)) == null) continue;
            serviceNode.removeReference((ComponentNode)reportingTaskNode, descriptor);
        }
        this.allReportingTasks.remove(reportingTaskNode.getIdentifier());
        LogRepositoryFactory.removeRepository((String)reportingTaskNode.getIdentifier());
        this.getProcessScheduler().onReportingTaskRemoved(reportingTaskNode);
        this.getExtensionManager().removeInstanceClassLoader(reportingTaskNode.getIdentifier());
    }

    public void onReportingTaskAdded(ReportingTaskNode taskNode) {
        this.allReportingTasks.put(taskNode.getIdentifier(), taskNode);
    }

    public ParameterProviderNode getParameterProvider(String id) {
        return id == null ? null : (ParameterProviderNode)this.allParameterProviders.get(id);
    }

    public void removeParameterProvider(ParameterProviderNode parameterProvider) {
        ParameterProviderNode existing = (ParameterProviderNode)this.allParameterProviders.get(parameterProvider.getIdentifier());
        if (existing == null || existing != parameterProvider) {
            throw new IllegalStateException("Parameter Provider " + parameterProvider + " does not exist in this Flow");
        }
        Class<?> taskClass = parameterProvider.getParameterProvider().getClass();
        try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), taskClass, (String)parameterProvider.getParameterProvider().getIdentifier());){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)parameterProvider.getParameterProvider(), parameterProvider.getConfigurationContext());
        }
        for (Map.Entry entry : parameterProvider.getEffectivePropertyValues().entrySet()) {
            ControllerServiceNode serviceNode;
            String value;
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (descriptor.getControllerServiceDefinition() == null || (value = entry.getValue() == null ? descriptor.getDefaultValue() : (String)entry.getValue()) == null || (serviceNode = this.controllerServiceProvider.getControllerServiceNode(value)) == null) continue;
            serviceNode.removeReference((ComponentNode)parameterProvider, descriptor);
        }
        this.allParameterProviders.remove(parameterProvider.getIdentifier());
        LogRepositoryFactory.removeRepository((String)parameterProvider.getIdentifier());
        this.getExtensionManager().removeInstanceClassLoader(parameterProvider.getIdentifier());
    }

    public Set<ParameterProviderNode> getAllParameterProviders() {
        return new HashSet<ParameterProviderNode>(this.allParameterProviders.values());
    }

    public void onParameterProviderAdded(ParameterProviderNode parameterProviderNode) {
        this.allParameterProviders.put(parameterProviderNode.getIdentifier(), parameterProviderNode);
    }

    protected abstract ExtensionManager getExtensionManager();

    protected abstract ProcessScheduler getProcessScheduler();

    public Set<ReportingTaskNode> getAllReportingTasks() {
        return new HashSet<ReportingTaskNode>(this.allReportingTasks.values());
    }

    public FlowRegistryClientNode getFlowRegistryClient(String id) {
        if (id == null) {
            return null;
        }
        return (FlowRegistryClientNode)this.allFlowRegistryClients.get(id);
    }

    public Set<FlowRegistryClientNode> getAllFlowRegistryClients() {
        return new HashSet<FlowRegistryClientNode>(this.allFlowRegistryClients.values());
    }

    public void onFlowRegistryClientAdded(FlowRegistryClientNode clientNode) {
        this.allFlowRegistryClients.put(clientNode.getIdentifier(), clientNode);
    }

    public void onFlowRegistryClientRemoved(FlowRegistryClientNode clientNode) {
        this.allFlowRegistryClients.remove(clientNode.getIdentifier());
    }

    public ParameterContextManager getParameterContextManager() {
        return this.parameterContextManager;
    }

    public ParameterContext createParameterContext(String id, String name, Map<String, Parameter> parameters, List<String> inheritedContextIds, ParameterProviderConfiguration parameterProviderConfiguration) {
        boolean namingConflict = this.parameterContextManager.getParameterContexts().stream().anyMatch(paramContext -> paramContext.getName().equals(name));
        if (namingConflict) {
            throw new IllegalStateException("Cannot create Parameter Context with name '" + name + "' because a Parameter Context already exists with that name");
        }
        StandardParameterReferenceManager referenceManager = new StandardParameterReferenceManager(this);
        StandardParameterContext parameterContext = new StandardParameterContext.Builder().id(id).name(name).parameterReferenceManager(referenceManager).parentAuthorizable(this.getParameterContextParent()).parameterProviderLookup((ParameterProviderLookup)this).parameterProviderConfiguration(parameterProviderConfiguration).build();
        parameterContext.setParameters(parameters);
        if (inheritedContextIds != null && !inheritedContextIds.isEmpty()) {
            if (!this.withParameterContextResolution.get().booleanValue()) {
                throw new IllegalStateException("A ParameterContext with inherited ParameterContexts may only be created from within a call to AbstractFlowManager#withParameterContextResolution");
            }
            ArrayList<ParameterContext> parameterContextList = new ArrayList<ParameterContext>();
            for (String inheritedContextId : inheritedContextIds) {
                parameterContextList.add(this.lookupParameterContext(inheritedContextId));
            }
            parameterContext.setInheritedParameterContexts(parameterContextList);
        }
        this.parameterContextManager.addParameterContext((ParameterContext)parameterContext);
        return parameterContext;
    }

    public void withParameterContextResolution(Runnable parameterContextAction) {
        this.withParameterContextResolution.set(true);
        try {
            parameterContextAction.run();
        }
        finally {
            this.withParameterContextResolution.set(false);
        }
        for (ParameterContext parameterContext : this.parameterContextManager.getParameterContexts()) {
            if (parameterContext instanceof ReferenceOnlyParameterContext) {
                throw new IllegalStateException(String.format("A Parameter Context tries to inherit from another Parameter Context [%s] that does not exist", parameterContext.getIdentifier()));
            }
            ArrayList<ParameterContext> inheritedParamContexts = new ArrayList<ParameterContext>();
            for (ParameterContext inheritedParamContext : parameterContext.getInheritedParameterContexts()) {
                if (inheritedParamContext instanceof ReferenceOnlyParameterContext) {
                    inheritedParamContexts.add(this.parameterContextManager.getParameterContext(inheritedParamContext.getIdentifier()));
                    continue;
                }
                inheritedParamContexts.add(inheritedParamContext);
            }
            parameterContext.setInheritedParameterContexts(inheritedParamContexts);
        }
        for (ParameterContext parameterContext : this.parameterContextManager.getParameterContexts()) {
            for (ParameterContext inheritedParamContext : parameterContext.getInheritedParameterContexts()) {
                if (!(inheritedParamContext instanceof ReferenceOnlyParameterContext)) continue;
                throw new IllegalStateException(String.format("Parameter Context [%s] tries to inherit from a Parameter Context [%s] that does not exist", parameterContext.getName(), inheritedParamContext.getIdentifier()));
            }
        }
    }

    private ParameterContext lookupParameterContext(String id) {
        if (!this.parameterContextManager.hasParameterContext(id)) {
            this.parameterContextManager.addParameterContext((ParameterContext)new ReferenceOnlyParameterContext(id));
        }
        return this.parameterContextManager.getParameterContext(id);
    }

    protected abstract Authorizable getParameterContextParent();
}

