/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.VersionedComponent;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterReference;
import org.apache.nifi.parameter.ParameterReferenceManager;
import org.apache.nifi.parameter.ParameterReferencedControllerServiceData;

public class StandardParameterReferenceManager
implements ParameterReferenceManager {
    private final FlowManager flowManager;

    public StandardParameterReferenceManager(FlowManager flowManager) {
        this.flowManager = flowManager;
    }

    public Set<ProcessorNode> getProcessorsReferencing(ParameterContext parameterContext, String parameterName) {
        return this.getComponentsReferencing(parameterContext, parameterName, ProcessGroup::getProcessors);
    }

    public Set<ControllerServiceNode> getControllerServicesReferencing(ParameterContext parameterContext, String parameterName) {
        return this.getComponentsReferencing(parameterContext, parameterName, group -> group.getControllerServices(false));
    }

    public List<ParameterReferencedControllerServiceData> getReferencedControllerServiceData(ParameterContext parameterContext, String parameterName) {
        ArrayList<ParameterReferencedControllerServiceData> referencedControllerServiceData = new ArrayList<ParameterReferencedControllerServiceData>();
        String versionedServiceId = parameterContext.getParameter(parameterName).map(Parameter::getValue).map(arg_0 -> ((FlowManager)this.flowManager).getControllerServiceNode(arg_0)).flatMap(VersionedComponent::getVersionedComponentId).orElse(null);
        ProcessGroup rootGroup = this.flowManager.getRootGroup();
        List referencingGroups = rootGroup.findAllProcessGroups(group -> group.referencesParameterContext(parameterContext));
        for (ProcessGroup group2 : referencingGroups) {
            for (ProcessorNode processor : group2.getProcessors()) {
                referencedControllerServiceData.addAll(this.getReferencedControllerServiceData((ComponentNode)processor, parameterName, versionedServiceId));
            }
            for (ControllerServiceNode controllerService : group2.getControllerServices(false)) {
                referencedControllerServiceData.addAll(this.getReferencedControllerServiceData((ComponentNode)controllerService, parameterName, versionedServiceId));
            }
        }
        return referencedControllerServiceData;
    }

    public Set<ProcessGroup> getProcessGroupsBound(ParameterContext parameterContext) {
        ProcessGroup rootGroup = this.flowManager.getRootGroup();
        List referencingGroups = rootGroup.findAllProcessGroups(group -> group.referencesParameterContext(parameterContext));
        return new HashSet<ProcessGroup>(referencingGroups);
    }

    private <T extends ComponentNode> Set<T> getComponentsReferencing(ParameterContext parameterContext, String parameterName, Function<ProcessGroup, Collection<T>> componentFunction) {
        HashSet<ComponentNode> referencingComponents = new HashSet<ComponentNode>();
        ProcessGroup rootGroup = this.flowManager.getRootGroup();
        List referencingGroups = rootGroup.findAllProcessGroups(group -> group.referencesParameterContext(parameterContext));
        for (ProcessGroup group2 : referencingGroups) {
            for (ComponentNode componentNode : componentFunction.apply(group2)) {
                if (!componentNode.isReferencingParameter(parameterName)) continue;
                referencingComponents.add(componentNode);
            }
        }
        return referencingComponents;
    }

    private Set<ParameterReferencedControllerServiceData> getReferencedControllerServiceData(ComponentNode componentNode, String parameterName, String versionedServiceId) {
        HashSet<ParameterReferencedControllerServiceData> referencedControllerServiceTypes = new HashSet<ParameterReferencedControllerServiceData>();
        for (Map.Entry propertyDescriptorAndPropertyConfiguration : componentNode.getProperties().entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)propertyDescriptorAndPropertyConfiguration.getKey();
            PropertyConfiguration configuration = (PropertyConfiguration)propertyDescriptorAndPropertyConfiguration.getValue();
            Class referencedControllerServiceType = descriptor.getControllerServiceDefinition();
            if (referencedControllerServiceType == null || configuration == null) continue;
            for (ParameterReference reference : configuration.getParameterReferences()) {
                if (!parameterName.equals(reference.getParameterName())) continue;
                referencedControllerServiceTypes.add(new ParameterReferencedControllerServiceData(parameterName, componentNode, descriptor, referencedControllerServiceType, versionedServiceId));
            }
        }
        return referencedControllerServiceTypes;
    }
}

