/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogMessage;
import org.apache.nifi.logging.LogRepository;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleProcessLogger
implements ComponentLog {
    private static final String CAUSED_BY = String.format("%n- Caused by: ", new Object[0]);
    private static final Throwable NULL_THROWABLE = null;
    private final Logger logger;
    private final LogRepository logRepository;
    private final Object component;

    public SimpleProcessLogger(String componentId, Object component) {
        this(component, LogRepositoryFactory.getRepository((String)componentId));
    }

    public SimpleProcessLogger(Object component, LogRepository logRepository) {
        this.logger = LoggerFactory.getLogger(component.getClass());
        this.logRepository = logRepository;
        this.component = component;
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            String componentMessage = this.getComponentMessage(msg);
            Object[] repositoryArguments = this.getRepositoryArguments(t);
            if (t == null) {
                this.logger.warn(componentMessage, this.component);
                this.logRepository.addLogMessage(LogLevel.WARN, componentMessage, repositoryArguments);
            } else {
                this.logger.warn(componentMessage, this.component, (Object)t);
                this.logRepository.addLogMessage(LogLevel.WARN, this.getCausesMessage(msg), repositoryArguments, t);
            }
        }
    }

    public void warn(String msg, Object[] os) {
        if (this.isWarnEnabled()) {
            String componentMessage = this.getComponentMessage(msg);
            Object[] arguments = this.insertComponent(os);
            Throwable lastThrowable = this.findLastThrowable(os);
            if (lastThrowable == null) {
                this.logger.warn(componentMessage, arguments);
                this.logRepository.addLogMessage(LogLevel.WARN, componentMessage, arguments);
            } else {
                this.logger.warn(componentMessage, this.setFormattedThrowable(arguments, lastThrowable));
                this.logRepository.addLogMessage(LogLevel.WARN, this.getCausesMessage(msg), this.setCauses(arguments, lastThrowable), lastThrowable);
            }
        }
    }

    public void warn(String msg, Object[] os, Throwable t) {
        if (this.isWarnEnabled()) {
            String componentMessage = this.getComponentMessage(msg);
            Object[] arguments = this.insertComponent(os);
            if (t == null) {
                this.logger.warn(componentMessage, arguments);
                this.logRepository.addLogMessage(LogLevel.WARN, componentMessage, arguments);
            } else {
                this.logger.warn(componentMessage, (Object)arguments, (Object)t);
                this.logRepository.addLogMessage(LogLevel.WARN, this.getCausesMessage(msg), this.addCauses(arguments, t), t);
            }
        }
    }

    public void warn(String msg) {
        this.warn(msg, NULL_THROWABLE);
    }

    public void warn(LogMessage logMessage) {
        if (this.isWarnEnabled()) {
            this.log(LogLevel.WARN, logMessage);
            this.logRepository.addLogMessage(logMessage);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            String componentMessage = this.getComponentMessage(msg);
            Object[] repositoryArguments = this.getRepositoryArguments(t);
            if (t == null) {
                this.logger.trace(componentMessage, this.component);
                this.logRepository.addLogMessage(LogLevel.TRACE, componentMessage, repositoryArguments);
            } else {
                this.logger.trace(componentMessage, this.component, (Object)t);
                this.logRepository.addLogMessage(LogLevel.TRACE, this.getCausesMessage(msg), repositoryArguments, t);
            }
        }
    }

    public void trace(String msg, Object[] os) {
        if (this.isTraceEnabled()) {
            String componentMessage = this.getComponentMessage(msg);
            Object[] arguments = this.insertComponent(os);
            Throwable lastThrowable = this.findLastThrowable(os);
            if (lastThrowable == null) {
                this.logger.trace(componentMessage, arguments);
                this.logRepository.addLogMessage(LogLevel.TRACE, componentMessage, arguments);
            } else {
                this.logger.trace(componentMessage, this.setFormattedThrowable(arguments, lastThrowable));
                this.logRepository.addLogMessage(LogLevel.TRACE, this.getCausesMessage(msg), this.setCauses(arguments, lastThrowable), lastThrowable);
            }
        }
    }

    public void trace(String msg) {
        this.trace(msg, NULL_THROWABLE);
    }

    public void trace(String msg, Object[] os, Throwable t) {
        if (this.isTraceEnabled()) {
            String componentMessage = this.getComponentMessage(msg);
            Object[] arguments = this.insertComponent(os);
            if (t == null) {
                this.logger.trace(componentMessage, arguments);
                this.logRepository.addLogMessage(LogLevel.TRACE, componentMessage, arguments);
            } else {
                this.logger.trace(componentMessage, (Object)arguments, (Object)t);
                this.logRepository.addLogMessage(LogLevel.TRACE, this.getCausesMessage(msg), this.addCauses(arguments, t), t);
            }
        }
    }

    public void trace(LogMessage logMessage) {
        if (this.isTraceEnabled()) {
            this.log(LogLevel.TRACE, logMessage);
            this.logRepository.addLogMessage(logMessage);
        }
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled() || this.logRepository.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled() || this.logRepository.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled() || this.logRepository.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled() || this.logRepository.isErrorEnabled();
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            String componentMessage = this.getComponentMessage(msg);
            Object[] repositoryArguments = this.getRepositoryArguments(t);
            if (t == null) {
                this.logger.info(componentMessage, this.component);
                this.logRepository.addLogMessage(LogLevel.INFO, componentMessage, repositoryArguments);
            } else {
                this.logger.info(componentMessage, this.component, (Object)t);
                this.logRepository.addLogMessage(LogLevel.INFO, this.getCausesMessage(msg), repositoryArguments, t);
            }
        }
    }

    public void info(String msg, Object[] os) {
        if (this.isInfoEnabled()) {
            String componentMessage = this.getComponentMessage(msg);
            Object[] arguments = this.insertComponent(os);
            Throwable lastThrowable = this.findLastThrowable(os);
            if (lastThrowable == null) {
                this.logger.info(componentMessage, arguments);
                this.logRepository.addLogMessage(LogLevel.INFO, componentMessage, arguments);
            } else {
                this.logger.info(componentMessage, this.setFormattedThrowable(arguments, lastThrowable));
                this.logRepository.addLogMessage(LogLevel.INFO, this.getCausesMessage(msg), this.setCauses(arguments, lastThrowable), lastThrowable);
            }
        }
    }

    public void info(String msg) {
        this.info(msg, NULL_THROWABLE);
    }

    public void info(String msg, Object[] os, Throwable t) {
        if (this.isInfoEnabled()) {
            String componentMessage = this.getComponentMessage(msg);
            Object[] arguments = this.insertComponent(os);
            if (t == null) {
                this.logger.info(componentMessage, arguments);
                this.logRepository.addLogMessage(LogLevel.INFO, componentMessage, arguments);
            } else {
                this.logger.info(componentMessage, (Object)arguments, (Object)t);
                this.logRepository.addLogMessage(LogLevel.INFO, this.getCausesMessage(msg), this.addCauses(arguments, t), t);
            }
        }
    }

    public void info(LogMessage logMessage) {
        if (this.isInfoEnabled()) {
            this.log(LogLevel.INFO, logMessage);
            this.logRepository.addLogMessage(logMessage);
        }
    }

    public String getName() {
        return this.logger.getName();
    }

    public void error(String msg) {
        this.error(msg, NULL_THROWABLE);
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            String componentMessage = this.getComponentMessage(msg);
            Object[] repositoryArguments = this.getRepositoryArguments(t);
            if (t == null) {
                this.logger.error(componentMessage, this.component);
                this.logRepository.addLogMessage(LogLevel.ERROR, componentMessage, repositoryArguments);
            } else {
                this.logger.error(componentMessage, this.component, (Object)t);
                this.logRepository.addLogMessage(LogLevel.ERROR, this.getCausesMessage(msg), repositoryArguments, t);
            }
        }
    }

    public void error(String msg, Object[] os) {
        if (this.isErrorEnabled()) {
            String componentMessage = this.getComponentMessage(msg);
            Object[] arguments = this.insertComponent(os);
            Throwable lastThrowable = this.findLastThrowable(os);
            if (lastThrowable == null) {
                this.logger.error(componentMessage, arguments);
                this.logRepository.addLogMessage(LogLevel.ERROR, componentMessage, arguments);
            } else {
                this.logger.error(componentMessage, this.setFormattedThrowable(arguments, lastThrowable));
                this.logRepository.addLogMessage(LogLevel.ERROR, this.getCausesMessage(msg), this.setCauses(arguments, lastThrowable), lastThrowable);
            }
        }
    }

    public void error(String msg, Object[] os, Throwable t) {
        if (this.isErrorEnabled()) {
            String componentMessage = this.getComponentMessage(msg);
            Object[] arguments = this.insertComponent(os);
            if (t == null) {
                this.logger.error(componentMessage, arguments);
                this.logRepository.addLogMessage(LogLevel.ERROR, componentMessage, arguments);
            } else {
                this.logger.error(componentMessage, (Object)arguments, (Object)t);
                this.logRepository.addLogMessage(LogLevel.ERROR, this.getCausesMessage(msg), this.addCauses(arguments, t), t);
            }
        }
    }

    public void error(LogMessage logMessage) {
        if (this.isErrorEnabled()) {
            this.log(LogLevel.ERROR, logMessage);
            this.logRepository.addLogMessage(logMessage);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            String componentMessage = this.getComponentMessage(msg);
            Object[] repositoryArguments = this.getRepositoryArguments(t);
            if (t == null) {
                this.logger.debug(componentMessage, this.component);
                this.logRepository.addLogMessage(LogLevel.DEBUG, componentMessage, repositoryArguments);
            } else {
                this.logger.debug(componentMessage, this.component, (Object)t);
                this.logRepository.addLogMessage(LogLevel.DEBUG, this.getCausesMessage(msg), repositoryArguments, t);
            }
        }
    }

    public void debug(String msg, Object[] os) {
        if (this.isDebugEnabled()) {
            String componentMessage = this.getComponentMessage(msg);
            Object[] arguments = this.insertComponent(os);
            Throwable lastThrowable = this.findLastThrowable(os);
            if (lastThrowable == null) {
                this.logger.debug(componentMessage, arguments);
                this.logRepository.addLogMessage(LogLevel.DEBUG, componentMessage, arguments);
            } else {
                this.logger.debug(componentMessage, this.setFormattedThrowable(arguments, lastThrowable));
                this.logRepository.addLogMessage(LogLevel.DEBUG, this.getCausesMessage(msg), this.setCauses(arguments, lastThrowable), lastThrowable);
            }
        }
    }

    public void debug(String msg, Object[] os, Throwable t) {
        if (this.isDebugEnabled()) {
            String componentMessage = this.getComponentMessage(msg);
            Object[] arguments = this.insertComponent(os);
            if (t == null) {
                this.logger.debug(componentMessage, arguments);
                this.logRepository.addLogMessage(LogLevel.DEBUG, componentMessage, arguments);
            } else {
                this.logger.debug(componentMessage, (Object)arguments, (Object)t);
                this.logRepository.addLogMessage(LogLevel.DEBUG, this.getCausesMessage(msg), this.addCauses(arguments, t), t);
            }
        }
    }

    public void debug(String msg) {
        this.debug(msg, NULL_THROWABLE);
    }

    public void debug(LogMessage logMessage) {
        if (this.isDebugEnabled()) {
            this.log(LogLevel.DEBUG, logMessage);
            this.logRepository.addLogMessage(logMessage);
        }
    }

    public void log(LogLevel level, String msg, Throwable t) {
        switch (level) {
            case DEBUG: {
                this.debug(msg, t);
                break;
            }
            case ERROR: 
            case FATAL: {
                this.error(msg, t);
                break;
            }
            case INFO: {
                this.info(msg, t);
                break;
            }
            case TRACE: {
                this.trace(msg, t);
                break;
            }
            case WARN: {
                this.warn(msg, t);
            }
        }
    }

    public void log(LogLevel level, String msg, Object[] os) {
        switch (level) {
            case DEBUG: {
                this.debug(msg, os);
                break;
            }
            case ERROR: 
            case FATAL: {
                this.error(msg, os);
                break;
            }
            case INFO: {
                this.info(msg, os);
                break;
            }
            case TRACE: {
                this.trace(msg, os);
                break;
            }
            case WARN: {
                this.warn(msg, os);
            }
        }
    }

    public void log(LogLevel level, String msg) {
        switch (level) {
            case DEBUG: {
                this.debug(msg);
                break;
            }
            case ERROR: 
            case FATAL: {
                this.error(msg);
                break;
            }
            case INFO: {
                this.info(msg);
                break;
            }
            case TRACE: {
                this.trace(msg);
                break;
            }
            case WARN: {
                this.warn(msg);
            }
        }
    }

    public void log(LogLevel level, String msg, Object[] os, Throwable t) {
        switch (level) {
            case DEBUG: {
                this.debug(msg, os, t);
                break;
            }
            case ERROR: 
            case FATAL: {
                this.error(msg, os, t);
                break;
            }
            case INFO: {
                this.info(msg, os, t);
                break;
            }
            case TRACE: {
                this.trace(msg, os, t);
                break;
            }
            case WARN: {
                this.warn(msg, os, t);
            }
        }
    }

    public void log(LogMessage message) {
        switch (message.getLogLevel()) {
            case DEBUG: {
                this.debug(message);
                break;
            }
            case ERROR: 
            case FATAL: {
                this.error(message);
                break;
            }
            case INFO: {
                this.info(message);
                break;
            }
            case TRACE: {
                this.trace(message);
                break;
            }
            case WARN: {
                this.warn(message);
            }
        }
    }

    private Object[] getRepositoryArguments(Throwable throwable) {
        Object[] objectArray;
        if (throwable == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.component;
        } else {
            objectArray = this.getComponentAndCauses(throwable);
        }
        return objectArray;
    }

    private String getCausesMessage(String message) {
        return String.format("{} %s: {}", message);
    }

    private String getComponentMessage(String message) {
        return String.format("{} %s", message);
    }

    private Object[] getComponentAndCauses(Throwable throwable) {
        String causes = this.getCauses(throwable);
        return new Object[]{this.component, causes};
    }

    private String getCauses(Throwable throwable) {
        ArrayList<String> causes = new ArrayList<String>();
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            causes.add(cause.toString());
        }
        return String.join((CharSequence)CAUSED_BY, causes);
    }

    private Object[] insertComponent(Object[] originalArgs) {
        return ArrayUtils.insert((int)0, (Object[])originalArgs, (Object[])new Object[]{this.component});
    }

    private Object[] addCauses(Object[] arguments, Throwable throwable) {
        String causes = this.getCauses(throwable);
        return ArrayUtils.add((Object[])arguments, (Object)causes);
    }

    private Object[] setCauses(Object[] arguments, Throwable throwable) {
        String causes = this.getCauses(throwable);
        int lastIndex = arguments.length - 1;
        Object[] argumentsThrowableRemoved = ArrayUtils.remove((Object[])arguments, (int)lastIndex);
        return ArrayUtils.add((Object[])argumentsThrowableRemoved, (Object)causes);
    }

    private Object[] setFormattedThrowable(Object[] arguments, Throwable throwable) {
        int lastIndex = arguments.length - 1;
        Object[] argumentsThrowableRemoved = ArrayUtils.remove((Object[])arguments, (int)lastIndex);
        return ArrayUtils.addAll((Object[])argumentsThrowableRemoved, (Object[])new Object[]{throwable.toString(), throwable});
    }

    private Throwable findLastThrowable(Object[] arguments) {
        Object lastArgument = arguments == null || arguments.length == 0 ? null : arguments[arguments.length - 1];
        Throwable lastThrowable = null;
        if (lastArgument instanceof Throwable) {
            lastThrowable = (Throwable)lastArgument;
        }
        return lastThrowable;
    }
}

