/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.replication.okhttp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.nifi.cluster.coordination.http.replication.okhttp.CallEventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestReplicationEventListener
extends EventListener {
    private static final Logger logger = LoggerFactory.getLogger(RequestReplicationEventListener.class);
    private final ConcurrentMap<Call, CallEventListener> eventListeners = new ConcurrentHashMap<Call, CallEventListener>();

    private CallEventListener getListener(Call call) {
        return this.eventListeners.computeIfAbsent(call, CallEventListener::new);
    }

    public void dnsStart(@NotNull Call call, @NotNull String domainName) {
        super.dnsStart(call, domainName);
        this.getListener(call).dnsStart(domainName);
    }

    public void dnsEnd(@NotNull Call call, @NotNull String domainName, @NotNull List<InetAddress> inetAddressList) {
        super.dnsEnd(call, domainName, inetAddressList);
        this.getListener(call).dnsEnd(domainName);
    }

    public void callStart(@NotNull Call call) {
        super.callStart(call);
        this.getListener(call).callStart();
    }

    public void callEnd(@NotNull Call call) {
        super.callEnd(call);
        CallEventListener callListener = this.getListener(call);
        callListener.callEnd();
        this.logTimingInfo(callListener);
        this.eventListeners.remove(call);
    }

    public void callFailed(@NotNull Call call, @NotNull IOException ioe) {
        super.callFailed(call, ioe);
        CallEventListener callListener = this.getListener(call);
        callListener.callEnd();
        this.logTimingInfo(callListener);
        this.eventListeners.remove(call);
    }

    public void responseBodyStart(@NotNull Call call) {
        super.responseBodyStart(call);
        this.getListener(call).responseBodyStart();
    }

    public void responseBodyEnd(@NotNull Call call, long byteCount) {
        super.responseBodyEnd(call, byteCount);
        this.getListener(call).responseBodyEnd();
    }

    public void responseFailed(@NotNull Call call, @NotNull IOException ioe) {
        super.responseFailed(call, ioe);
        this.getListener(call).responseBodyEnd();
    }

    public void responseHeadersStart(@NotNull Call call) {
        super.responseHeadersStart(call);
        this.getListener(call).responseHeaderStart();
    }

    public void responseHeadersEnd(@NotNull Call call, @NotNull Response response) {
        super.responseHeadersEnd(call, response);
        this.getListener(call).responseHeaderEnd();
    }

    public void requestHeadersStart(@NotNull Call call) {
        super.requestHeadersStart(call);
        this.getListener(call).requestHeaderStart();
    }

    public void requestHeadersEnd(@NotNull Call call, @NotNull Request request) {
        super.requestHeadersEnd(call, request);
        this.getListener(call).requestHeaderEnd();
    }

    public void requestBodyStart(@NotNull Call call) {
        super.requestBodyStart(call);
        this.getListener(call).requestBodyStart();
    }

    public void requestBodyEnd(@NotNull Call call, long byteCount) {
        super.requestBodyEnd(call, byteCount);
        this.getListener(call).requestBodyEnd();
    }

    public void requestFailed(@NotNull Call call, @NotNull IOException ioe) {
        super.requestFailed(call, ioe);
        this.getListener(call).requestBodyEnd();
    }

    public void connectStart(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy) {
        super.connectStart(call, inetSocketAddress, proxy);
        this.getListener(call).connectStart(inetSocketAddress);
    }

    public void connectionAcquired(@NotNull Call call, @NotNull Connection connection) {
        super.connectionAcquired(call, connection);
        this.getListener(call).connectionAcquired(connection.socket().getRemoteSocketAddress());
    }

    public void secureConnectStart(@NotNull Call call) {
        super.secureConnectStart(call);
        this.getListener(call).secureConnectStart();
    }

    public void secureConnectEnd(@NotNull Call call, @Nullable Handshake handshake) {
        super.secureConnectEnd(call, handshake);
        this.getListener(call).secureConnectEnd();
    }

    private void logTimingInfo(CallEventListener eventListener) {
        logger.debug("Timing information {}", (Object)eventListener);
    }
}

