/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.spring;

import org.apache.nifi.cluster.coordination.flow.FlowElection;
import org.apache.nifi.cluster.coordination.node.NodeClusterCoordinator;
import org.apache.nifi.cluster.firewall.ClusterNodeFirewall;
import org.apache.nifi.cluster.protocol.NodeProtocolSender;
import org.apache.nifi.cluster.protocol.impl.ClusterCoordinationProtocolSenderListener;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.revision.RevisionManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class NodeClusterCoordinatorFactoryBean
implements FactoryBean<NodeClusterCoordinator>,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private NiFiProperties properties;
    private ExtensionManager extensionManager;
    private NodeClusterCoordinator nodeClusterCoordinator = null;

    public NodeClusterCoordinator getObject() throws Exception {
        if (this.nodeClusterCoordinator == null && this.properties.isNode()) {
            ClusterCoordinationProtocolSenderListener protocolSenderListener = (ClusterCoordinationProtocolSenderListener)this.applicationContext.getBean("clusterCoordinationProtocolSenderListener", ClusterCoordinationProtocolSenderListener.class);
            EventReporter eventReporter = (EventReporter)this.applicationContext.getBean("eventReporter", EventReporter.class);
            Object clusterFirewallBean = this.applicationContext.getBean("clusterFirewall");
            ClusterNodeFirewall clusterFirewall = clusterFirewallBean instanceof ClusterNodeFirewall ? (ClusterNodeFirewall)clusterFirewallBean : null;
            RevisionManager revisionManager = (RevisionManager)this.applicationContext.getBean("revisionManager", RevisionManager.class);
            LeaderElectionManager electionManager = (LeaderElectionManager)this.applicationContext.getBean("leaderElectionManager", LeaderElectionManager.class);
            FlowElection flowElection = (FlowElection)this.applicationContext.getBean("flowElection", FlowElection.class);
            NodeProtocolSender nodeProtocolSender = (NodeProtocolSender)this.applicationContext.getBean("nodeProtocolSender", NodeProtocolSender.class);
            this.nodeClusterCoordinator = new NodeClusterCoordinator(protocolSenderListener, eventReporter, electionManager, flowElection, clusterFirewall, revisionManager, this.properties, this.extensionManager, nodeProtocolSender);
        }
        return this.nodeClusterCoordinator;
    }

    public Class<?> getObjectType() {
        return NodeClusterCoordinator.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }
}

