/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.FlowRegistryClientEntityMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.FlowRegistryClientEntity;

public class FlowRegistryClientEndpointMerger
extends AbstractSingleEntityEndpoint<FlowRegistryClientEntity>
implements EndpointResponseMerger {
    public static final String CONTROLLER_REGISTRY_URI = "/nifi-api/controller/registry-clients";
    public static final Pattern CONTROLLER_REGISTRY_URI_PATTERN = Pattern.compile("/nifi-api/controller/registry-clients/[a-f0-9\\-]{36}");
    public static final Set<String> CONTROLLER_REGISTRY_ACCEPTED_METHODS = new HashSet<String>(Arrays.asList("GET", "PUT", "DELETE"));
    private final FlowRegistryClientEntityMerger flowRegistryClientEntityMerger = new FlowRegistryClientEntityMerger();

    @Override
    public boolean canHandle(URI uri, String method) {
        if (CONTROLLER_REGISTRY_ACCEPTED_METHODS.contains(method) && CONTROLLER_REGISTRY_URI_PATTERN.matcher(uri.getPath()).matches()) {
            return true;
        }
        return "POST".equalsIgnoreCase(method) && CONTROLLER_REGISTRY_URI.equals(uri.getPath());
    }

    @Override
    protected Class<FlowRegistryClientEntity> getEntityClass() {
        return FlowRegistryClientEntity.class;
    }

    @Override
    protected void mergeResponses(FlowRegistryClientEntity clientEntity, Map<NodeIdentifier, FlowRegistryClientEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        this.flowRegistryClientEntityMerger.merge(clientEntity, entityMap);
    }
}

