/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.BulletinEntity;

public final class BulletinMerger {
    static final String ALL_NODES_MESSAGE = "All Nodes";
    public static Comparator<BulletinEntity> BULLETIN_COMPARATOR = new Comparator<BulletinEntity>(){

        @Override
        public int compare(BulletinEntity o1, BulletinEntity o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return -Long.compare(o1.getId(), o2.getId());
        }
    };

    private BulletinMerger() {
    }

    public static List<BulletinEntity> mergeBulletins(Map<NodeIdentifier, List<BulletinEntity>> bulletins, int totalNodes) {
        ArrayList<BulletinEntity> bulletinEntities = new ArrayList<BulletinEntity>();
        for (Map.Entry<NodeIdentifier, List<BulletinEntity>> entry : bulletins.entrySet()) {
            NodeIdentifier nodeId = entry.getKey();
            List<BulletinEntity> nodeBulletins = entry.getValue();
            String nodeAddress = nodeId.getApiAddress() + ":" + nodeId.getApiPort();
            for (BulletinEntity bulletinEntity2 : nodeBulletins) {
                if (bulletinEntity2.getNodeAddress() == null) {
                    bulletinEntity2.setNodeAddress(nodeAddress);
                }
                if (bulletinEntity2.getCanRead().booleanValue() && bulletinEntity2.getBulletin() != null && bulletinEntity2.getBulletin().getNodeAddress() == null) {
                    bulletinEntity2.getBulletin().setNodeAddress(nodeAddress);
                }
                bulletinEntities.add(bulletinEntity2);
            }
        }
        ArrayList<BulletinEntity> entities = new ArrayList<BulletinEntity>();
        Map<String, List<BulletinEntity>> groupingEntities = bulletinEntities.stream().filter(bulletinEntity -> bulletinEntity.getCanRead()).collect(Collectors.groupingBy(b -> b.getBulletin().getMessage()));
        groupingEntities.forEach((message, groupedBulletinEntities) -> {
            if (groupedBulletinEntities.size() == totalNodes) {
                BulletinEntity selectedBulletinEntity = groupedBulletinEntities.stream().max(Comparator.comparingLong(bulletinEntity -> {
                    if (bulletinEntity.getTimestamp() == null) {
                        return 0L;
                    }
                    return bulletinEntity.getTimestamp().getTime();
                })).orElse(null);
                if (selectedBulletinEntity != null) {
                    selectedBulletinEntity.setNodeAddress(ALL_NODES_MESSAGE);
                    selectedBulletinEntity.getBulletin().setNodeAddress(ALL_NODES_MESSAGE);
                    entities.add(selectedBulletinEntity);
                }
            } else {
                entities.addAll((Collection<BulletinEntity>)groupedBulletinEntities);
            }
        });
        bulletinEntities.stream().filter(bulletinEntity -> bulletinEntity.getCanRead() == false).forEach(entities::add);
        Collections.sort(entities, (o1, o2) -> {
            int timeComparison = o1.getTimestamp().compareTo(o2.getTimestamp());
            if (timeComparison != 0) {
                return timeComparison;
            }
            return o1.getNodeAddress().compareTo(o2.getNodeAddress());
        });
        return entities;
    }
}

