/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.coordination.http.endpoints.ParameterContextMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.ParameterContextEntity;

public class ParameterContextEndpointMerger
extends AbstractSingleEntityEndpoint<ParameterContextEntity>
implements EndpointResponseMerger {
    private static final Pattern PARAMETER_CONTEXT_URI = Pattern.compile("/nifi-api/parameter-contexts/[a-f0-9\\-]{36}");

    @Override
    public boolean canHandle(URI uri, String method) {
        return ("GET".equalsIgnoreCase(method) || "DELETE".equalsIgnoreCase(method)) && PARAMETER_CONTEXT_URI.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<ParameterContextEntity> getEntityClass() {
        return ParameterContextEntity.class;
    }

    @Override
    protected void mergeResponses(ParameterContextEntity clientEntity, Map<NodeIdentifier, ParameterContextEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        ParameterContextMerger.merge(clientEntity, entityMap);
    }
}

