/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.PermissionsDtoMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.ComponentValidationResultDTO;
import org.apache.nifi.web.api.dto.ParameterContextValidationRequestDTO;
import org.apache.nifi.web.api.entity.ComponentValidationResultEntity;
import org.apache.nifi.web.api.entity.ComponentValidationResultsEntity;
import org.apache.nifi.web.api.entity.ParameterContextValidationRequestEntity;

public class ParameterContextValidationMerger
extends AbstractSingleEntityEndpoint<ParameterContextValidationRequestEntity>
implements EndpointResponseMerger {
    public static final Pattern REQUESTS_URI_PATTERN = Pattern.compile("/nifi-api/parameter-contexts/validation-requests");
    public static final Pattern REQUEST_BY_ID_URI_PATTERN = Pattern.compile("/nifi-api/parameter-contexts/validation-requests/[a-f0-9\\-]{36}");

    @Override
    public boolean canHandle(URI uri, String method) {
        if ("POST".equalsIgnoreCase(method) && REQUESTS_URI_PATTERN.matcher(uri.getPath()).matches()) {
            return true;
        }
        return REQUEST_BY_ID_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<ParameterContextValidationRequestEntity> getEntityClass() {
        return ParameterContextValidationRequestEntity.class;
    }

    @Override
    protected void mergeResponses(ParameterContextValidationRequestEntity clientEntity, Map<NodeIdentifier, ParameterContextValidationRequestEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        ParameterContextValidationRequestDTO validationRequest = clientEntity.getRequest();
        for (ParameterContextValidationRequestEntity requestEntity : entityMap.values()) {
            ParameterContextValidationRequestDTO requestDto = requestEntity.getRequest();
            if (!requestDto.isComplete()) {
                validationRequest.setComplete(false);
            }
            if (requestDto.getFailureReason() != null) {
                validationRequest.setFailureReason(requestDto.getFailureReason());
            }
            if (requestDto.getLastUpdated() != null && (validationRequest.getLastUpdated() == null || requestDto.getLastUpdated().after(validationRequest.getLastUpdated()))) {
                validationRequest.setLastUpdated(requestDto.getLastUpdated());
            }
            if (requestDto.getPercentCompleted() >= validationRequest.getPercentCompleted()) continue;
            validationRequest.setPercentCompleted(requestDto.getPercentCompleted());
            validationRequest.setState(requestDto.getState());
        }
        ComponentValidationResultsEntity resultsEntity = validationRequest.getComponentValidationResults();
        if (resultsEntity == null) {
            return;
        }
        List resultsEntities = resultsEntity.getValidationResults();
        if (resultsEntities == null) {
            return;
        }
        HashMap<String, ComponentValidationResultEntity> resultsById = new HashMap<String, ComponentValidationResultEntity>();
        for (ComponentValidationResultEntity resultEntity : resultsEntities) {
            resultsById.put(resultEntity.getId(), resultEntity);
        }
        for (ParameterContextValidationRequestEntity requestEntity : entityMap.values()) {
            ComponentValidationResultsEntity validationResultsEntity = requestEntity.getRequest().getComponentValidationResults();
            if (validationResultsEntity == null) continue;
            for (ComponentValidationResultEntity resultEntity : validationResultsEntity.getValidationResults()) {
                ComponentValidationResultEntity mergedResultEntity = (ComponentValidationResultEntity)resultsById.get(resultEntity.getId());
                if (mergedResultEntity == null) {
                    resultsById.put(resultEntity.getId(), resultEntity);
                    continue;
                }
                this.merge(mergedResultEntity, resultEntity);
            }
        }
        resultsEntity.setValidationResults(new ArrayList(resultsById.values()));
    }

    private void merge(ComponentValidationResultEntity merged, ComponentValidationResultEntity additional) {
        ArrayList mergedResultantValidationErrors;
        if (merged.getComponent() == null) {
            return;
        }
        PermissionsDtoMerger.mergePermissions(merged.getPermissions(), additional.getPermissions());
        if (additional.getComponent() == null) {
            merged.setComponent(null);
            return;
        }
        ComponentValidationResultDTO mergedResultDto = merged.getComponent();
        ComponentValidationResultDTO additionalResultDto = additional.getComponent();
        mergedResultDto.setActiveThreadCount(Integer.valueOf(mergedResultDto.getActiveThreadCount() + additionalResultDto.getActiveThreadCount()));
        ArrayList mergedValidationErrors = mergedResultDto.getValidationErrors();
        if (mergedValidationErrors == null) {
            mergedValidationErrors = new ArrayList();
            mergedResultDto.setValidationErrors(mergedValidationErrors);
        }
        if (additionalResultDto.getValidationErrors() != null) {
            mergedValidationErrors.addAll(additionalResultDto.getValidationErrors());
        }
        if ((mergedResultantValidationErrors = mergedResultDto.getResultantValidationErrors()) == null) {
            mergedResultantValidationErrors = new ArrayList();
            mergedResultDto.setResultantValidationErrors(mergedResultantValidationErrors);
        }
        if (additionalResultDto.getResultantValidationErrors() != null) {
            mergedResultantValidationErrors.addAll(additionalResultDto.getResultantValidationErrors());
        }
        mergedResultDto.setCurrentlyValid(Boolean.valueOf(mergedValidationErrors.isEmpty()));
        mergedResultDto.setResultsValid(Boolean.valueOf(mergedResultantValidationErrors.isEmpty()));
    }
}

