/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.cluster.manager.ComponentEntityMerger;
import org.apache.nifi.cluster.manager.ComponentEntityStatusMerger;
import org.apache.nifi.cluster.manager.ErrorMerger;
import org.apache.nifi.cluster.manager.StatusMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.RemoteProcessGroupContentsDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.status.RemoteProcessGroupStatusDTO;
import org.apache.nifi.web.api.entity.RemoteProcessGroupEntity;

public class RemoteProcessGroupEntityMerger
implements ComponentEntityMerger<RemoteProcessGroupEntity>,
ComponentEntityStatusMerger<RemoteProcessGroupStatusDTO> {
    @Override
    public void merge(RemoteProcessGroupEntity clientEntity, Map<NodeIdentifier, RemoteProcessGroupEntity> entityMap) {
        ComponentEntityMerger.super.merge(clientEntity, entityMap);
        for (Map.Entry<NodeIdentifier, RemoteProcessGroupEntity> entry : entityMap.entrySet()) {
            RemoteProcessGroupEntity entityStatus = entry.getValue();
            if (entityStatus == clientEntity) continue;
            this.mergeStatus(clientEntity.getStatus(), (boolean)clientEntity.getPermissions().getCanRead(), entry.getValue().getStatus(), (boolean)entry.getValue().getPermissions().getCanRead(), entry.getKey());
        }
    }

    @Override
    public void mergeComponents(RemoteProcessGroupEntity clientEntity, Map<NodeIdentifier, RemoteProcessGroupEntity> entityMap) {
        RemoteProcessGroupDTO clientDto = clientEntity.getComponent();
        HashMap<NodeIdentifier, RemoteProcessGroupDTO> dtoMap = new HashMap<NodeIdentifier, RemoteProcessGroupDTO>();
        for (Map.Entry<NodeIdentifier, RemoteProcessGroupEntity> entry : entityMap.entrySet()) {
            RemoteProcessGroupEntity nodeProcEntity = entry.getValue();
            RemoteProcessGroupDTO nodeProcDto = nodeProcEntity.getComponent();
            dtoMap.put(entry.getKey(), nodeProcDto);
        }
        RemoteProcessGroupEntityMerger.mergeDtos(clientDto, dtoMap);
    }

    @Override
    public void mergeStatus(RemoteProcessGroupStatusDTO clientStatus, boolean clientStatusReadablePermission, RemoteProcessGroupStatusDTO status, boolean statusReadablePermission, NodeIdentifier statusNodeIdentifier) {
        StatusMerger.merge(clientStatus, clientStatusReadablePermission, status, statusReadablePermission, statusNodeIdentifier.getId(), statusNodeIdentifier.getApiAddress(), (Integer)statusNodeIdentifier.getApiPort());
    }

    private static void mergeDtos(RemoteProcessGroupDTO clientDto, Map<NodeIdentifier, RemoteProcessGroupDTO> dtoMap) {
        if (clientDto == null) {
            return;
        }
        RemoteProcessGroupContentsDTO remoteProcessGroupContents = clientDto.getContents();
        HashMap<String, Set<NodeIdentifier>> authorizationErrorMap = new HashMap<String, Set<NodeIdentifier>>();
        HashMap<String, Set<NodeIdentifier>> validationErrorMap = new HashMap<String, Set<NodeIdentifier>>();
        Boolean mergedIsTargetSecure = null;
        HashSet mergedInputPorts = null;
        HashSet mergedOutputPorts = null;
        for (Map.Entry<NodeIdentifier, RemoteProcessGroupDTO> nodeEntry : dtoMap.entrySet()) {
            Set nodeOutputPorts;
            RemoteProcessGroupDTO nodeRemoteProcessGroup = nodeEntry.getValue();
            if (nodeRemoteProcessGroup == null) continue;
            NodeIdentifier nodeId = nodeEntry.getKey();
            ErrorMerger.mergeErrors(authorizationErrorMap, nodeId, nodeRemoteProcessGroup.getAuthorizationIssues());
            ErrorMerger.mergeErrors(validationErrorMap, nodeId, nodeRemoteProcessGroup.getValidationErrors());
            Boolean nodeIsTargetSecure = nodeRemoteProcessGroup.isTargetSecure();
            if (mergedIsTargetSecure == null) {
                mergedIsTargetSecure = nodeIsTargetSecure;
            }
            RemoteProcessGroupContentsDTO nodeRemoteProcessGroupContentsDto = nodeRemoteProcessGroup.getContents();
            if (remoteProcessGroupContents == null || nodeRemoteProcessGroupContentsDto == null) continue;
            Set nodeInputPorts = nodeRemoteProcessGroupContentsDto.getInputPorts();
            if (nodeInputPorts != null) {
                if (mergedInputPorts == null) {
                    mergedInputPorts = new HashSet(nodeInputPorts);
                } else {
                    mergedInputPorts.retainAll(nodeInputPorts);
                }
            }
            if ((nodeOutputPorts = nodeRemoteProcessGroupContentsDto.getOutputPorts()) == null) continue;
            if (mergedOutputPorts == null) {
                mergedOutputPorts = new HashSet(nodeOutputPorts);
                continue;
            }
            mergedOutputPorts.retainAll(nodeOutputPorts);
        }
        if (remoteProcessGroupContents != null) {
            if (mergedInputPorts == null) {
                remoteProcessGroupContents.setInputPorts(Collections.emptySet());
                clientDto.setInputPortCount(Integer.valueOf(0));
            } else {
                remoteProcessGroupContents.setInputPorts(mergedInputPorts);
                clientDto.setInputPortCount(Integer.valueOf(mergedInputPorts.size()));
            }
            if (mergedOutputPorts == null) {
                remoteProcessGroupContents.setOutputPorts(Collections.emptySet());
                clientDto.setOutputPortCount(Integer.valueOf(0));
            } else {
                remoteProcessGroupContents.setOutputPorts(mergedOutputPorts);
                clientDto.setOutputPortCount(Integer.valueOf(mergedOutputPorts.size()));
            }
        }
        if (mergedIsTargetSecure != null) {
            clientDto.setTargetSecure(mergedIsTargetSecure);
        }
        clientDto.setAuthorizationIssues(ErrorMerger.normalizedMergedErrors(authorizationErrorMap, dtoMap.size()));
        clientDto.setValidationErrors(ErrorMerger.normalizedMergedErrors(validationErrorMap, dtoMap.size()));
    }
}

