/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.ConnectionEntityMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.ConnectionEntity;

public class ConnectionEndpointMerger
extends AbstractSingleEntityEndpoint<ConnectionEntity>
implements EndpointResponseMerger {
    public static final Pattern CONNECTIONS_URI_PATTERN = Pattern.compile("/nifi-api/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/connections");
    public static final Pattern CONNECTION_URI_PATTERN = Pattern.compile("/nifi-api/connections/[a-f0-9\\-]{36}");
    private final ConnectionEntityMerger connectionEntityMerger = new ConnectionEntityMerger();

    @Override
    public boolean canHandle(URI uri, String method) {
        if (("GET".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) && CONNECTION_URI_PATTERN.matcher(uri.getPath()).matches()) {
            return true;
        }
        return "POST".equalsIgnoreCase(method) && CONNECTIONS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<ConnectionEntity> getEntityClass() {
        return ConnectionEntity.class;
    }

    @Override
    protected void mergeResponses(ConnectionEntity clientEntity, Map<NodeIdentifier, ConnectionEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        this.connectionEntityMerger.merge(clientEntity, entityMap);
    }
}

