/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.node;

import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.cluster.coordination.node.DisconnectionCode;
import org.apache.nifi.cluster.coordination.node.NodeConnectionState;
import org.apache.nifi.cluster.coordination.node.OffloadCode;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.cluster.protocol.jaxb.message.NodeConnectionStatusAdapter;

@XmlJavaTypeAdapter(value=NodeConnectionStatusAdapter.class)
public class NodeConnectionStatus {
    private static final AtomicLong idGenerator = new AtomicLong(0L);
    private final long updateId;
    private final NodeIdentifier nodeId;
    private final NodeConnectionState state;
    private final OffloadCode offloadCode;
    private final DisconnectionCode disconnectCode;
    private final String reason;
    private final Long connectionRequestTime;

    public NodeConnectionStatus(NodeIdentifier nodeId, NodeConnectionState state) {
        this(nodeId, state, null, null, null, null);
    }

    public NodeConnectionStatus(NodeIdentifier nodeId, DisconnectionCode disconnectionCode) {
        this(nodeId, NodeConnectionState.DISCONNECTED, null, disconnectionCode, disconnectionCode.toString(), null);
    }

    public NodeConnectionStatus(NodeIdentifier nodeId, NodeConnectionState state, OffloadCode offloadCode, String offloadExplanation) {
        this(nodeId, state, offloadCode, null, offloadExplanation, null);
    }

    public NodeConnectionStatus(NodeIdentifier nodeId, DisconnectionCode disconnectionCode, String disconnectionExplanation) {
        this(nodeId, NodeConnectionState.DISCONNECTED, null, disconnectionCode, disconnectionExplanation, null);
    }

    public NodeConnectionStatus(NodeIdentifier nodeId, NodeConnectionState state, DisconnectionCode disconnectionCode) {
        this(nodeId, state, null, disconnectionCode, disconnectionCode == null ? null : disconnectionCode.toString(), null);
    }

    public NodeConnectionStatus(NodeConnectionStatus status) {
        this(status.getNodeIdentifier(), status.getState(), status.getOffloadCode(), status.getDisconnectCode(), status.getReason(), status.getConnectionRequestTime());
    }

    public NodeConnectionStatus(NodeIdentifier nodeId, NodeConnectionState state, OffloadCode offloadCode, DisconnectionCode disconnectCode, String reason, Long connectionRequestTime) {
        this(idGenerator.getAndIncrement(), nodeId, state, offloadCode, disconnectCode, reason, connectionRequestTime);
    }

    public NodeConnectionStatus(long updateId, NodeIdentifier nodeId, NodeConnectionState state, OffloadCode offloadCode, DisconnectionCode disconnectCode, String reason, Long connectionRequestTime) {
        this.updateId = updateId;
        this.nodeId = nodeId;
        this.state = state;
        this.offloadCode = offloadCode;
        if (state == NodeConnectionState.DISCONNECTED && disconnectCode == null) {
            this.disconnectCode = DisconnectionCode.UNKNOWN;
            this.reason = this.disconnectCode.toString();
        } else {
            this.disconnectCode = disconnectCode;
            this.reason = reason;
        }
        this.connectionRequestTime = connectionRequestTime == null && state == NodeConnectionState.CONNECTING ? Long.valueOf(System.currentTimeMillis()) : connectionRequestTime;
    }

    public long getUpdateIdentifier() {
        return this.updateId;
    }

    public NodeIdentifier getNodeIdentifier() {
        return this.nodeId;
    }

    public NodeConnectionState getState() {
        return this.state;
    }

    public OffloadCode getOffloadCode() {
        return this.offloadCode;
    }

    public DisconnectionCode getDisconnectCode() {
        return this.disconnectCode;
    }

    public String getReason() {
        return this.reason;
    }

    public Long getConnectionRequestTime() {
        return this.connectionRequestTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        NodeConnectionState state = this.getState();
        sb.append("NodeConnectionStatus[nodeId=").append(this.nodeId).append(", state=").append((Object)state);
        if (state == NodeConnectionState.OFFLOADED || state == NodeConnectionState.OFFLOADING) {
            sb.append(", Offload Code=").append((Object)this.getOffloadCode()).append(", Offload Reason=").append(this.getReason());
        }
        if (state == NodeConnectionState.DISCONNECTED || state == NodeConnectionState.DISCONNECTING) {
            sb.append(", Disconnect Code=").append((Object)this.getDisconnectCode()).append(", Disconnect Reason=").append(this.getReason());
        }
        sb.append(", updateId=").append(this.getUpdateIdentifier());
        sb.append("]");
        return sb.toString();
    }

    static void updateIdGenerator(long minimumValue) {
        idGenerator.updateAndGet(curValue -> Math.max(minimumValue, curValue));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeConnectionStatus)) {
            return false;
        }
        NodeConnectionStatus other = (NodeConnectionStatus)obj;
        return Objects.deepEquals(this.getNodeIdentifier(), other.getNodeIdentifier()) && Objects.deepEquals((Object)this.getState(), (Object)other.getState());
    }
}

