/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.ReconstitutedSerializedRepositoryRecord;
import org.apache.nifi.controller.repository.RepositoryRecordSerde;
import org.apache.nifi.controller.repository.RepositoryRecordType;
import org.apache.nifi.controller.repository.SerializedRepositoryRecord;
import org.apache.nifi.controller.repository.StandardFlowFileRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.controller.repository.schema.ContentClaimFieldMap;
import org.apache.nifi.controller.repository.schema.ContentClaimSchema;
import org.apache.nifi.controller.repository.schema.RepositoryRecordFieldMap;
import org.apache.nifi.controller.repository.schema.RepositoryRecordSchema;
import org.apache.nifi.controller.repository.schema.RepositoryRecordUpdate;
import org.apache.nifi.repository.schema.FieldCache;
import org.apache.nifi.repository.schema.FieldType;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordField;
import org.apache.nifi.repository.schema.RecordIterator;
import org.apache.nifi.repository.schema.RecordSchema;
import org.apache.nifi.repository.schema.Repetition;
import org.apache.nifi.repository.schema.SchemaRecordReader;
import org.apache.nifi.repository.schema.SchemaRecordWriter;
import org.apache.nifi.repository.schema.SimpleRecordField;
import org.wali.SerDe;

public class SchemaRepositoryRecordSerde
extends RepositoryRecordSerde
implements SerDe<SerializedRepositoryRecord> {
    private static final int MAX_ENCODING_VERSION = 2;
    private final RecordSchema writeSchema = RepositoryRecordSchema.REPOSITORY_RECORD_SCHEMA_V2;
    private final RecordSchema contentClaimSchema = ContentClaimSchema.CONTENT_CLAIM_SCHEMA_V1;
    private final ResourceClaimManager resourceClaimManager;
    private final FieldCache fieldCache;
    private volatile SchemaRecordReader reader;
    private RecordIterator recordIterator = null;

    public SchemaRepositoryRecordSerde(ResourceClaimManager resourceClaimManager, FieldCache fieldCache) {
        this.resourceClaimManager = resourceClaimManager;
        this.fieldCache = fieldCache;
    }

    public void writeHeader(DataOutputStream out) throws IOException {
        this.writeSchema.writeTo((OutputStream)out);
    }

    public void serializeEdit(SerializedRepositoryRecord previousRecordState, SerializedRepositoryRecord newRecordState, DataOutputStream out) throws IOException {
        this.serializeRecord(newRecordState, out);
    }

    public void serializeRecord(SerializedRepositoryRecord record, DataOutputStream out) throws IOException {
        this.serializeRecord(record, out, switch (record.getType()) {
            case RepositoryRecordType.CREATE, RepositoryRecordType.UPDATE -> RepositoryRecordSchema.CREATE_OR_UPDATE_SCHEMA_V2;
            case RepositoryRecordType.CONTENTMISSING, RepositoryRecordType.DELETE -> RepositoryRecordSchema.DELETE_SCHEMA_V2;
            case RepositoryRecordType.SWAP_IN -> RepositoryRecordSchema.SWAP_IN_SCHEMA_V2;
            case RepositoryRecordType.SWAP_OUT -> RepositoryRecordSchema.SWAP_OUT_SCHEMA_V2;
            default -> throw new IllegalArgumentException("Received Repository Record with unknown Update Type: " + record.getType());
        }, RepositoryRecordSchema.REPOSITORY_RECORD_SCHEMA_V2);
    }

    protected void serializeRecord(SerializedRepositoryRecord record, DataOutputStream out, RecordSchema schema, RecordSchema repositoryRecordSchema) throws IOException {
        RepositoryRecordFieldMap fieldMap = new RepositoryRecordFieldMap(record, schema, this.contentClaimSchema);
        RepositoryRecordUpdate update = new RepositoryRecordUpdate(fieldMap, repositoryRecordSchema);
        new SchemaRecordWriter().writeRecord((Record)update, (OutputStream)out);
    }

    public void readHeader(DataInputStream in) throws IOException {
        RecordSchema recoverySchema = RecordSchema.readFrom((InputStream)in);
        this.reader = SchemaRecordReader.fromSchema((RecordSchema)recoverySchema, (FieldCache)this.fieldCache);
    }

    public SerializedRepositoryRecord deserializeEdit(DataInputStream in, Map<Object, SerializedRepositoryRecord> currentRecordStates, int version) throws IOException {
        SerializedRepositoryRecord record = this.deserializeRecord(in, version);
        if (record != null) {
            return record;
        }
        throw new EOFException();
    }

    public SerializedRepositoryRecord deserializeRecord(DataInputStream in, int version) throws IOException {
        if (this.recordIterator != null) {
            SerializedRepositoryRecord record = this.nextRecord();
            if (record != null) {
                return record;
            }
            this.recordIterator.close();
        }
        this.recordIterator = this.reader.readRecords((InputStream)in);
        if (this.recordIterator == null) {
            return null;
        }
        return this.nextRecord();
    }

    private SerializedRepositoryRecord nextRecord() throws IOException {
        Record record;
        try {
            record = this.recordIterator.next();
        }
        catch (Exception e) {
            this.recordIterator.close();
            this.recordIterator = null;
            throw e;
        }
        if (record == null) {
            return null;
        }
        return this.createRepositoryRecord(record);
    }

    private SerializedRepositoryRecord createRepositoryRecord(Record updateRecord) throws IOException {
        if (updateRecord == null) {
            return null;
        }
        Record record = (Record)updateRecord.getFieldValue("Repository Record Update");
        String actionType = (String)record.getFieldValue(RepositoryRecordSchema.ACTION_TYPE_FIELD);
        RepositoryRecordType recordType = RepositoryRecordType.valueOf((String)actionType);
        switch (recordType) {
            case CREATE: {
                return this.createRecord(record, RepositoryRecordType.CREATE, null);
            }
            case CONTENTMISSING: 
            case DELETE: {
                return this.deleteRecord(record);
            }
            case SWAP_IN: {
                return this.swapInRecord(record);
            }
            case SWAP_OUT: {
                return this.swapOutRecord(record);
            }
            case UPDATE: {
                return this.updateRecord(record);
            }
        }
        throw new IOException("Found unrecognized Update Type '" + actionType + "'");
    }

    private SerializedRepositoryRecord createRecord(Record record, RepositoryRecordType type, String swapLocation) {
        StandardFlowFileRecord.Builder ffBuilder = new StandardFlowFileRecord.Builder();
        ffBuilder.id(((Long)record.getFieldValue("Record ID")).longValue());
        ffBuilder.entryDate(((Long)record.getFieldValue("Entry Date")).longValue());
        Long lastQueueDate = (Long)record.getFieldValue("Queued Date");
        Long queueDateIndex = (Long)record.getFieldValue("Queued Date Index");
        ffBuilder.lastQueued(lastQueueDate.longValue(), queueDateIndex.longValue());
        Long lineageStartDate = (Long)record.getFieldValue("Lineage Start Date");
        Long lineageStartIndex = (Long)record.getFieldValue("Lineage Start Index");
        ffBuilder.lineageStart(lineageStartDate.longValue(), lineageStartIndex.longValue());
        this.populateContentClaim(ffBuilder, record);
        ffBuilder.size(((Long)record.getFieldValue("FlowFile Size")).longValue());
        ffBuilder.addAttributes((Map)record.getFieldValue("Attributes"));
        FlowFileRecord flowFileRecord = ffBuilder.build();
        String queueId = (String)record.getFieldValue("Queue Identifier");
        ReconstitutedSerializedRepositoryRecord repoRecord = new ReconstitutedSerializedRepositoryRecord.Builder().flowFileRecord(flowFileRecord).queueIdentifier(queueId).type(type).swapLocation(swapLocation).build();
        return repoRecord;
    }

    private void populateContentClaim(StandardFlowFileRecord.Builder ffBuilder, Record record) {
        Object claimMap = record.getFieldValue("Content Claim");
        if (claimMap == null) {
            return;
        }
        Record claimRecord = (Record)claimMap;
        ContentClaim contentClaim = ContentClaimFieldMap.getContentClaim(claimRecord, this.resourceClaimManager);
        Long offset = ContentClaimFieldMap.getContentClaimOffset(claimRecord);
        ffBuilder.contentClaim(contentClaim);
        ffBuilder.contentClaimOffset(offset.longValue());
    }

    private SerializedRepositoryRecord updateRecord(Record record) {
        return this.createRecord(record, RepositoryRecordType.UPDATE, null);
    }

    private SerializedRepositoryRecord deleteRecord(Record record) {
        Long recordId = (Long)record.getFieldValue(RepositoryRecordSchema.RECORD_ID_FIELD);
        StandardFlowFileRecord.Builder ffBuilder = new StandardFlowFileRecord.Builder().id(recordId.longValue());
        FlowFileRecord flowFileRecord = ffBuilder.build();
        ReconstitutedSerializedRepositoryRecord repoRecord = new ReconstitutedSerializedRepositoryRecord.Builder().flowFileRecord(flowFileRecord).type(RepositoryRecordType.DELETE).build();
        return repoRecord;
    }

    private SerializedRepositoryRecord swapInRecord(Record record) {
        String swapLocation = (String)record.getFieldValue((RecordField)new SimpleRecordField("Swap Location", FieldType.STRING, Repetition.EXACTLY_ONE));
        SerializedRepositoryRecord repoRecord = this.createRecord(record, RepositoryRecordType.SWAP_IN, swapLocation);
        return repoRecord;
    }

    private SerializedRepositoryRecord swapOutRecord(Record record) {
        Long recordId = (Long)record.getFieldValue(RepositoryRecordSchema.RECORD_ID_FIELD);
        String queueId = (String)record.getFieldValue((RecordField)new SimpleRecordField("Queue Identifier", FieldType.STRING, Repetition.EXACTLY_ONE));
        String swapLocation = (String)record.getFieldValue((RecordField)new SimpleRecordField("Swap Location", FieldType.STRING, Repetition.EXACTLY_ONE));
        FlowFileRecord flowFileRecord = new StandardFlowFileRecord.Builder().id(recordId.longValue()).build();
        return new ReconstitutedSerializedRepositoryRecord.Builder().flowFileRecord(flowFileRecord).type(RepositoryRecordType.SWAP_OUT).swapLocation(swapLocation).queueIdentifier(queueId).build();
    }

    public int getVersion() {
        return 2;
    }

    public boolean isWriteExternalFileReferenceSupported() {
        return true;
    }

    public void writeExternalFileReference(File externalFile, DataOutputStream out) throws IOException {
        new SchemaRecordWriter().writeExternalFileReference(out, externalFile);
    }

    public boolean isMoreInExternalFile() throws IOException {
        return this.recordIterator != null && this.recordIterator.isNext();
    }
}

