/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.nifi.util.FlowFileUnpackager;

public class FlowFileUnpackagerV1
implements FlowFileUnpackager {
    private int flowFilesRead = 0;

    @Override
    public Map<String, String> unpackageFlowFile(InputStream in, OutputStream out) throws IOException {
        ++this.flowFilesRead;
        TarArchiveInputStream tarIn = new TarArchiveInputStream(in);
        TarArchiveEntry attribEntry = tarIn.getNextTarEntry();
        if (attribEntry == null) {
            return null;
        }
        if (!attribEntry.getName().equals("flowfile.attributes")) {
            throw new IOException("Expected two tar entries: flowfile.content and flowfile.attributes");
        }
        Map<String, String> attributes = this.getAttributes(tarIn);
        TarArchiveEntry contentEntry = tarIn.getNextTarEntry();
        if (contentEntry != null && contentEntry.getName().equals("flowfile.content")) {
            byte[] buffer = new byte[524288];
            int bytesRead = 0;
            while ((bytesRead = tarIn.read(buffer)) != -1) {
                if (bytesRead <= 0) continue;
                out.write(buffer, 0, bytesRead);
            }
        } else {
            throw new IOException("Expected two tar entries: flowfile.content and flowfile.attributes");
        }
        out.flush();
        return attributes;
    }

    protected Map<String, String> getAttributes(TarArchiveInputStream stream) throws IOException {
        Properties props = new Properties();
        props.loadFromXML(new NonCloseableInputStream((InputStream)stream));
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            Object keyObject = entry.getKey();
            Object valueObject = entry.getValue();
            if (!(keyObject instanceof String)) {
                throw new IOException("Flow file attributes object contains key of type " + keyObject.getClass().getCanonicalName() + " but expected java.lang.String");
            }
            if (!(keyObject instanceof String)) {
                throw new IOException("Flow file attributes object contains value of type " + keyObject.getClass().getCanonicalName() + " but expected java.lang.String");
            }
            String key = (String)keyObject;
            String value = (String)valueObject;
            result.put(key, value);
        }
        return result;
    }

    @Override
    public boolean hasMoreData() throws IOException {
        return this.flowFilesRead == 0;
    }

    public static final class NonCloseableInputStream
    extends InputStream {
        final InputStream stream;

        public NonCloseableInputStream(InputStream stream) {
            this.stream = stream;
        }

        @Override
        public void close() {
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int available() throws IOException {
            return this.stream.available();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.stream.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.stream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.stream.skip(n);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }
    }
}

