/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.flow.VersionedFlowCoordinates;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.client.BucketClient;
import org.apache.nifi.registry.client.FlowClient;
import org.apache.nifi.registry.client.FlowSnapshotClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryClientConfig;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.RequestConfig;
import org.apache.nifi.registry.client.impl.JerseyNiFiRegistryClient;
import org.apache.nifi.registry.client.impl.request.ProxiedEntityRequestConfig;
import org.apache.nifi.registry.flow.AbstractFlowRegistryClient;
import org.apache.nifi.registry.flow.FlowAlreadyExistsException;
import org.apache.nifi.registry.flow.FlowRegistryBucket;
import org.apache.nifi.registry.flow.FlowRegistryClientConfigurationContext;
import org.apache.nifi.registry.flow.FlowRegistryException;
import org.apache.nifi.registry.flow.NifiRegistryUtil;
import org.apache.nifi.registry.flow.NoSuchBucketException;
import org.apache.nifi.registry.flow.NoSuchFlowException;
import org.apache.nifi.registry.flow.NoSuchFlowVersionException;
import org.apache.nifi.registry.flow.RegisteredFlow;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshotMetadata;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.security.util.StandardTlsConfiguration;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.ssl.SSLContextService;

public class NifiRegistryFlowRegistryClient
extends AbstractFlowRegistryClient {
    public static final PropertyDescriptor PROPERTY_URL = new PropertyDescriptor.Builder().name("url").displayName("URL").description("URL of the NiFi Registry").addValidator(StandardValidators.URL_VALIDATOR).required(true).build();
    static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("ssl-context-service").displayName("SSL Context Service").description("Specifies the SSL Context Service to use for communicating with NiFiRegistry").required(false).identifiesControllerService(SSLContextService.class).build();
    private volatile String registryUrl;
    private volatile NiFiRegistryClient registryClient;

    private synchronized NiFiRegistryClient getRegistryClient(FlowRegistryClientConfigurationContext context) {
        String proposedUrl = this.getProposedUri(context);
        if (!proposedUrl.equals(this.registryUrl)) {
            this.registryUrl = proposedUrl;
            this.invalidateClient();
        }
        if (this.registryClient != null) {
            return this.registryClient;
        }
        NiFiRegistryClientConfig config = new NiFiRegistryClientConfig.Builder().connectTimeout(Integer.valueOf(30000)).readTimeout(Integer.valueOf(30000)).sslContext(this.extractSSLContext(context)).baseUrl(this.registryUrl).build();
        this.registryClient = new JerseyNiFiRegistryClient.Builder().config(config).build();
        return this.registryClient;
    }

    private String getProposedUri(FlowRegistryClientConfigurationContext context) {
        URI uri;
        String configuredUrl = context.getProperty(PROPERTY_URL).evaluateAttributeExpressions().getValue();
        try {
            URI fullUri = URI.create(configuredUrl);
            int port = fullUri.getPort();
            Object portSuffix = port < 0 ? "" : ":" + port;
            String uriString = fullUri.getScheme() + "://" + fullUri.getHost() + (String)portSuffix;
            uri = URI.create(uriString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The given Registry URL is not valid: " + configuredUrl);
        }
        String uriScheme = uri.getScheme();
        if (uriScheme == null) {
            throw new IllegalArgumentException("The given Registry URL is not valid: " + configuredUrl);
        }
        return uri.toString();
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Arrays.asList(PROPERTY_URL, SSL_CONTEXT_SERVICE);
    }

    private synchronized void invalidateClient() {
        this.registryClient = null;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        SSLContextService sslContextService;
        HashSet<ValidationResult> result = new HashSet<ValidationResult>();
        if (context.getProperty(SSL_CONTEXT_SERVICE).isSet() && (sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class)).isTrustStoreConfigured() ^ sslContextService.isKeyStoreConfigured()) {
            result.add(new ValidationResult.Builder().subject(((Object)((Object)this)).getClass().getSimpleName()).valid(false).explanation("It is expected to either set all the properties for the SSLContext or set none").build());
        }
        return result;
    }

    private String extractIdentity(FlowRegistryClientConfigurationContext context) {
        return context.getNiFiUserIdentity().orElse(null);
    }

    private SSLContext extractSSLContext(FlowRegistryClientConfigurationContext context) {
        if (context.getProperty(SSL_CONTEXT_SERVICE).isSet()) {
            TlsConfiguration tlsConfiguration = NifiRegistryFlowRegistryClient.createTlsConfigurationFromContext(context);
            try {
                return SslContextFactory.createSslContext((TlsConfiguration)tlsConfiguration);
            }
            catch (TlsException e) {
                throw new IllegalStateException("Could not instantiate flow registry client because of TLS issues", e);
            }
        }
        return this.getSystemSslContext().orElse(null);
    }

    public boolean isStorageLocationApplicable(FlowRegistryClientConfigurationContext context, String location) {
        return location != null && location.startsWith(this.getProposedUri(context));
    }

    public Set<FlowRegistryBucket> getBuckets(FlowRegistryClientConfigurationContext context) throws FlowRegistryException, IOException {
        try {
            BucketClient bucketClient = this.getBucketClient(context);
            return bucketClient.getAll().stream().map(NifiRegistryUtil::convert).collect(Collectors.toSet());
        }
        catch (NiFiRegistryException e) {
            throw new FlowRegistryException(e.getMessage(), (Throwable)e);
        }
    }

    public FlowRegistryBucket getBucket(FlowRegistryClientConfigurationContext context, String bucketId) throws FlowRegistryException, IOException {
        try {
            BucketClient bucketClient = this.getBucketClient(context);
            Bucket bucket = bucketClient.get(bucketId);
            if (bucket == null) {
                throw new NoSuchBucketException(String.format("Bucket %s does not exist in the registry", bucketId));
            }
            return NifiRegistryUtil.convert(bucket);
        }
        catch (NiFiRegistryException e) {
            throw new FlowRegistryException(e.getMessage(), (Throwable)e);
        }
    }

    public RegisteredFlow registerFlow(FlowRegistryClientConfigurationContext context, RegisteredFlow flow) throws FlowRegistryException, IOException {
        try {
            FlowClient flowClient = this.getFlowClient(context);
            if (flowClient.getByBucket(flow.getBucketIdentifier()).stream().map(f -> f.getName()).collect(Collectors.toSet()).contains(flow.getName())) {
                throw new FlowAlreadyExistsException(String.format("Flow %s within bucket %s already exists", flow.getName(), flow.getBucketIdentifier()));
            }
            return NifiRegistryUtil.convert(flowClient.create(NifiRegistryUtil.convert(flow)));
        }
        catch (NiFiRegistryException e) {
            throw new FlowRegistryException(e.getMessage(), (Throwable)e);
        }
    }

    public RegisteredFlow deregisterFlow(FlowRegistryClientConfigurationContext context, String bucketId, String flowId) throws FlowRegistryException, IOException {
        try {
            FlowClient flowClient = this.getFlowClient(context);
            return NifiRegistryUtil.convert(flowClient.delete(bucketId, flowId));
        }
        catch (NiFiRegistryException e) {
            throw new FlowRegistryException(e.getMessage(), (Throwable)e);
        }
    }

    public RegisteredFlow getFlow(FlowRegistryClientConfigurationContext context, String bucketId, String flowId) throws FlowRegistryException, IOException {
        try {
            FlowClient flowClient = this.getFlowClient(context);
            VersionedFlow flow = flowClient.get(bucketId, flowId);
            if (flow == null) {
                throw new NoSuchFlowException(String.format("Flow %s does not exist in bucket %s", flowId, bucketId));
            }
            return NifiRegistryUtil.convert(flow);
        }
        catch (NiFiRegistryException e) {
            throw new FlowRegistryException(e.getMessage(), (Throwable)e);
        }
    }

    public Set<RegisteredFlow> getFlows(FlowRegistryClientConfigurationContext context, String bucketId) throws FlowRegistryException, IOException {
        try {
            FlowClient flowClient = this.getFlowClient(context);
            return flowClient.getByBucket(bucketId).stream().map(NifiRegistryUtil::convert).collect(Collectors.toSet());
        }
        catch (NiFiRegistryException e) {
            throw new FlowRegistryException(e.getMessage(), (Throwable)e);
        }
    }

    public RegisteredFlowSnapshot getFlowContents(FlowRegistryClientConfigurationContext context, String bucketId, String flowId, int version) throws FlowRegistryException, IOException {
        try {
            FlowSnapshotClient snapshotClient = this.getFlowSnapshotClient(context);
            VersionedFlowSnapshot snapshot = snapshotClient.get(bucketId, flowId, version);
            if (snapshot == null) {
                throw new NoSuchFlowVersionException(String.format("Version %d of flow %s does not exist in bucket %s", version, flowId, bucketId));
            }
            return NifiRegistryUtil.convert(snapshot);
        }
        catch (NiFiRegistryException e) {
            throw new FlowRegistryException(e.getMessage(), (Throwable)e);
        }
    }

    public RegisteredFlowSnapshot registerFlowSnapshot(FlowRegistryClientConfigurationContext context, RegisteredFlowSnapshot flowSnapshot) throws FlowRegistryException, IOException {
        try {
            FlowSnapshotClient snapshotClient = this.getFlowSnapshotClient(context);
            VersionedFlowSnapshot versionedFlowSnapshot = snapshotClient.create(NifiRegistryUtil.convert(flowSnapshot));
            VersionedFlowCoordinates versionedFlowCoordinates = new VersionedFlowCoordinates();
            String bucketId = versionedFlowSnapshot.getFlow().getBucketIdentifier();
            String flowId = versionedFlowSnapshot.getFlow().getIdentifier();
            int version = (int)versionedFlowSnapshot.getFlow().getVersionCount();
            versionedFlowCoordinates.setRegistryId(this.getIdentifier());
            versionedFlowCoordinates.setBucketId(bucketId);
            versionedFlowCoordinates.setFlowId(flowId);
            versionedFlowCoordinates.setVersion(version);
            versionedFlowCoordinates.setStorageLocation(this.getProposedUri(context) + "/nifi-registry-api/buckets/" + bucketId + "/flows/" + flowId + "/versions/" + version);
            versionedFlowSnapshot.getFlowContents().setVersionedFlowCoordinates(versionedFlowCoordinates);
            return NifiRegistryUtil.convert(versionedFlowSnapshot);
        }
        catch (NiFiRegistryException e) {
            throw new FlowRegistryException(e.getMessage(), (Throwable)e);
        }
    }

    public Set<RegisteredFlowSnapshotMetadata> getFlowVersions(FlowRegistryClientConfigurationContext context, String bucketId, String flowId) throws FlowRegistryException, IOException {
        try {
            FlowSnapshotClient snapshotClient = this.getFlowSnapshotClient(context);
            return snapshotClient.getSnapshotMetadata(bucketId, flowId).stream().map(NifiRegistryUtil::convert).collect(Collectors.toSet());
        }
        catch (NiFiRegistryException e) {
            throw new FlowRegistryException(e.getMessage(), (Throwable)e);
        }
    }

    public int getLatestVersion(FlowRegistryClientConfigurationContext context, String bucketId, String flowId) throws FlowRegistryException, IOException {
        try {
            return (int)this.getFlowClient(context).get(bucketId, flowId).getVersionCount();
        }
        catch (NiFiRegistryException e) {
            throw new FlowRegistryException(e.getMessage(), (Throwable)e);
        }
    }

    private BucketClient getBucketClient(FlowRegistryClientConfigurationContext context) {
        NiFiRegistryClient registryClient = this.getRegistryClient(context);
        return context.getNiFiUserIdentity().isPresent() ? registryClient.getBucketClient((RequestConfig)new ProxiedEntityRequestConfig(new String[]{this.extractIdentity(context)})) : registryClient.getBucketClient();
    }

    private FlowSnapshotClient getFlowSnapshotClient(FlowRegistryClientConfigurationContext context) {
        NiFiRegistryClient registryClient = this.getRegistryClient(context);
        return context.getNiFiUserIdentity().isPresent() ? registryClient.getFlowSnapshotClient((RequestConfig)new ProxiedEntityRequestConfig(new String[]{this.extractIdentity(context)})) : registryClient.getFlowSnapshotClient();
    }

    private FlowClient getFlowClient(FlowRegistryClientConfigurationContext context) {
        NiFiRegistryClient registryClient = this.getRegistryClient(context);
        return context.getNiFiUserIdentity().isPresent() ? registryClient.getFlowClient((RequestConfig)new ProxiedEntityRequestConfig(new String[]{this.extractIdentity(context)})) : registryClient.getFlowClient();
    }

    private static TlsConfiguration createTlsConfigurationFromContext(FlowRegistryClientConfigurationContext context) {
        return new StandardTlsConfiguration(((SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class)).createTlsConfiguration());
    }
}

