/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx.parser.bxml.value;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.nifi.processors.evtx.parser.BinaryReader;
import org.apache.nifi.processors.evtx.parser.ChunkHeader;
import org.apache.nifi.processors.evtx.parser.bxml.BxmlNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.VariantTypeNode;

public class SystemtimeTypeNode
extends VariantTypeNode {
    private final String value;

    public SystemtimeTypeNode(BinaryReader binaryReader, ChunkHeader chunkHeader, BxmlNode parent, int length) throws IOException {
        super(binaryReader, chunkHeader, parent, length);
        int year = binaryReader.readWord();
        int month = binaryReader.readWord();
        int dayOfWeek = binaryReader.readWord();
        int day = binaryReader.readWord();
        int hour = binaryReader.readWord();
        int minute = binaryReader.readWord();
        int second = binaryReader.readWord();
        int millisecond = binaryReader.readWord();
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day, hour, minute, second);
        calendar.set(14, millisecond);
        this.value = SystemtimeTypeNode.getFormat().format(calendar.getTime());
    }

    public static final SimpleDateFormat getFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

