/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.event.transport.netty.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.event.transport.EventDroppedException;
import org.apache.nifi.event.transport.message.ByteArrayMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ByteArrayMessageChannelHandler
extends SimpleChannelInboundHandler<ByteArrayMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByteArrayMessageChannelHandler.class);
    private static final long OFFER_TIMEOUT = 500L;
    private final BlockingQueue<ByteArrayMessage> messages;

    public ByteArrayMessageChannelHandler(BlockingQueue<ByteArrayMessage> messages) {
        this.messages = messages;
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, ByteArrayMessage message) {
        LOGGER.debug("Message Received Length [{}] Remote Address [{}] ", (Object)message.getMessage().length, (Object)message.getSender());
        EventExecutor executor = channelHandlerContext.executor();
        while (!this.offer(message)) {
            if (!executor.isShuttingDown()) continue;
            throw new EventDroppedException(String.format("Dropped Message from Remote Address [%s] executor shutting down", message.getSender()));
        }
        LOGGER.debug("Message Queued Length [{}] Remote Address [{}] ", (Object)message.getMessage().length, (Object)message.getSender());
    }

    private boolean offer(ByteArrayMessage message) {
        try {
            return this.messages.offer(message, 500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new EventDroppedException(String.format("Dropped Message from Remote Address [%s] queue offer interrupted", message.getSender()), e);
        }
    }
}

