/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.event.transport.netty.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.BlockingQueue;
import org.apache.nifi.event.transport.message.ByteArrayMessage;
import org.apache.nifi.event.transport.netty.channel.ByteArrayMessageChannelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class FilteringByteArrayMessageChannelHandler
extends ByteArrayMessageChannelHandler {
    private static final Logger logger = LoggerFactory.getLogger(FilteringByteArrayMessageChannelHandler.class);

    public FilteringByteArrayMessageChannelHandler(BlockingQueue<ByteArrayMessage> messages) {
        super(messages);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext channelHandlerContext, ByteArrayMessage message) {
        if (message.getMessage().length == 0) {
            logger.debug("Empty Message Received from Remote Address [{}] ", (Object)message.getSender());
        } else {
            super.channelRead0(channelHandlerContext, message);
        }
    }
}

