/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors;

import com.maxmind.geoip2.DatabaseReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.file.monitor.LastModifiedMonitor;
import org.apache.nifi.util.file.monitor.SynchronousFileWatcher;
import org.apache.nifi.util.file.monitor.UpdateMonitor;

public abstract class AbstractEnrichIP
extends AbstractProcessor {
    public static final PropertyDescriptor GEO_DATABASE_FILE = new PropertyDescriptor.Builder().name("Geo Database File").displayName("MaxMind Database File").description("Path to Maxmind IP Enrichment Database File").required(true).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[]{ResourceType.DIRECTORY}).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor IP_ADDRESS_ATTRIBUTE = new PropertyDescriptor.Builder().name("IP Address Attribute").displayName("IP Address Attribute").required(true).description("The name of an attribute whose value is a dotted decimal IP address for which enrichment should occur").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).build();
    public static final PropertyDescriptor LOG_LEVEL = new PropertyDescriptor.Builder().name("Log Level").displayName("Log Level").required(true).description("The Log Level to use when an IP is not found in the database. Accepted values: INFO, DEBUG, WARN, ERROR.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue(MessageLogLevel.WARN.toString()).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final Relationship REL_FOUND = new Relationship.Builder().name("found").description("Where to route flow files after successfully enriching attributes with data provided by database").build();
    public static final Relationship REL_NOT_FOUND = new Relationship.Builder().name("not found").description("Where to route flow files after unsuccessfully enriching attributes because no data was found").build();
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> propertyDescriptors;
    final AtomicReference<DatabaseReader> databaseReaderRef = new AtomicReference<Object>(null);
    private volatile SynchronousFileWatcher watcher;
    private final ReadWriteLock dbReadWriteLock = new ReentrantReadWriteLock();
    private volatile File dbFile;
    private volatile boolean needsReload = true;

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IOException {
        this.dbFile = context.getProperty(GEO_DATABASE_FILE).evaluateAttributeExpressions().asResource().asFile();
        this.watcher = new SynchronousFileWatcher(Paths.get(this.dbFile.toURI()), (UpdateMonitor)new LastModifiedMonitor(), 30000L);
        this.loadDatabaseFile();
    }

    protected void loadDatabaseFile() throws IOException {
        StopWatch stopWatch = new StopWatch(true);
        DatabaseReader reader = new DatabaseReader.Builder(this.dbFile).build();
        stopWatch.stop();
        this.getLogger().info("Completed loading of Maxmind Database.  Elapsed time was {} milliseconds.", new Object[]{stopWatch.getDuration(TimeUnit.MILLISECONDS)});
        this.databaseReaderRef.set(reader);
    }

    @OnStopped
    public void closeReader() throws IOException {
        DatabaseReader reader = this.databaseReaderRef.get();
        if (reader != null) {
            reader.close();
        }
    }

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> rels = new HashSet<Relationship>();
        rels.add(REL_FOUND);
        rels.add(REL_NOT_FOUND);
        this.relationships = Collections.unmodifiableSet(rels);
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(GEO_DATABASE_FILE);
        props.add(IP_ADDRESS_ATTRIBUTE);
        props.add(LOG_LEVEL);
        this.propertyDescriptors = Collections.unmodifiableList(props);
    }

    protected SynchronousFileWatcher getWatcher() {
        return this.watcher;
    }

    protected Lock getDbWriteLock() {
        return this.dbReadWriteLock.writeLock();
    }

    protected Lock getDbReadLock() {
        return this.dbReadWriteLock.readLock();
    }

    protected boolean isNeedsReload() {
        return this.needsReload;
    }

    protected void setNeedsReload(boolean needsReload) {
        this.needsReload = needsReload;
    }

    static enum MessageLogLevel {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

