/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.enrich;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;

public abstract class AbstractEnrichProcessor
extends AbstractProcessor {
    public static final PropertyDescriptor QUERY_INPUT = new PropertyDescriptor.Builder().name("QUERY_INPUT").displayName("Lookup value").required(true).description("The value that should be used to populate the query").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final AllowableValue SPLIT = new AllowableValue("Split", "Split", "Use a delimiter character or RegEx  to split the results into attributes");
    public static final AllowableValue REGEX = new AllowableValue("RegEx", "RegEx", "Use a regular expression to split the results into attributes ");
    public static final AllowableValue NONE = new AllowableValue("None", "None", "Do not split results");
    public static final PropertyDescriptor QUERY_PARSER = new PropertyDescriptor.Builder().name("QUERY_PARSER").displayName("Results Parser").description("The method used to slice the results into attribute groups").allowableValues(new AllowableValue[]{SPLIT, REGEX, NONE}).required(true).defaultValue(NONE.getValue()).build();
    public static final PropertyDescriptor QUERY_PARSER_INPUT = new PropertyDescriptor.Builder().name("QUERY_PARSER_INPUT").displayName("Parser RegEx").description("Choice between a splitter and regex matcher used to parse the results of the query into attribute groups.\nNOTE: This is a multiline regular expression, therefore, the DFM should decide how to handle trailing new line characters.").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(false).addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).build();
    public static final PropertyDescriptor KEY_GROUP = new PropertyDescriptor.Builder().name("KEY_GROUP").displayName("Key lookup group (multiline / batch)").description("When performing a batched lookup, the following RegEx numbered capture group or Column number will be used to match the whois server response with the lookup field").required(false).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final Relationship REL_FOUND = new Relationship.Builder().name("found").description("Where to route flow files after successfully enriching attributes with data").build();
    public static final Relationship REL_NOT_FOUND = new Relationship.Builder().name("not found").description("Where to route flow files if data enrichment query rendered no results").build();

    public List<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        String chosenQUERY_PARSER = validationContext.getProperty(QUERY_PARSER).getValue();
        if (!chosenQUERY_PARSER.equals(NONE.getValue()) && !validationContext.getProperty(QUERY_PARSER_INPUT).isSet()) {
            results.add(new ValidationResult.Builder().input("QUERY_PARSER_INPUT").subject(QUERY_PARSER.getDisplayName()).explanation("Split and Regex parsers require a valid Regular Expression").valid(false).build());
        }
        if (chosenQUERY_PARSER.equals(NONE.getValue()) && validationContext.getProperty(QUERY_PARSER_INPUT).isSet()) {
            results.add(new ValidationResult.Builder().input("QUERY_PARSER").subject(QUERY_PARSER_INPUT.getDisplayName()).explanation("NONE parser does not support the use of Regular Expressions. Please select another parser or delete the regular expression entered in this field.").valid(false).build());
        }
        return results;
    }

    protected Map<String, String> parseResponse(String recordPosition, String rawResult, String queryParser, String queryRegex, String schema) {
        HashMap<String, String> results = new HashMap<String, String>();
        recordPosition = StringUtils.isEmpty((CharSequence)recordPosition) ? "0" : recordPosition;
        switch (queryParser) {
            case "Split": {
                String[] splitResult = rawResult.split(queryRegex);
                for (int r = 0; r < splitResult.length; ++r) {
                    results.put("enrich." + schema + ".record" + recordPosition + ".group" + String.valueOf(r), splitResult[r]);
                }
                break;
            }
            case "RegEx": {
                Pattern p = Pattern.compile(queryRegex);
                Matcher finalResult = p.matcher(rawResult);
                if (!finalResult.find()) break;
                for (int r = 0; r < finalResult.groupCount(); ++r) {
                    results.put("enrich." + schema + ".record" + recordPosition + ".group" + String.valueOf(r), finalResult.group(r));
                }
                break;
            }
            default: {
                results.put("enrich." + schema + ".record" + recordPosition + ".group0", rawResult);
            }
        }
        return results;
    }

    protected Map<String, Map<String, String>> parseBatchResponse(String rawResult, String queryParser, String queryRegex, int lookupKey, String schema) {
        String recordPosition = ".record0";
        LinkedHashMap<String, Map<String, String>> results = new LinkedHashMap<String, Map<String, String>>();
        switch (queryParser) {
            case "Split": {
                Scanner scanner = new Scanner(rawResult);
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    String[] splitResult = line.split(queryRegex);
                    for (int r = 0; r < splitResult.length; ++r) {
                        String key = splitResult[lookupKey - 1];
                        String group = "enrich." + schema + ".record0.group" + r;
                        String result = splitResult[r];
                        LinkedHashMap<CallSite, String> row = (LinkedHashMap<CallSite, String>)results.get(key);
                        if (row == null) {
                            row = new LinkedHashMap<CallSite, String>();
                        }
                        row.put((CallSite)((Object)group), result);
                        results.put(key, row);
                    }
                }
                break;
            }
            case "RegEx": {
                Pattern p = Pattern.compile(queryRegex, 8);
                Matcher matcher = p.matcher(rawResult);
                while (matcher.find()) {
                    try {
                        for (int r = 0; r <= matcher.groupCount(); ++r) {
                            String key = matcher.group(lookupKey);
                            String group = "enrich." + schema + ".record0.group" + String.valueOf(r);
                            String result = matcher.group(r);
                            LinkedHashMap<CallSite, String> row = (LinkedHashMap<CallSite, String>)results.get(key);
                            if (row == null) {
                                row = new LinkedHashMap<CallSite, String>();
                            }
                            row.put((CallSite)((Object)group), result);
                            results.put(key, row);
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.getLogger().warn("Could not find capture group {} while processing result. You may want to review your Regular Expression to match against the content \"{}\"", new Object[]{lookupKey, rawResult});
                    }
                }
                break;
            }
        }
        return results;
    }
}

