/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.email;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.FlowFileHandlingException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.poi.hmef.Attachment;
import org.apache.poi.hmef.HMEFMessage;

@SupportsBatching
@EventDriven
@SideEffectFree
@Tags(value={"split", "email"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Extract attachments from a mime formatted email file, splitting them into individual flowfiles.")
@WritesAttributes(value={@WritesAttribute(attribute="filename ", description="The filename of the attachment"), @WritesAttribute(attribute="email.tnef.attachment.parent.filename ", description="The filename of the parent FlowFile"), @WritesAttribute(attribute="email.tnef.attachment.parent.uuid", description="The UUID of the original FlowFile.")})
public class ExtractTNEFAttachments
extends AbstractProcessor {
    public static final String ATTACHMENT_ORIGINAL_FILENAME = "email.tnef.attachment.parent.filename";
    public static final String ATTACHMENT_ORIGINAL_UUID = "email.tnef.attachment.parent.uuid";
    public static final Relationship REL_ATTACHMENTS = new Relationship.Builder().name("attachments").description("Each individual attachment will be routed to the attachments relationship").build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("Each original flowfile (i.e. before extraction) will be routed to the original relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Each individual flowfile that could not be parsed will be routed to the failure relationship").build();
    private static final Set<Relationship> RELATIONSHIPS;
    private static final List<PropertyDescriptor> DESCRIPTORS;

    public void onTrigger(ProcessContext context, final ProcessSession session) {
        final ComponentLog logger = this.getLogger();
        final FlowFile originalFlowFile = session.get();
        if (originalFlowFile == null) {
            return;
        }
        final ArrayList attachmentsList = new ArrayList();
        final ArrayList invalidFlowFilesList = new ArrayList();
        final ArrayList originalFlowFilesList = new ArrayList();
        session.read(originalFlowFile, new InputStreamCallback(){

            public void process(InputStream rawIn) throws IOException {
                block11: {
                    try (BufferedInputStream in = new BufferedInputStream(rawIn);){
                        Properties props = new Properties();
                        HMEFMessage hmefMessage = null;
                        hmefMessage = new HMEFMessage((InputStream)in);
                        originalFlowFilesList.add(originalFlowFile);
                        if (hmefMessage == null || hmefMessage.getAttachments().isEmpty()) break block11;
                        String originalFlowFileName = originalFlowFile.getAttribute(CoreAttributes.FILENAME.key());
                        try {
                            for (final Attachment attachment : hmefMessage.getAttachments()) {
                                FlowFile split = session.create(originalFlowFile);
                                HashMap<String, String> attributes = new HashMap<String, String>();
                                if (StringUtils.isNotBlank((CharSequence)attachment.getLongFilename())) {
                                    attributes.put(CoreAttributes.FILENAME.key(), attachment.getFilename());
                                }
                                String parentUuid = originalFlowFile.getAttribute(CoreAttributes.UUID.key());
                                attributes.put(ExtractTNEFAttachments.ATTACHMENT_ORIGINAL_UUID, parentUuid);
                                attributes.put(ExtractTNEFAttachments.ATTACHMENT_ORIGINAL_FILENAME, originalFlowFileName);
                                split = session.append(split, new OutputStreamCallback(){

                                    public void process(OutputStream out) throws IOException {
                                        out.write(attachment.getContents());
                                    }
                                });
                                split = session.putAllAttributes(split, attributes);
                                attachmentsList.add(split);
                            }
                        }
                        catch (FlowFileHandlingException e) {
                            session.remove((Collection)attachmentsList);
                            originalFlowFilesList.remove(originalFlowFile);
                            logger.error("Flowfile {} triggered error {} while processing message removing generated FlowFiles from sessions", new Object[]{originalFlowFile, e});
                            invalidFlowFilesList.add(originalFlowFile);
                        }
                    }
                    catch (Exception e) {
                        originalFlowFilesList.remove(originalFlowFile);
                        logger.error("Could not parse the flowfile {} as an email, treating as failure", new Object[]{originalFlowFile, e});
                        invalidFlowFilesList.add(originalFlowFile);
                    }
                }
            }
        });
        session.transfer(attachmentsList, REL_ATTACHMENTS);
        session.transfer(invalidFlowFilesList, REL_FAILURE);
        session.transfer(originalFlowFilesList, REL_ORIGINAL);
        if (attachmentsList.size() != 0) {
            if (attachmentsList.size() > 10) {
                logger.info("Split {} into {} files", new Object[]{originalFlowFile, attachmentsList.size()});
            } else {
                logger.info("Split {} into {} files: {}", new Object[]{originalFlowFile, attachmentsList.size(), attachmentsList});
            }
        }
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    static {
        HashSet<Relationship> _relationships = new HashSet<Relationship>();
        _relationships.add(REL_ATTACHMENTS);
        _relationships.add(REL_ORIGINAL);
        _relationships.add(REL_FAILURE);
        RELATIONSHIPS = Collections.unmodifiableSet(_relationships);
        ArrayList _descriptors = new ArrayList();
        DESCRIPTORS = Collections.unmodifiableList(_descriptors);
    }
}

