/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.email;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.email.AbstractEmailProcessor;
import org.springframework.integration.mail.Pop3MailReceiver;

@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@CapabilityDescription(value="Consumes messages from Email Server using POP3 protocol. The raw-bytes of each received email message are written as contents of the FlowFile")
@Tags(value={"Email", "POP3", "Get", "Ingest", "Ingress", "Message", "Consume"})
public class ConsumePOP3
extends AbstractEmailProcessor<Pop3MailReceiver> {
    static final List<PropertyDescriptor> DESCRIPTORS;

    @Override
    protected String getProtocol(ProcessContext processContext) {
        return "pop3";
    }

    @Override
    protected Pop3MailReceiver buildMessageReceiver(ProcessContext context) {
        Pop3MailReceiver receiver = new Pop3MailReceiver(this.buildUrl(context));
        receiver.setShouldDeleteMessages(context.getProperty(AbstractEmailProcessor.SHOULD_DELETE_MESSAGES).asBoolean().booleanValue());
        return receiver;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    static {
        ArrayList _descriptors = new ArrayList();
        _descriptors.addAll(SHARED_DESCRIPTORS);
        DESCRIPTORS = Collections.unmodifiableList(_descriptors);
    }
}

