/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.elasticsearch.integration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.nifi.elasticsearch.MapBuilder;
import org.apache.nifi.util.TestRunner;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.junit.jupiter.api.BeforeAll;
import org.testcontainers.elasticsearch.ElasticsearchContainer;
import org.testcontainers.shaded.org.apache.commons.lang3.RandomStringUtils;
import org.testcontainers.utility.DockerImageName;

public abstract class AbstractElasticsearchITBase {
    protected static final DockerImageName IMAGE = DockerImageName.parse((String)System.getProperty("elasticsearch.docker.image", "docker.elastic.co/elasticsearch/elasticsearch:8.5.0"));
    protected static final String ELASTIC_USER_PASSWORD = System.getProperty("elasticsearch.elastic_user.password", RandomStringUtils.randomAlphanumeric((int)10, (int)20));
    protected static final ElasticsearchContainer ELASTICSEARCH_CONTAINER = (ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)new ElasticsearchContainer(IMAGE).withPassword(ELASTIC_USER_PASSWORD).withEnv("xpack.security.enabled", "true")).withEnv("xpack.license.self_generated.type", "trial")).withEnv("xpack.security.authc.api_key.enabled", "true");
    protected static final String CLIENT_SERVICE_NAME = "Client Service";
    protected static final String INDEX = "messages";
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    protected static final boolean ENABLE_TEST_CONTAINERS = "true".equalsIgnoreCase(System.getProperty("elasticsearch.testcontainers.enabled"));
    protected static String elasticsearchHost;
    protected TestRunner runner;
    protected static String type;
    private static RestClient testDataManagementClient;

    protected static void startTestcontainer() {
        if (ENABLE_TEST_CONTAINERS) {
            if (AbstractElasticsearchITBase.getElasticMajorVersion() == 6) {
                ((ElasticsearchContainer)ELASTICSEARCH_CONTAINER.withEnv("bootstrap.system_call_filter", "false")).start();
            } else {
                ELASTICSEARCH_CONTAINER.start();
            }
            elasticsearchHost = String.format("http://%s", ELASTICSEARCH_CONTAINER.getHttpHostAddress());
        } else {
            elasticsearchHost = System.getProperty("elasticsearch.endpoint", "http://localhost:9200");
        }
    }

    protected static void stopTestcontainer() {
        if (ENABLE_TEST_CONTAINERS) {
            ELASTICSEARCH_CONTAINER.stop();
        }
    }

    @BeforeAll
    static void beforeAll() throws IOException {
        AbstractElasticsearchITBase.startTestcontainer();
        type = AbstractElasticsearchITBase.getElasticMajorVersion() == 6 ? "_doc" : "";
        System.out.printf("%n%n%n%n%n%n%n%n%n%n%n%n%n%n%nTYPE: %s%nIMAGE: %s:%s%n%n%n%n%n%n%n%n%n%n%n%n%n%n%n%n", type, IMAGE.getRepository(), IMAGE.getVersionPart());
        AbstractElasticsearchITBase.setupTestData();
    }

    private static String[] getElasticVersion() {
        String fullVersion = IMAGE.getVersionPart();
        String[] parts = fullVersion.split("\\.");
        if (parts.length == 1) {
            throw new IllegalArgumentException("The elasticsearch version should have at least a major and minor version ex. 7.17");
        }
        return parts;
    }

    protected static int getElasticMajorVersion() {
        return Integer.parseInt(AbstractElasticsearchITBase.getElasticVersion()[0]);
    }

    protected static int getElasticMinorVersion() {
        return Integer.parseInt(AbstractElasticsearchITBase.getElasticVersion()[1]);
    }

    protected static void setupTestData() throws IOException {
        int majorVersion = AbstractElasticsearchITBase.getElasticMajorVersion();
        URL url = new URL(elasticsearchHost);
        testDataManagementClient = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(url.getHost(), url.getPort(), url.getProtocol())}).setHttpClientConfigCallback(httpClientBuilder -> {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("elastic", ELASTIC_USER_PASSWORD);
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
            return httpClientBuilder;
        }).build();
        String script = String.format("src/test/resources/setup-%s.script", majorVersion);
        List<SetupAction> actions = AbstractElasticsearchITBase.readSetupActions(script);
        for (SetupAction action : actions) {
            String endpoint = String.format("%s/%s", elasticsearchHost, action.path);
            Request request = new Request(action.verb, endpoint);
            NStringEntity jsonBody = new NStringEntity(action.json, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)jsonBody);
            try {
                testDataManagementClient.performRequest(request);
            }
            catch (ResponseException re) {
                throw new IllegalStateException("Error performing action " + action, re);
            }
        }
    }

    protected static void tearDownTestData(List<String> testIndices) {
        testIndices.forEach(AbstractElasticsearchITBase::deleteIndex);
    }

    protected static void deleteIndex(String index) {
        Request request = new Request("DELETE", String.format("%s/%s", elasticsearchHost, index));
        try {
            testDataManagementClient.performRequest(request);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error deleting index " + index, ioe);
        }
    }

    protected String prettyJson(Object o) throws JsonProcessingException {
        return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(o);
    }

    protected Pair<String, String> createApiKeyForIndex(String index) throws IOException {
        String body = this.prettyJson(new MapBuilder().of("name", "test-api-key").of("role_descriptors", new MapBuilder().of("test-role", new MapBuilder().of("cluster", Collections.singletonList("all")).of("index", Collections.singletonList(new MapBuilder().of("names", Collections.singletonList(index)).of("privileges", Collections.singletonList("all")).build())).build()).build()).build());
        String endpoint = String.format("%s/%s", elasticsearchHost, "_security/api_key");
        Request request = new Request("POST", endpoint);
        NStringEntity jsonBody = new NStringEntity(body, ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)jsonBody);
        Response response = testDataManagementClient.performRequest(request);
        InputStream inputStream = response.getEntity().getContent();
        byte[] result = IOUtils.toByteArray((InputStream)inputStream);
        inputStream.close();
        Map ret = (Map)MAPPER.readValue(new String(result, StandardCharsets.UTF_8), Map.class);
        return Pair.of((Object)((String)ret.get("id")), (Object)((String)ret.get("api_key")));
    }

    private static List<SetupAction> readSetupActions(String scriptPath) throws IOException {
        ArrayList<SetupAction> actions = new ArrayList<SetupAction>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(scriptPath, new String[0]), new OpenOption[0])));){
            String line = reader.readLine();
            while (line != null) {
                if (!line.trim().isEmpty() && !line.trim().startsWith("#")) {
                    String verb = line.substring(0, line.indexOf(":"));
                    String path = line.substring(verb.length() + 1, line.indexOf(":", verb.length() + 1));
                    int loc = verb.length() + path.length() + 2;
                    String json = line.substring(loc);
                    actions.add(new SetupAction(verb, path, json));
                }
                line = reader.readLine();
            }
        }
        return actions;
    }

    private static final class SetupAction {
        private final String verb;
        private final String path;
        private final String json;

        public SetupAction(String verb, String path, String json) {
            this.verb = verb;
            this.path = path;
            this.json = json;
        }

        public String toString() {
            return "SetupAction{verb='" + this.verb + "', path='" + this.path + "'}";
        }
    }
}

