/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.elasticsearch.ElasticsearchException;
import org.apache.nifi.elasticsearch.IndexOperationRequest;
import org.apache.nifi.elasticsearch.IndexOperationResponse;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.elasticsearch.AbstractPutElasticsearch;
import org.apache.nifi.processors.elasticsearch.PutElasticsearchRecord;
import org.apache.nifi.util.StringUtils;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"json", "elasticsearch", "elasticsearch5", "elasticsearch6", "elasticsearch7", "elasticsearch8", "put", "index"})
@CapabilityDescription(value="An Elasticsearch put processor that uses the official Elastic REST client libraries. Each FlowFile is treated as a document to be sent to the Elasticsearch _bulk API. Multiple FlowFiles can be batched together into each Request sent to Elasticsearch.")
@WritesAttributes(value={@WritesAttribute(attribute="elasticsearch.put.error", description="The error message if there is an issue parsing the FlowFile, sending the parsed document to Elasticsearch or parsing the Elasticsearch response"), @WritesAttribute(attribute="elasticsearch.bulk.error", description="The _bulk response if there was an error during processing the document within Elasticsearch.")})
@SeeAlso(value={PutElasticsearchRecord.class})
@DynamicProperties(value={@DynamicProperty(name="The name of the Bulk request header", value="The value of the Bulk request header", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Prefix: BULK: - adds the specified property name/value as a Bulk request header in the Elasticsearch Bulk API body used for processing. If the value is null or blank, the Bulk header will be omitted for the document operation. These parameters will override any matching parameters in the _bulk request body."), @DynamicProperty(name="The name of a URL query parameter to add", value="The value of the URL query parameter", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Adds the specified property name/value as a query parameter in the Elasticsearch URL used for processing. These parameters will override any matching parameters in the _bulk request body. If FlowFiles are batched, only the first FlowFile in the batch is used to evaluate property values.")})
@SystemResourceConsideration(resource=SystemResource.MEMORY, description="The Batch of FlowFiles will be stored in memory until the bulk operation is performed.")
public class PutElasticsearchJson
extends AbstractPutElasticsearch {
    static final Relationship REL_FAILED_DOCUMENTS = new Relationship.Builder().name("errors").description("If a \"Output Error Documents\" is set, any FlowFile(s) corresponding to Elasticsearch document(s) that resulted in an \"error\" (within Elasticsearch) will be routed here.").autoTerminateDefault(true).build();
    static final PropertyDescriptor ID_ATTRIBUTE = new PropertyDescriptor.Builder().name("put-es-json-id-attr").displayName("Identifier Attribute").description("The name of the FlowFile attribute containing the identifier for the document. If the Index Operation is \"index\", this property may be left empty or evaluate to an empty value, in which case the document's identifier will be auto-generated by Elasticsearch. For all other Index Operations, the attribute must evaluate to a non-empty value.").required(false).expressionLanguageSupported(ExpressionLanguageScope.NONE).addValidator(StandardValidators.ATTRIBUTE_KEY_VALIDATOR).build();
    static final PropertyDescriptor SCRIPT = new PropertyDescriptor.Builder().name("put-es-json-script").displayName("Script").description("The script for the document update/upsert. Only applies to Update/Upsert operations. Must be parsable as JSON Object. If left blank, the FlowFile content will be used for document update/upsert").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    static final PropertyDescriptor SCRIPTED_UPSERT = new PropertyDescriptor.Builder().name("put-es-json-scripted-upsert").displayName("Scripted Upsert").description("Whether to add the scripted_upsert flag to the Upsert Operation. Forces Elasticsearch to execute the Script whether or not the document exists, defaults to false. If the Upsert Document provided (from FlowFile content) will be empty, but sure to set the " + CLIENT_SERVICE.getDisplayName() + " controller service's " + ElasticSearchClientService.SUPPRESS_NULLS.getDisplayName() + " to " + ElasticSearchClientService.NEVER_SUPPRESS.getDisplayName() + " or no \"upsert\" doc will be, included in the request to Elasticsearch and the operation will not create a new document for the script to execute against, resulting in a \"not_found\" error").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    static final PropertyDescriptor DYNAMIC_TEMPLATES = new PropertyDescriptor.Builder().name("put-es-json-dynamic_templates").displayName("Dynamic Templates").description("The dynamic_templates for the document. Must be parsable as a JSON Object. Requires Elasticsearch 7+").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    static final PropertyDescriptor CHARSET = new PropertyDescriptor.Builder().name("put-es-json-charset").displayName("Character Set").description("Specifies the character set of the document data.").addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue(StandardCharsets.UTF_8.name()).required(true).build();
    static final PropertyDescriptor OUTPUT_ERROR_DOCUMENTS = new PropertyDescriptor.Builder().name("put-es-json-error-documents").displayName("Output Error Documents").description("If this configuration property is true, the response from Elasticsearch will be examined for failed documents and the FlowFile(s) associated with the failed document(s) will be sent to the \"" + REL_FAILED_DOCUMENTS.getName() + "\" relationship with \"elasticsearch.bulk.error\" attributes.").allowableValues(new String[]{"true", "false"}).defaultValue("false").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).build();
    static final PropertyDescriptor NOT_FOUND_IS_SUCCESSFUL = new PropertyDescriptor.Builder().name("put-es-json-not_found-is-error").displayName("Treat \"Not Found\" as Success").description("If true, \"not_found\" Elasticsearch Document associated FlowFiles will be routed to the \"" + REL_SUCCESS.getName() + "\" relationship, otherwise to the \"" + REL_FAILED_DOCUMENTS.getName() + "\" relationship. If " + OUTPUT_ERROR_RESPONSES.getDisplayName() + " is \"true\" then \"not_found\" responses from Elasticsearch will be sent to the " + REL_ERROR_RESPONSES.getName() + " relationship").addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).defaultValue("true").required(false).dependsOn(OUTPUT_ERROR_DOCUMENTS, "true", new String[0]).build();
    static final List<PropertyDescriptor> DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(ID_ATTRIBUTE, INDEX_OP, INDEX, TYPE, SCRIPT, SCRIPTED_UPSERT, DYNAMIC_TEMPLATES, BATCH_SIZE, CHARSET, CLIENT_SERVICE, LOG_ERROR_RESPONSES, OUTPUT_ERROR_RESPONSES, OUTPUT_ERROR_DOCUMENTS, NOT_FOUND_IS_SUCCESSFUL));
    static final Set<Relationship> BASE_RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE, REL_RETRY, REL_FAILED_DOCUMENTS)));
    private boolean outputErrors;

    @Override
    Set<Relationship> getBaseRelationships() {
        return BASE_RELATIONSHIPS;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    @Override
    @OnScheduled
    public void onScheduled(ProcessContext context) {
        super.onScheduled(context);
        this.outputErrors = context.getProperty(OUTPUT_ERROR_DOCUMENTS).asBoolean();
        this.notFoundIsSuccessful = context.getProperty(NOT_FOUND_IS_SUCCESSFUL).asBoolean();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        int batchSize = context.getProperty(BATCH_SIZE).evaluateAttributeExpressions().asInteger();
        List flowFiles = session.get(batchSize);
        if (flowFiles.isEmpty()) {
            return;
        }
        String idAttribute = context.getProperty(ID_ATTRIBUTE).getValue();
        ArrayList<FlowFile> originals = new ArrayList<FlowFile>(flowFiles.size());
        ArrayList<IndexOperationRequest> operations = new ArrayList<IndexOperationRequest>(flowFiles.size());
        for (FlowFile input : flowFiles) {
            this.addOperation(operations, originals, idAttribute, context, session, input);
        }
        if (!originals.isEmpty()) {
            try {
                List<FlowFile> errorDocuments = this.indexDocuments(operations, originals, context, session);
                this.handleResponse(context, session, errorDocuments, originals);
            }
            catch (ElasticsearchException ese) {
                String msg = String.format("Encountered a server-side problem with Elasticsearch. %s", ese.isElastic() ? "Routing to retry." : "Routing to failure");
                this.getLogger().error(msg, (Throwable)ese);
                Relationship rel = ese.isElastic() ? REL_RETRY : REL_FAILURE;
                this.transferFlowFilesOnException((Exception)((Object)ese), rel, session, true, originals.toArray(new FlowFile[0]));
            }
            catch (JsonProcessingException jpe) {
                this.getLogger().warn("Could not log Elasticsearch operation errors nor determine which documents errored.", (Throwable)jpe);
                Relationship rel = this.outputErrors ? REL_FAILED_DOCUMENTS : REL_FAILURE;
                this.transferFlowFilesOnException((Exception)((Object)jpe), rel, session, true, originals.toArray(new FlowFile[0]));
            }
            catch (Exception ex) {
                this.getLogger().error("Could not index documents.", (Throwable)ex);
                this.transferFlowFilesOnException(ex, REL_FAILURE, session, false, originals.toArray(new FlowFile[0]));
                context.yield();
            }
        } else {
            this.getLogger().warn("No FlowFiles successfully parsed for sending to Elasticsearch");
        }
    }

    private void addOperation(List<IndexOperationRequest> operations, List<FlowFile> originals, String idAttribute, ProcessContext context, ProcessSession session, FlowFile input) {
        String indexOp = context.getProperty(INDEX_OP).evaluateAttributeExpressions(input).getValue();
        String index = context.getProperty(INDEX).evaluateAttributeExpressions(input).getValue();
        String type = context.getProperty(TYPE).evaluateAttributeExpressions(input).getValue();
        String id = StringUtils.isNotBlank((String)idAttribute) && StringUtils.isNotBlank((String)input.getAttribute(idAttribute)) ? input.getAttribute(idAttribute) : null;
        Map<String, Object> scriptMap = this.getMapFromAttribute(SCRIPT, context, input);
        boolean scriptedUpsert = context.getProperty(SCRIPTED_UPSERT).evaluateAttributeExpressions(input).asBoolean();
        Map<String, Object> dynamicTemplatesMap = this.getMapFromAttribute(DYNAMIC_TEMPLATES, context, input);
        Map dynamicProperties = this.getDynamicProperties(context, input);
        Map<String, String> bulkHeaderFields = this.getBulkHeaderParameters(dynamicProperties);
        String charset = context.getProperty(CHARSET).evaluateAttributeExpressions(input).getValue();
        try (InputStream inStream = session.read(input);){
            byte[] result = IOUtils.toByteArray((InputStream)inStream);
            Map contentMap = (Map)mapper.readValue(new String(result, charset), Map.class);
            IndexOperationRequest.Operation o = IndexOperationRequest.Operation.forValue((String)indexOp);
            operations.add(new IndexOperationRequest(index, type, id, contentMap, o, scriptMap, scriptedUpsert, dynamicTemplatesMap, bulkHeaderFields));
            originals.add(input);
        }
        catch (IOException ioe) {
            this.getLogger().error("Could not read FlowFile content valid JSON.", (Throwable)ioe);
            input = session.putAttribute(input, "elasticsearch.put.error", ioe.getMessage());
            session.penalize(input);
            session.transfer(input, REL_FAILURE);
        }
        catch (Exception ex) {
            this.getLogger().error("Could not index documents.", (Throwable)ex);
            input = session.putAttribute(input, "elasticsearch.put.error", ex.getMessage());
            session.penalize(input);
            session.transfer(input, REL_FAILURE);
        }
    }

    private Map<String, Object> getMapFromAttribute(PropertyDescriptor propertyDescriptor, ProcessContext context, FlowFile input) {
        String dynamicTemplates = context.getProperty(propertyDescriptor).evaluateAttributeExpressions(input).getValue();
        try {
            return StringUtils.isNotBlank((String)dynamicTemplates) ? (Map)mapper.readValue(dynamicTemplates, Map.class) : Collections.emptyMap();
        }
        catch (JsonProcessingException jpe) {
            throw new ProcessException(propertyDescriptor.getDisplayName() + " must be a String parsable into a JSON Object", (Throwable)jpe);
        }
    }

    private List<FlowFile> indexDocuments(List<IndexOperationRequest> operations, List<FlowFile> originals, ProcessContext context, ProcessSession session) throws IOException {
        ArrayList<FlowFile> errorDocuments;
        Map dynamicProperties = this.getDynamicProperties(context, originals.get(0));
        IndexOperationResponse response = ((ElasticSearchClientService)this.clientService.get()).bulk(operations, this.getRequestURLParameters(dynamicProperties));
        Map<Integer, Map<String, Object>> errors = this.findElasticsearchResponseErrors(response);
        ArrayList<FlowFile> arrayList = errorDocuments = this.outputErrors ? new ArrayList<FlowFile>(errors.size()) : Collections.emptyList();
        if (this.outputErrors) {
            errors.forEach((index, error) -> {
                String errorMessage;
                try {
                    errorMessage = mapper.writeValueAsString(error);
                }
                catch (JsonProcessingException e) {
                    errorMessage = String.format("{\"error\": {\"type\": \"elasticsearch_response_parse_error\", \"reason\": \"%s\"}}", e.getMessage().replace("\"", "\\\""));
                }
                errorDocuments.add(session.putAttribute((FlowFile)originals.get((int)index), "elasticsearch.bulk.error", errorMessage));
            });
        }
        if (!errors.isEmpty()) {
            this.handleElasticsearchDocumentErrors(errors, session, null);
        }
        return errorDocuments;
    }

    private void handleResponse(ProcessContext context, ProcessSession session, List<FlowFile> errorDocuments, List<FlowFile> originals) {
        session.transfer(errorDocuments, REL_FAILED_DOCUMENTS);
        errorDocuments.forEach(e -> session.getProvenanceReporter().send(e, ((ElasticSearchClientService)this.clientService.get()).getTransitUrl(context.getProperty(INDEX).evaluateAttributeExpressions(e).getValue(), context.getProperty(TYPE).evaluateAttributeExpressions(e).getValue()), "Elasticsearch _bulk operation error"));
        List<FlowFile> successfulDocuments = originals.stream().filter(f -> !errorDocuments.contains(f)).collect(Collectors.toList());
        session.transfer(successfulDocuments, REL_SUCCESS);
        successfulDocuments.forEach(s -> session.getProvenanceReporter().send(s, ((ElasticSearchClientService)this.clientService.get()).getTransitUrl(context.getProperty(INDEX).evaluateAttributeExpressions(s).getValue(), context.getProperty(TYPE).evaluateAttributeExpressions(s).getValue())));
    }
}

