/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch.api;

import java.util.Arrays;
import org.apache.nifi.components.DescribedValue;

public enum QueryDefinitionType implements DescribedValue
{
    FULL_QUERY("full", "Provide the full Query."),
    BUILD_QUERY("build", "Build the Query from separate JSON objects.");

    private final String value;
    private final String description;

    private QueryDefinitionType(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.name();
    }

    public String getDescription() {
        return this.description;
    }

    public static QueryDefinitionType fromValue(String value) {
        return Arrays.stream(QueryDefinitionType.values()).filter(v -> v.getValue().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown value %s", value)));
    }
}

