/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.elasticsearch.SearchResponse;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.elasticsearch.AbstractJsonQueryElasticsearch;
import org.apache.nifi.processors.elasticsearch.api.PaginatedJsonQueryParameters;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.StringUtils;

public abstract class AbstractPaginatedJsonQueryElasticsearch
extends AbstractJsonQueryElasticsearch<PaginatedJsonQueryParameters> {
    public static final AllowableValue FLOWFILE_PER_QUERY = new AllowableValue("splitUp-query", "Per Query", "Combine results from all query responses (one flowfile per entire paginated result set of hits). Note that aggregations cannot be paged, they are generated across the entire result set and returned as part of the first page. Results are output with one JSON object per line (allowing hits to be combined from multiple pages without loading all results into memory).");
    public static final PropertyDescriptor SEARCH_RESULTS_SPLIT = new PropertyDescriptor.Builder().fromPropertyDescriptor(AbstractJsonQueryElasticsearch.SEARCH_RESULTS_SPLIT).description("Output a flowfile containing all hits or one flowfile for each individual hit or one flowfile containing all hits from all paged responses.").allowableValues(new AllowableValue[]{FLOWFILE_PER_RESPONSE, FLOWFILE_PER_HIT, FLOWFILE_PER_QUERY}).build();
    public static final AllowableValue PAGINATION_SEARCH_AFTER = new AllowableValue("pagination-search_after", "Search After", "Use Elasticsearch \"search_after\" to page sorted results.");
    public static final AllowableValue PAGINATION_POINT_IN_TIME = new AllowableValue("pagination-pit", "Point in Time", "Use Elasticsearch (7.10+ with XPack) \"point in time\" to page sorted results.");
    public static final AllowableValue PAGINATION_SCROLL = new AllowableValue("pagination-scroll", "Scroll", "Use Elasticsearch \"scroll\" to page results.");
    public static final PropertyDescriptor PAGINATION_TYPE = new PropertyDescriptor.Builder().name("el-rest-pagination-type").displayName("Pagination Type").description("Pagination method to use. Not all types are available for all Elasticsearch versions, check the Elasticsearch docs to confirm which are applicable and recommended for your service.").allowableValues(new AllowableValue[]{PAGINATION_SCROLL, PAGINATION_SEARCH_AFTER, PAGINATION_POINT_IN_TIME}).defaultValue(PAGINATION_SCROLL.getValue()).required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor PAGINATION_KEEP_ALIVE = new PropertyDescriptor.Builder().name("el-rest-pagination-keep-alive").displayName("Pagination Keep Alive").description("Pagination \"keep_alive\" period. Period Elasticsearch will keep the scroll/pit cursor alive in between requests (this is not the time expected for all pages to be returned, but the maximum allowed time for requests between page retrievals).").required(true).defaultValue("10 mins").expressionLanguageSupported(ExpressionLanguageScope.NONE).addValidator(StandardValidators.createTimePeriodValidator((long)1L, (TimeUnit)TimeUnit.SECONDS, (long)24L, (TimeUnit)TimeUnit.HOURS)).build();
    static final List<PropertyDescriptor> paginatedPropertyDescriptors;
    private final ObjectWriter writer;
    String paginationType;

    public AbstractPaginatedJsonQueryElasticsearch() {
        this.writer = this.mapper.writer().withRootValueSeparator("\n");
    }

    @Override
    @OnScheduled
    public void onScheduled(ProcessContext context) {
        super.onScheduled(context);
        this.paginationType = context.getProperty(PAGINATION_TYPE).getValue();
    }

    @Override
    SearchResponse doQuery(PaginatedJsonQueryParameters paginatedJsonQueryParameters, List<FlowFile> hitsFlowFiles, ProcessSession session, ProcessContext context, FlowFile input, StopWatch stopWatch) throws IOException {
        SearchResponse response = null;
        do {
            boolean expiredQuery = this.isExpired(paginatedJsonQueryParameters, context, response);
            boolean newQuery = StringUtils.isBlank((String)paginatedJsonQueryParameters.getPageExpirationTimestamp()) || expiredQuery;
            String queryJson = this.updateQueryJson(newQuery, paginatedJsonQueryParameters);
            if (!newQuery && PAGINATION_SCROLL.getValue().equals(this.paginationType)) {
                response = ((ElasticSearchClientService)this.clientService.get()).scroll(queryJson);
            } else {
                Map requestParameters = this.getUrlQueryParameters(context, input);
                if (PAGINATION_SCROLL.getValue().equals(this.paginationType)) {
                    requestParameters.put("scroll", paginatedJsonQueryParameters.getKeepAlive());
                }
                response = ((ElasticSearchClientService)this.clientService.get()).search(queryJson, PAGINATION_POINT_IN_TIME.getValue().equals(this.paginationType) ? null : paginatedJsonQueryParameters.getIndex(), paginatedJsonQueryParameters.getType(), requestParameters);
                paginatedJsonQueryParameters.setPitId(response.getPitId());
                paginatedJsonQueryParameters.setSearchAfter(response.getSearchAfter());
            }
            paginatedJsonQueryParameters.setScrollId(response.getScrollId());
            if (newQuery && input != null) {
                session.getProvenanceReporter().send(input, ((ElasticSearchClientService)this.clientService.get()).getTransitUrl(paginatedJsonQueryParameters.getIndex(), paginatedJsonQueryParameters.getType()), stopWatch.getElapsed(TimeUnit.MILLISECONDS));
            }
            this.updatePageExpirationTimestamp(paginatedJsonQueryParameters, !response.getHits().isEmpty());
            hitsFlowFiles = this.handleResponse(response, newQuery, paginatedJsonQueryParameters, hitsFlowFiles, session, input, stopWatch);
        } while (!response.getHits().isEmpty() && (input != null || FLOWFILE_PER_QUERY.getValue().equals(this.splitUpHits)));
        if (response.getHits().isEmpty()) {
            this.getLogger().debug("No more results for paginated query, clearing Elasticsearch resources");
            this.clearElasticsearchState(context, response);
        }
        return response;
    }

    @Override
    PaginatedJsonQueryParameters buildJsonQueryParameters(FlowFile input, ProcessContext context, ProcessSession session) throws IOException {
        PaginatedJsonQueryParameters paginatedJsonQueryParameters = new PaginatedJsonQueryParameters();
        this.populateCommonJsonQueryParameters(paginatedJsonQueryParameters, input, context, session);
        paginatedJsonQueryParameters.setKeepAlive(context.getProperty(PAGINATION_KEEP_ALIVE).asTimePeriod(TimeUnit.SECONDS) + "s");
        return paginatedJsonQueryParameters;
    }

    abstract boolean isExpired(PaginatedJsonQueryParameters var1, ProcessContext var2, SearchResponse var3) throws IOException;

    abstract String getScrollId(ProcessContext var1, SearchResponse var2) throws IOException;

    abstract String getPitId(ProcessContext var1, SearchResponse var2) throws IOException;

    private void prepareNextPageQuery(ObjectNode queryJson, PaginatedJsonQueryParameters paginatedJsonQueryParameters) throws IOException {
        if (PAGINATION_SCROLL.getValue().equals(this.paginationType)) {
            queryJson.removeAll().put("scroll_id", paginatedJsonQueryParameters.getScrollId());
            if (StringUtils.isNotBlank((String)paginatedJsonQueryParameters.getKeepAlive())) {
                queryJson.put("scroll", paginatedJsonQueryParameters.getKeepAlive());
            }
        } else {
            queryJson.set("search_after", (JsonNode)this.mapper.readValue(paginatedJsonQueryParameters.getSearchAfter(), ArrayNode.class));
            if (queryJson.has("aggs")) {
                this.getLogger().debug("Removing \"aggs\" from non-initial paged query");
                queryJson.remove("aggs");
            }
        }
    }

    private String updateQueryJson(boolean newQuery, PaginatedJsonQueryParameters paginatedJsonQueryParameters) throws IOException {
        ObjectNode queryJson = (ObjectNode)this.mapper.readValue(paginatedJsonQueryParameters.getQuery(), ObjectNode.class);
        if (!newQuery) {
            this.prepareNextPageQuery(queryJson, paginatedJsonQueryParameters);
        } else if ((PAGINATION_POINT_IN_TIME.getValue().equals(this.paginationType) || PAGINATION_SEARCH_AFTER.getValue().equals(this.paginationType)) && !queryJson.has("sort")) {
            throw new IllegalArgumentException("Query using pit/search_after must contain a \"sort\" field");
        }
        if (PAGINATION_POINT_IN_TIME.getValue().equals(this.paginationType)) {
            String queryPitId = newQuery ? ((ElasticSearchClientService)this.clientService.get()).initialisePointInTime(paginatedJsonQueryParameters.getIndex(), paginatedJsonQueryParameters.getKeepAlive()) : paginatedJsonQueryParameters.getPitId();
            ObjectNode pit = JsonNodeFactory.instance.objectNode().put("id", queryPitId);
            if (StringUtils.isNotBlank((String)paginatedJsonQueryParameters.getKeepAlive())) {
                pit.put("keep_alive", paginatedJsonQueryParameters.getKeepAlive());
            }
            queryJson.set("pit", (JsonNode)pit);
        }
        return this.mapper.writeValueAsString((Object)queryJson);
    }

    private FlowFile writeCombinedHitFlowFile(int count, List<Map<String, Object>> hits, ProcessSession session, FlowFile hitFlowFile, Map<String, String> attributes, boolean append) {
        FlowFile ff;
        if (append) {
            ff = session.append(hitFlowFile, out -> out.write(10));
            ff = session.append(ff, out -> this.writer.writeValues(out).writeAll((Collection)hits));
        } else {
            ff = session.write(hitFlowFile, out -> this.writer.writeValues(out).writeAll((Collection)hits));
        }
        attributes.put("hit.count", Integer.toString(count));
        return session.putAllAttributes(ff, attributes);
    }

    private void combineHits(List<Map<String, Object>> hits, PaginatedJsonQueryParameters paginatedJsonQueryParameters, ProcessSession session, FlowFile parent, Map<String, String> attributes, List<FlowFile> hitsFlowFiles) {
        if (hits != null && !hits.isEmpty()) {
            boolean append = !hitsFlowFiles.isEmpty();
            FlowFile hitFlowFile = !hitsFlowFiles.isEmpty() ? hitsFlowFiles.remove(0) : this.createChildFlowFile(session, parent);
            hitsFlowFiles.add(this.writeCombinedHitFlowFile(paginatedJsonQueryParameters.getHitCount() + hits.size(), hits, session, hitFlowFile, attributes, append));
        } else if (this.getOutputNoHits()) {
            FlowFile hitFlowFile = this.createChildFlowFile(session, parent);
            hitsFlowFiles.add(this.writeHitFlowFile(0, "", session, hitFlowFile, attributes));
        }
    }

    @Override
    List<FlowFile> handleHits(List<Map<String, Object>> hits, boolean newQuery, PaginatedJsonQueryParameters paginatedJsonQueryParameters, ProcessSession session, FlowFile parent, Map<String, String> attributes, List<FlowFile> hitsFlowFiles, String transitUri, StopWatch stopWatch) throws IOException {
        paginatedJsonQueryParameters.incrementPageCount();
        attributes.put("page.number", Integer.toString(paginatedJsonQueryParameters.getPageCount()));
        if (FLOWFILE_PER_QUERY.getValue().equals(this.splitUpHits)) {
            this.combineHits(hits, paginatedJsonQueryParameters, session, parent, attributes, hitsFlowFiles);
            if (!hitsFlowFiles.isEmpty() && (hits == null || hits.isEmpty())) {
                session.transfer(hitsFlowFiles, REL_HITS);
                hitsFlowFiles.forEach(ff -> session.getProvenanceReporter().receive(ff, transitUri, stopWatch.getElapsed(TimeUnit.MILLISECONDS)));
                hitsFlowFiles.clear();
            }
        } else {
            super.handleHits(hits, newQuery, paginatedJsonQueryParameters, session, parent, attributes, hitsFlowFiles, transitUri, stopWatch);
        }
        return hitsFlowFiles;
    }

    private void updatePageExpirationTimestamp(PaginatedJsonQueryParameters paginatedJsonQueryParameters, boolean hasHits) {
        String keepAliveDuration = "PT" + (hasHits ? paginatedJsonQueryParameters.getKeepAlive() : "0s");
        paginatedJsonQueryParameters.setPageExpirationTimestamp(String.valueOf(Instant.now().plus(Duration.parse(keepAliveDuration)).toEpochMilli()));
    }

    void clearElasticsearchState(ProcessContext context, SearchResponse response) {
        try {
            String pitId;
            if (PAGINATION_SCROLL.getValue().equals(this.paginationType)) {
                String scrollId = this.getScrollId(context, response);
                if (StringUtils.isNotBlank((String)scrollId)) {
                    ((ElasticSearchClientService)this.clientService.get()).deleteScroll(scrollId);
                }
            } else if (PAGINATION_POINT_IN_TIME.getValue().equals(this.paginationType) && StringUtils.isNotBlank((String)(pitId = this.getPitId(context, response)))) {
                ((ElasticSearchClientService)this.clientService.get()).deletePointInTime(pitId);
            }
        }
        catch (Exception ex) {
            this.getLogger().warn("Error while cleaning up Elasticsearch pagination resources, ignoring", (Throwable)ex);
        }
    }

    static {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(QUERY_ATTRIBUTE);
        descriptors.add(INDEX);
        descriptors.add(TYPE);
        descriptors.add(CLIENT_SERVICE);
        descriptors.add(SEARCH_RESULTS_SPLIT);
        descriptors.add(AGGREGATION_RESULTS_SPLIT);
        descriptors.add(PAGINATION_TYPE);
        descriptors.add(PAGINATION_KEEP_ALIVE);
        descriptors.add(OUTPUT_NO_HITS);
        paginatedPropertyDescriptors = Collections.unmodifiableList(descriptors);
    }
}

