/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.elasticsearch;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.elasticsearch.AuthorizationScheme;
import org.apache.nifi.elasticsearch.DeleteOperationResponse;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.elasticsearch.ElasticsearchException;
import org.apache.nifi.elasticsearch.IndexOperationRequest;
import org.apache.nifi.elasticsearch.IndexOperationResponse;
import org.apache.nifi.elasticsearch.SearchResponse;
import org.apache.nifi.elasticsearch.UpdateOperationResponse;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxyConfigurationService;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.StringUtils;
import org.elasticsearch.client.NodeSelector;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.sniff.ElasticsearchNodesSniffer;
import org.elasticsearch.client.sniff.NodesSniffer;
import org.elasticsearch.client.sniff.SniffOnFailureListener;
import org.elasticsearch.client.sniff.Sniffer;

@Tags(value={"elasticsearch", "elasticsearch6", "elasticsearch7", "elasticsearch8", "client"})
@CapabilityDescription(value="A controller service for accessing an Elasticsearch client. Uses the Elasticsearch REST Client (7.13.4, the last version before client connections verifythe server is Elastic provided, this should allow for connections to compatible alternatives, e.g. AWS OpenSearch)")
@DynamicProperty(name="The name of a Request Header to add", value="The value of the Header", expressionLanguageScope=ExpressionLanguageScope.VARIABLE_REGISTRY, description="Adds the specified property name/value as a Request Header in the Elasticsearch requests.")
public class ElasticSearchClientServiceImpl
extends AbstractControllerService
implements ElasticSearchClientService {
    public static final String VERIFICATION_STEP_CONNECTION = "Elasticsearch Connection";
    public static final String VERIFICATION_STEP_CLIENT_SETUP = "Elasticsearch Rest Client Setup";
    public static final String VERIFICATION_STEP_WARNINGS = "Elasticsearch Warnings";
    public static final String VERIFICATION_STEP_SNIFFER = "Elasticsearch Sniffer";
    private ObjectMapper mapper;
    private static final List<PropertyDescriptor> properties;
    private RestClient client;
    private Sniffer sniffer;
    private String url;
    private Charset responseCharset;
    private ObjectWriter prettyPrintWriter;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.ATTRIBUTE_EXPRESSION_LANGUAGE_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dynamic(true).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(1);
        AuthorizationScheme authorizationScheme = AuthorizationScheme.valueOf((String)validationContext.getProperty(AUTHORIZATION_SCHEME).getValue());
        boolean usernameSet = validationContext.getProperty(USERNAME).isSet();
        boolean passwordSet = validationContext.getProperty(PASSWORD).isSet();
        boolean apiKeyIdSet = validationContext.getProperty(API_KEY_ID).isSet();
        boolean apiKeySet = validationContext.getProperty(API_KEY).isSet();
        SSLContextService sslService = (SSLContextService)validationContext.getProperty(PROP_SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        if (!(authorizationScheme != AuthorizationScheme.PKI || sslService != null && sslService.isKeyStoreConfigured())) {
            results.add(new ValidationResult.Builder().subject(PROP_SSL_CONTEXT_SERVICE.getName()).valid(false).explanation(String.format("if '%s' is '%s' then '%s' must be set and specify a Keystore for mutual TLS encryption.", AUTHORIZATION_SCHEME.getDisplayName(), authorizationScheme.getDisplayName(), PROP_SSL_CONTEXT_SERVICE.getDisplayName())).build());
        }
        if (usernameSet && !passwordSet) {
            this.addAuthorizationPropertiesValidationIssue(results, USERNAME, PASSWORD);
        } else if (passwordSet && !usernameSet) {
            this.addAuthorizationPropertiesValidationIssue(results, PASSWORD, USERNAME);
        }
        if (apiKeyIdSet && !apiKeySet) {
            this.addAuthorizationPropertiesValidationIssue(results, API_KEY_ID, API_KEY);
        } else if (apiKeySet && !apiKeyIdSet) {
            this.addAuthorizationPropertiesValidationIssue(results, API_KEY, API_KEY_ID);
        }
        boolean sniffClusterNodes = validationContext.getProperty(SNIFF_CLUSTER_NODES).asBoolean();
        boolean sniffOnFailure = validationContext.getProperty(SNIFF_ON_FAILURE).asBoolean();
        if (sniffOnFailure && !sniffClusterNodes) {
            results.add(new ValidationResult.Builder().subject(SNIFF_ON_FAILURE.getName()).valid(false).explanation(String.format("'%s' cannot be enabled if '%s' is disabled", SNIFF_ON_FAILURE.getDisplayName(), SNIFF_CLUSTER_NODES.getDisplayName())).build());
        }
        return results;
    }

    private void addAuthorizationPropertiesValidationIssue(List<ValidationResult> results, PropertyDescriptor presentProperty, PropertyDescriptor missingProperty) {
        results.add(new ValidationResult.Builder().subject(missingProperty.getName()).valid(false).explanation(String.format("if '%s' is then '%s' must be set.", presentProperty.getDisplayName(), missingProperty.getDisplayName())).build());
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException {
        try {
            this.client = this.setupClient(context);
            this.sniffer = this.setupSniffer(context, this.client);
            this.responseCharset = Charset.forName(context.getProperty(CHARSET).getValue());
            this.mapper = new ObjectMapper();
            if (ALWAYS_SUPPRESS.getValue().equals(context.getProperty(SUPPRESS_NULLS).getValue())) {
                this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                this.mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            }
            this.prettyPrintWriter = this.mapper.writerWithDefaultPrettyPrinter();
        }
        catch (Exception ex) {
            this.getLogger().error("Could not initialize ElasticSearch client.", (Throwable)ex);
            throw new InitializationException((Throwable)ex);
        }
    }

    @OnDisabled
    public void onDisabled() throws IOException {
        if (this.sniffer != null) {
            this.sniffer.close();
            this.sniffer = null;
        }
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        this.url = null;
    }

    /*
     * Exception decompiling
     */
    public List<ConfigVerificationResult> verify(ConfigurationContext context, ComponentLog verificationLogger, Map<String, String> variables) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void verifySniffer(ConfigurationContext context, RestClient verifyClient, ConfigVerificationResult.Builder snifferResult) {
        try (Sniffer verifySniffer = this.setupSniffer(context, verifyClient);){
            if (verifySniffer != null) {
                List originalNodes = verifyClient.getNodes();
                ElasticsearchNodesSniffer elasticsearchNodesSniffer = this.setupElasticsearchNodesSniffer(context, verifyClient);
                List nodes = elasticsearchNodesSniffer.sniff();
                AtomicInteger successfulInstances = new AtomicInteger(0);
                AtomicInteger warningInstances = new AtomicInteger(0);
                nodes.forEach(n -> {
                    try {
                        verifyClient.setNodes(Collections.singletonList(n));
                        List<String> warnings = this.getElasticsearchRoot(verifyClient);
                        successfulInstances.getAndIncrement();
                        if (!warnings.isEmpty()) {
                            warningInstances.getAndIncrement();
                        }
                    }
                    catch (Exception ex) {
                        this.getLogger().warn("Elasticsearch Node {} connection failed", new Object[]{n.getHost().toURI(), ex});
                    }
                });
                verifyClient.setNodes((Collection)originalNodes);
                if (successfulInstances.get() < nodes.size()) {
                    snifferResult.outcome(ConfigVerificationResult.Outcome.FAILED).explanation(String.format("Sniffing for Elasticsearch cluster nodes found %d nodes but %d could not be contacted (%d with warnings during connection tests)", nodes.size(), nodes.size() - successfulInstances.get(), warningInstances.get()));
                } else {
                    snifferResult.outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation(String.format("Sniffing for Elasticsearch cluster nodes found %d nodes (%d with warnings during connection tests)", nodes.size(), warningInstances.get()));
                }
            } else {
                snifferResult.outcome(ConfigVerificationResult.Outcome.SKIPPED).explanation("Sniff on Connection not enabled");
            }
        }
        catch (Exception ex) {
            this.getLogger().warn("Unable to sniff for Elasticsearch cluster nodes", (Throwable)ex);
            snifferResult.outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Sniffing for Elasticsearch cluster nodes failed");
        }
    }

    private List<String> getElasticsearchRoot(RestClient verifyClient) throws IOException {
        Response response = verifyClient.performRequest(new Request("GET", "/"));
        List<String> warnings = this.parseResponseWarningHeaders(response);
        this.parseResponse(response);
        return warnings;
    }

    private void verifyRootConnection(RestClient verifyClient, ConfigVerificationResult.Builder connectionResult, ConfigVerificationResult.Builder warningsResult) {
        try {
            List<String> warnings = this.getElasticsearchRoot(verifyClient);
            connectionResult.outcome(ConfigVerificationResult.Outcome.SUCCESSFUL);
            if (warnings.isEmpty()) {
                warningsResult.outcome(ConfigVerificationResult.Outcome.SUCCESSFUL);
            } else {
                warningsResult.outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Elasticsearch Warnings received during request (see logs for details)");
            }
        }
        catch (IOException | ElasticsearchException ex) {
            this.getLogger().warn("Unable to connect to Elasticsearch", ex);
            connectionResult.outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Unable to retrieve system summary from Elasticsearch root endpoint");
            warningsResult.outcome(ConfigVerificationResult.Outcome.SKIPPED).explanation("Connection to Elasticsearch failed");
        }
    }

    private RestClient setupClient(ConfigurationContext context) throws MalformedURLException, InitializationException {
        Integer connectTimeout = context.getProperty(CONNECT_TIMEOUT).asInteger();
        Integer socketTimeout = context.getProperty(SOCKET_TIMEOUT).asInteger();
        NodeSelector nodeSelector = NODE_SELECTOR_ANY.getValue().equals(context.getProperty(NODE_SELECTOR).getValue()) ? NodeSelector.ANY : NodeSelector.SKIP_DEDICATED_MASTERS;
        String pathPrefix = context.getProperty(PATH_PREFIX).getValue();
        boolean compress = context.getProperty(COMPRESSION).asBoolean();
        boolean sendMetaHeader = context.getProperty(SEND_META_HEADER).asBoolean();
        boolean strictDeprecation = context.getProperty(STRICT_DEPRECATION).asBoolean();
        boolean sniffOnFailure = context.getProperty(SNIFF_ON_FAILURE).asBoolean();
        RestClientBuilder builder = RestClient.builder((HttpHost[])this.getHttpHosts(context));
        this.addAuthAndProxy(context, builder).setRequestConfigCallback(requestConfigBuilder -> {
            requestConfigBuilder.setConnectTimeout(connectTimeout.intValue());
            requestConfigBuilder.setSocketTimeout(socketTimeout.intValue());
            return requestConfigBuilder;
        }).setCompressionEnabled(compress).setMetaHeaderEnabled(sendMetaHeader).setStrictDeprecationMode(strictDeprecation).setNodeSelector(nodeSelector);
        if (sniffOnFailure && this.sniffer != null) {
            SniffOnFailureListener sniffOnFailureListener = new SniffOnFailureListener();
            sniffOnFailureListener.setSniffer(this.sniffer);
            builder.setFailureListener((RestClient.FailureListener)sniffOnFailureListener);
        }
        if (StringUtils.isNotBlank((String)pathPrefix)) {
            builder.setPathPrefix(pathPrefix);
        }
        return builder.build();
    }

    private HttpHost[] getHttpHosts(ConfigurationContext context) throws MalformedURLException {
        String hosts = context.getProperty(HTTP_HOSTS).evaluateAttributeExpressions().getValue();
        List hostsSplit = Arrays.stream(hosts.split(",\\s*")).map(String::trim).collect(Collectors.toList());
        this.url = (String)hostsSplit.get(0);
        ArrayList<HttpHost> hh = new ArrayList<HttpHost>(hostsSplit.size());
        for (String host : hostsSplit) {
            URL u = URI.create(host).toURL();
            hh.add(new HttpHost(u.getHost(), u.getPort(), u.getProtocol()));
        }
        return hh.toArray(new HttpHost[0]);
    }

    private RestClientBuilder addAuthAndProxy(ConfigurationContext context, RestClientBuilder builder) throws InitializationException {
        AuthorizationScheme authorizationScheme = AuthorizationScheme.valueOf((String)context.getProperty(AUTHORIZATION_SCHEME).getValue());
        String username = context.getProperty(USERNAME).evaluateAttributeExpressions().getValue();
        String password = context.getProperty(PASSWORD).evaluateAttributeExpressions().getValue();
        String apiKeyId = context.getProperty(API_KEY_ID).getValue();
        String apiKey = context.getProperty(API_KEY).getValue();
        SSLContext sslContext = this.getSSLContext(context);
        ProxyConfigurationService proxyConfigurationService = (ProxyConfigurationService)context.getProperty(PROXY_CONFIGURATION_SERVICE).asControllerService(ProxyConfigurationService.class);
        return builder.setHttpClientConfigCallback(httpClientBuilder -> {
            ProxyConfiguration proxyConfiguration;
            if (sslContext != null) {
                httpClientBuilder.setSSLContext(sslContext);
            }
            CredentialsProvider credentialsProvider = null;
            if (AuthorizationScheme.BASIC == authorizationScheme && username != null && password != null) {
                credentialsProvider = this.addBasicAuthCredentials(null, AuthScope.ANY, username, password);
            }
            List<Header> defaultHeaders = this.getDefaultHeadersFromDynamicProperties(context);
            if (AuthorizationScheme.API_KEY == authorizationScheme && apiKeyId != null && apiKey != null) {
                defaultHeaders.add((Header)this.createApiKeyAuthorizationHeader(apiKeyId, apiKey));
            }
            if (!defaultHeaders.isEmpty()) {
                builder.setDefaultHeaders(defaultHeaders.toArray(new Header[0]));
            }
            if (proxyConfigurationService != null && Proxy.Type.HTTP == (proxyConfiguration = proxyConfigurationService.getConfiguration()).getProxyType()) {
                HttpHost proxy = new HttpHost(proxyConfiguration.getProxyServerHost(), proxyConfiguration.getProxyServerPort().intValue(), "http");
                httpClientBuilder.setProxy(proxy);
                credentialsProvider = this.addBasicAuthCredentials(credentialsProvider, new AuthScope(proxy), proxyConfiguration.getProxyUserName(), proxyConfiguration.getProxyUserPassword());
            }
            if (credentialsProvider != null) {
                httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            }
            return httpClientBuilder;
        });
    }

    private SSLContext getSSLContext(ConfigurationContext context) throws InitializationException {
        SSLContextService sslService = (SSLContextService)context.getProperty(PROP_SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        try {
            return sslService != null && (sslService.isKeyStoreConfigured() || sslService.isTrustStoreConfigured()) ? sslService.createContext() : null;
        }
        catch (Exception e) {
            this.getLogger().error("Error building up SSL Context from the supplied configuration.", (Throwable)e);
            throw new InitializationException((Throwable)e);
        }
    }

    private CredentialsProvider addBasicAuthCredentials(CredentialsProvider credentialsProvider, AuthScope authScope, String username, String password) {
        CredentialsProvider cp;
        Object object = cp = credentialsProvider != null ? credentialsProvider : new BasicCredentialsProvider();
        if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password)) {
            cp.setCredentials(authScope == null ? AuthScope.ANY : authScope, (Credentials)new UsernamePasswordCredentials(username, password));
        }
        return cp;
    }

    private List<Header> getDefaultHeadersFromDynamicProperties(ConfigurationContext context) {
        return context.getProperties().entrySet().stream().filter(e -> ((PropertyDescriptor)e.getKey()).isDynamic() && StringUtils.isNotBlank((String)((String)e.getValue())) && StringUtils.isNotBlank((String)context.getProperty((PropertyDescriptor)e.getKey()).evaluateAttributeExpressions().getValue())).map(e -> new BasicHeader(((PropertyDescriptor)e.getKey()).getName(), context.getProperty((PropertyDescriptor)e.getKey()).evaluateAttributeExpressions().getValue())).collect(Collectors.toList());
    }

    private BasicHeader createApiKeyAuthorizationHeader(String apiKeyId, String apiKey) {
        String apiKeyCredentials = String.format("%s:%s", apiKeyId, apiKey);
        String apiKeyAuth = Base64.getEncoder().encodeToString(apiKeyCredentials.getBytes(StandardCharsets.UTF_8));
        return new BasicHeader("Authorization", "ApiKey " + apiKeyAuth);
    }

    private Sniffer setupSniffer(ConfigurationContext context, RestClient restClient) {
        boolean sniffClusterNodes = context.getProperty(SNIFF_CLUSTER_NODES).asBoolean();
        int snifferIntervalMillis = context.getProperty(SNIFFER_INTERVAL).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        int snifferFailureDelayMillis = context.getProperty(SNIFFER_FAILURE_DELAY).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        if (sniffClusterNodes) {
            return Sniffer.builder((RestClient)restClient).setSniffIntervalMillis(snifferIntervalMillis).setSniffAfterFailureDelayMillis(snifferFailureDelayMillis).setNodesSniffer((NodesSniffer)this.setupElasticsearchNodesSniffer(context, restClient)).build();
        }
        return null;
    }

    private ElasticsearchNodesSniffer setupElasticsearchNodesSniffer(ConfigurationContext context, RestClient restClient) {
        Long snifferRequestTimeoutMillis = context.getProperty(SNIFFER_REQUEST_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS);
        ElasticsearchNodesSniffer.Scheme scheme = this.url.toLowerCase(Locale.getDefault()).startsWith("https://") ? ElasticsearchNodesSniffer.Scheme.HTTPS : ElasticsearchNodesSniffer.Scheme.HTTP;
        return new ElasticsearchNodesSniffer(restClient, snifferRequestTimeoutMillis.longValue(), scheme);
    }

    private void appendIndex(StringBuilder sb, String index) {
        if (StringUtils.isNotBlank((String)index) && !"/".equals(index)) {
            if (!index.startsWith("/")) {
                sb.append("/");
            }
            sb.append(index);
        }
    }

    private Response runQuery(String endpoint, String query, String index, String type, Map<String, String> requestParameters) {
        StringBuilder sb = new StringBuilder();
        this.appendIndex(sb, index);
        if (StringUtils.isNotBlank((String)type)) {
            sb.append("/").append(type);
        }
        sb.append("/").append(endpoint);
        try {
            NStringEntity queryEntity = new NStringEntity(query, ContentType.APPLICATION_JSON);
            return this.performRequest("POST", sb.toString(), requestParameters, (HttpEntity)queryEntity);
        }
        catch (Exception e) {
            throw new ElasticsearchException(e);
        }
    }

    private Map<String, Object> parseResponse(Response response) {
        int code = response.getStatusLine().getStatusCode();
        try {
            if (code >= 200 && code < 300) {
                InputStream inputStream = response.getEntity().getContent();
                byte[] result = IOUtils.toByteArray((InputStream)inputStream);
                inputStream.close();
                return (Map)this.mapper.readValue(new String(result, this.responseCharset), Map.class);
            }
            String errorMessage = String.format("ElasticSearch reported an error while trying to run the query: %s", response.getStatusLine().getReasonPhrase());
            throw new IOException(errorMessage);
        }
        catch (Exception ex) {
            throw new ElasticsearchException(ex);
        }
    }

    private List<String> parseResponseWarningHeaders(Response response) {
        List<String> warnings = Arrays.stream(response.getHeaders()).filter(h -> "Warning".equalsIgnoreCase(h.getName())).map(NameValuePair::getValue).collect(Collectors.toList());
        warnings.forEach(w -> this.getLogger().warn("Elasticsearch Warning: {}", new Object[]{w}));
        return warnings;
    }

    public IndexOperationResponse add(IndexOperationRequest operation, Map<String, String> requestParameters) {
        return this.bulk(Collections.singletonList(operation), requestParameters);
    }

    private String flatten(String str) {
        return str.replaceAll("[\\n\\r]", "\\\\n");
    }

    private String buildBulkHeader(IndexOperationRequest request) throws JsonProcessingException {
        String operation = request.getOperation().equals((Object)IndexOperationRequest.Operation.Upsert) ? "update" : request.getOperation().getValue();
        return this.buildBulkHeader(operation, request.getIndex(), request.getType(), request.getId(), request.getDynamicTemplates(), request.getHeaderFields());
    }

    private String buildBulkHeader(String operation, String index, String type, String id, Map<String, Object> dynamicTemplates, Map<String, String> headerFields) throws JsonProcessingException {
        HashMap<String, Object> operationBody = new HashMap<String, Object>();
        operationBody.put("_index", index);
        if (StringUtils.isNotBlank((String)id)) {
            operationBody.put("_id", id);
        }
        if (StringUtils.isNotBlank((String)type)) {
            operationBody.put("_type", type);
        }
        if (dynamicTemplates != null && !dynamicTemplates.isEmpty()) {
            operationBody.put("dynamic_templates", dynamicTemplates);
        }
        if (headerFields != null && !headerFields.isEmpty()) {
            headerFields.entrySet().stream().filter(e -> StringUtils.isNotBlank((String)((String)e.getValue()))).forEach(e -> operationBody.putIfAbsent((String)e.getKey(), e.getValue()));
        }
        return this.flatten(this.mapper.writeValueAsString(Collections.singletonMap(operation, operationBody)));
    }

    protected void buildRequest(IndexOperationRequest request, StringBuilder builder) throws JsonProcessingException {
        String header = this.buildBulkHeader(request);
        builder.append(header).append("\n");
        switch (request.getOperation()) {
            case Index: 
            case Create: {
                String indexDocument = this.mapper.writeValueAsString((Object)request.getFields());
                builder.append(indexDocument).append("\n");
                break;
            }
            case Update: 
            case Upsert: {
                HashMap<String, Object> updateBody = new HashMap<String, Object>(2, 1.0f);
                if (request.getScript() != null && !request.getScript().isEmpty()) {
                    updateBody.put("script", request.getScript());
                    if (request.getOperation().equals((Object)IndexOperationRequest.Operation.Upsert)) {
                        updateBody.put("scripted_upsert", request.isScriptedUpsert());
                        updateBody.put("upsert", request.getFields());
                    }
                } else {
                    updateBody.put("doc", request.getFields());
                    if (request.getOperation().equals((Object)IndexOperationRequest.Operation.Upsert)) {
                        updateBody.put("doc_as_upsert", true);
                    }
                }
                String update = this.flatten(this.mapper.writeValueAsString(updateBody)).trim();
                builder.append(update).append("\n");
                break;
            }
            case Delete: {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unhandled Index Operation type: %s", request.getOperation().name()));
            }
        }
    }

    public IndexOperationResponse bulk(List<IndexOperationRequest> operations, Map<String, String> requestParameters) {
        try {
            StringBuilder payload = new StringBuilder();
            for (IndexOperationRequest or : operations) {
                this.buildRequest(or, payload);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(payload.toString());
            }
            NStringEntity entity = new NStringEntity(payload.toString(), ContentType.APPLICATION_JSON);
            StopWatch watch = new StopWatch();
            watch.start();
            Response response = this.performRequest("POST", "/_bulk", requestParameters, (HttpEntity)entity);
            watch.stop();
            String rawResponse = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            this.parseResponseWarningHeaders(response);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(String.format("Response was: %s", rawResponse));
            }
            return IndexOperationResponse.fromJsonResponse((String)rawResponse);
        }
        catch (Exception ex) {
            throw new ElasticsearchException(ex);
        }
    }

    public Long count(String query, String index, String type, Map<String, String> requestParameters) {
        Response response = this.runQuery("_count", query, index, type, requestParameters);
        Map<String, Object> parsed = this.parseResponse(response);
        return ((Integer)parsed.get("count")).longValue();
    }

    public DeleteOperationResponse deleteById(String index, String type, String id, Map<String, String> requestParameters) {
        return this.deleteById(index, type, Collections.singletonList(id), requestParameters);
    }

    public DeleteOperationResponse deleteById(String index, String type, List<String> ids, Map<String, String> requestParameters) {
        try {
            StringBuilder sb = new StringBuilder();
            for (String id : ids) {
                String header = this.buildBulkHeader("delete", index, type, id, null, null);
                sb.append(header).append("\n");
            }
            NStringEntity entity = new NStringEntity(sb.toString(), ContentType.APPLICATION_JSON);
            StopWatch watch = new StopWatch();
            watch.start();
            Response response = this.performRequest("POST", "/_bulk", requestParameters, (HttpEntity)entity);
            watch.stop();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(String.format("Response for bulk delete: %s", IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8)));
            }
            this.parseResponseWarningHeaders(response);
            return new DeleteOperationResponse(watch.getDuration(TimeUnit.MILLISECONDS));
        }
        catch (Exception ex) {
            throw new ElasticsearchException(ex);
        }
    }

    public DeleteOperationResponse deleteByQuery(String query, String index, String type, Map<String, String> requestParameters) {
        StopWatch watch = new StopWatch();
        watch.start();
        Response response = this.runQuery("_delete_by_query", query, index, type, requestParameters);
        watch.stop();
        this.parseResponse(response);
        this.parseResponseWarningHeaders(response);
        return new DeleteOperationResponse(watch.getDuration(TimeUnit.MILLISECONDS));
    }

    public UpdateOperationResponse updateByQuery(String query, String index, String type, Map<String, String> requestParameters) {
        long start = System.currentTimeMillis();
        Response response = this.runQuery("_update_by_query", query, index, type, requestParameters);
        long end = System.currentTimeMillis();
        this.parseResponse(response);
        return new UpdateOperationResponse(end - start);
    }

    public void refresh(String index, Map<String, String> requestParameters) {
        try {
            StringBuilder endpoint = new StringBuilder();
            this.appendIndex(endpoint, index);
            endpoint.append("/_refresh");
            Response response = this.performRequest("POST", endpoint.toString(), requestParameters, null);
            this.parseResponseWarningHeaders(response);
        }
        catch (Exception ex) {
            throw new ElasticsearchException(ex);
        }
    }

    public boolean exists(String index, Map<String, String> requestParameters) {
        try {
            StringBuilder endpoint = new StringBuilder();
            this.appendIndex(endpoint, index);
            Response response = this.performRequest("HEAD", endpoint.toString(), requestParameters, null);
            this.parseResponseWarningHeaders(response);
            if (response.getStatusLine().getStatusCode() == 200) {
                return true;
            }
            if (response.getStatusLine().getStatusCode() == 404) {
                return false;
            }
            throw new ProcessException(String.format("Error checking for index existence: %d; %s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
        }
        catch (Exception ex) {
            throw new ElasticsearchException(ex);
        }
    }

    public boolean documentExists(String index, String type, String id, Map<String, String> requestParameters) {
        boolean exists = true;
        try {
            HashMap<String, String> existsParameters = requestParameters != null ? new HashMap<String, String>(requestParameters) : new HashMap();
            existsParameters.putIfAbsent("_source", "false");
            this.get(index, type, id, existsParameters);
        }
        catch (ElasticsearchException ee) {
            if (ee.isNotFound()) {
                exists = false;
            }
            throw ee;
        }
        return exists;
    }

    public Map<String, Object> get(String index, String type, String id, Map<String, String> requestParameters) {
        try {
            StringBuilder endpoint = new StringBuilder();
            this.appendIndex(endpoint, index);
            if (StringUtils.isNotBlank((String)type)) {
                endpoint.append("/").append(type);
            } else {
                endpoint.append("/_doc");
            }
            endpoint.append("/").append(id);
            Response response = this.performRequest("GET", endpoint.toString(), requestParameters, null);
            String body = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            this.parseResponseWarningHeaders(response);
            return ((Map)this.mapper.readValue(body, Map.class)).getOrDefault("_source", Collections.emptyMap());
        }
        catch (Exception ex) {
            throw new ElasticsearchException(ex);
        }
    }

    private int handleSearchCount(Object raw) {
        if (raw instanceof Number) {
            return Integer.parseInt(raw.toString());
        }
        if (raw instanceof Map) {
            return (Integer)((Map)raw).get("value");
        }
        throw new ProcessException("Unknown type for hit count.");
    }

    public SearchResponse search(String query, String index, String type, Map<String, String> requestParameters) {
        try {
            Response response = this.runQuery("_search", query, index, type, requestParameters);
            return this.buildSearchResponse(response);
        }
        catch (Exception ex) {
            throw new ElasticsearchException(ex);
        }
    }

    public SearchResponse scroll(String scroll) {
        try {
            NStringEntity scrollEntity = new NStringEntity(scroll, ContentType.APPLICATION_JSON);
            Response response = this.performRequest("POST", "/_search/scroll", Collections.emptyMap(), (HttpEntity)scrollEntity);
            return this.buildSearchResponse(response);
        }
        catch (Exception ex) {
            throw new ElasticsearchException(ex);
        }
    }

    public String initialisePointInTime(String index, final String keepAlive) {
        try {
            HashMap<String, String> params = new HashMap<String, String>(){
                {
                    if (StringUtils.isNotBlank((String)keepAlive)) {
                        this.put("keep_alive", keepAlive);
                    }
                }
            };
            StringBuilder endpoint = new StringBuilder();
            this.appendIndex(endpoint, index);
            endpoint.append("/_pit");
            Response response = this.performRequest("POST", endpoint.toString(), (Map<String, String>)params, null);
            String body = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            this.parseResponseWarningHeaders(response);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(String.format("Response for initialising Point in Time: %s", body));
            }
            return (String)((Map)this.mapper.readValue(body, Map.class)).get("id");
        }
        catch (Exception ex) {
            throw new ElasticsearchException(ex);
        }
    }

    public DeleteOperationResponse deletePointInTime(String pitId) {
        try {
            NStringEntity pitEntity = new NStringEntity(String.format("{\"id\": \"%s\"}", pitId), ContentType.APPLICATION_JSON);
            StopWatch watch = new StopWatch(true);
            Response response = this.performRequest("DELETE", "/_pit", Collections.emptyMap(), (HttpEntity)pitEntity);
            watch.stop();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(String.format("Response for deleting Point in Time: %s", IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8)));
            }
            this.parseResponseWarningHeaders(response);
            return new DeleteOperationResponse(watch.getDuration(TimeUnit.MILLISECONDS));
        }
        catch (ResponseException re) {
            if (404 == re.getResponse().getStatusLine().getStatusCode()) {
                this.getLogger().debug("Point in Time {} not found in Elasticsearch for deletion, ignoring", new Object[]{pitId});
                return new DeleteOperationResponse(0L);
            }
            throw new ElasticsearchException((Exception)((Object)re));
        }
        catch (Exception ex) {
            throw new ElasticsearchException(ex);
        }
    }

    public DeleteOperationResponse deleteScroll(String scrollId) {
        try {
            NStringEntity scrollBody = new NStringEntity(String.format("{\"scroll_id\": \"%s\"}", scrollId), ContentType.APPLICATION_JSON);
            StopWatch watch = new StopWatch(true);
            Response response = this.performRequest("DELETE", "/_search/scroll", Collections.emptyMap(), (HttpEntity)scrollBody);
            watch.stop();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(String.format("Response for deleting Scroll: %s", IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8)));
            }
            this.parseResponseWarningHeaders(response);
            return new DeleteOperationResponse(watch.getDuration(TimeUnit.MILLISECONDS));
        }
        catch (ResponseException re) {
            if (404 == re.getResponse().getStatusLine().getStatusCode()) {
                this.getLogger().debug("Scroll Id {} not found in Elasticsearch for deletion, ignoring", new Object[]{scrollId});
                return new DeleteOperationResponse(0L);
            }
            throw new ElasticsearchException((Exception)((Object)re));
        }
        catch (Exception ex) {
            throw new ElasticsearchException(ex);
        }
    }

    private SearchResponse buildSearchResponse(Response response) throws JsonProcessingException {
        Map<String, Object> parsed = this.parseResponse(response);
        List<String> warnings = this.parseResponseWarningHeaders(response);
        int took = (Integer)parsed.get("took");
        boolean timedOut = (Boolean)parsed.get("timed_out");
        String pitId = parsed.get("pit_id") != null ? (String)parsed.get("pit_id") : null;
        String scrollId = parsed.get("_scroll_id") != null ? (String)parsed.get("_scroll_id") : null;
        Map aggregations = parsed.get("aggregations") != null ? (Map)parsed.get("aggregations") : new HashMap();
        Map hitsParent = (Map)parsed.get("hits");
        int count = this.handleSearchCount(hitsParent.get("total"));
        List hits = (List)hitsParent.get("hits");
        String searchAfter = this.getSearchAfter(hits);
        SearchResponse esr = new SearchResponse(hits, aggregations, pitId, scrollId, searchAfter, count, took, timedOut, warnings);
        if (this.getLogger().isDebugEnabled()) {
            String searchSummary = "******************" + String.format(Locale.getDefault(), "Took: %d", took) + String.format(Locale.getDefault(), "Timed out: %s", timedOut) + String.format(Locale.getDefault(), "Aggregation count: %d", aggregations.size()) + String.format(Locale.getDefault(), "Hit count: %d", hits.size()) + String.format(Locale.getDefault(), "PIT Id: %s", pitId) + String.format(Locale.getDefault(), "Scroll Id: %s", scrollId) + String.format(Locale.getDefault(), "Search After: %s", searchAfter) + String.format(Locale.getDefault(), "Total found: %d", count) + String.format(Locale.getDefault(), "Warnings: %s", warnings) + "******************";
            this.getLogger().debug(searchSummary);
        }
        return esr;
    }

    private String getSearchAfter(List<Map<String, Object>> hits) throws JsonProcessingException {
        Object lastHitSort;
        String searchAfter = null;
        if (!hits.isEmpty() && (lastHitSort = hits.get(hits.size() - 1).get("sort")) != null && !"null".equalsIgnoreCase(lastHitSort.toString())) {
            searchAfter = this.mapper.writeValueAsString(lastHitSort);
        }
        return searchAfter;
    }

    public String getTransitUrl(String index, String type) {
        StringBuilder transitUrl = new StringBuilder();
        transitUrl.append(this.url);
        this.appendIndex(transitUrl, index);
        if (StringUtils.isNotBlank((String)type)) {
            transitUrl.append("/").append(type);
        }
        return transitUrl.toString();
    }

    private Response performRequest(String method, String endpoint, Map<String, String> parameters, HttpEntity entity) throws IOException {
        Request request = new Request(method, endpoint);
        if (parameters != null && !parameters.isEmpty()) {
            request.addParameters(parameters);
        }
        if (entity != null) {
            request.setEntity(entity);
            if (this.getLogger().isDebugEnabled()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                entity.writeTo((OutputStream)out);
                out.close();
                String builder = "Dumping Elasticsearch REST request...\nHTTP Method: " + method + "\nEndpoint: " + endpoint + "\nParameters: " + this.prettyPrintWriter.writeValueAsString(parameters) + "\nRequest body: " + out + "\n";
                this.getLogger().debug(builder);
            }
        }
        return this.client.performRequest(request);
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(HTTP_HOSTS);
        props.add(PATH_PREFIX);
        props.add(AUTHORIZATION_SCHEME);
        props.add(USERNAME);
        props.add(PASSWORD);
        props.add(API_KEY_ID);
        props.add(API_KEY);
        props.add(PROP_SSL_CONTEXT_SERVICE);
        props.add(PROXY_CONFIGURATION_SERVICE);
        props.add(CONNECT_TIMEOUT);
        props.add(SOCKET_TIMEOUT);
        props.add(RETRY_TIMEOUT);
        props.add(CHARSET);
        props.add(SUPPRESS_NULLS);
        props.add(COMPRESSION);
        props.add(SEND_META_HEADER);
        props.add(STRICT_DEPRECATION);
        props.add(NODE_SELECTOR);
        props.add(SNIFF_CLUSTER_NODES);
        props.add(SNIFFER_INTERVAL);
        props.add(SNIFFER_REQUEST_TIMEOUT);
        props.add(SNIFF_ON_FAILURE);
        props.add(SNIFFER_FAILURE_DELAY);
        properties = Collections.unmodifiableList(props);
    }
}

