/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kafka.pubsub;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.kafka.pubsub.PublishKafka_3;

@Tags(value={"EEP", "MapR", "Kafka", "Put", "Send", "Message", "PubSub", "3.0"})
@CapabilityDescription(value="Sends the contents of a FlowFile as a message to EEP Kafka using the Kafka 3.0 Producer API.The messages to send may be individual FlowFiles or may be delimited, using a user-specified delimiter, such as a new-line. The complementary NiFi processor for fetching messages is ConsumeKafka_EEP_3.")
public class PublishKafka_EEP_3
extends PublishKafka_3 {
    static final PropertyDescriptor USE_TRANSACTIONS_EEP = new PropertyDescriptor.Builder().name("use-transactions").displayName("Use Transactions").description("Specifies whether or not NiFi should provide Transactional guarantees when communicating with Kafka. If there is a problem sending data to Kafka, and this property is set to false, then the messages that have already been sent to Kafka will continue on and be delivered to consumers. If this is set to true, then the Kafka transaction will be rolled back so that those messages are not available to consumers. Setting this to true requires that the <Delivery Guarantee> property be set to \"Guarantee Replicated Delivery.\"").expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    private static final List<PropertyDescriptor> PROPERTIES_EEP;
    private static final Set<Relationship> RELATIONSHIPS_EEP;

    @Override
    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS_EEP;
    }

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES_EEP;
    }

    static {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(BOOTSTRAP_SERVERS);
        properties.add(TOPIC);
        properties.add(USE_TRANSACTIONS_EEP);
        properties.add(TRANSACTIONAL_ID_PREFIX);
        properties.add(MESSAGE_DEMARCATOR);
        properties.add(FAILURE_STRATEGY);
        properties.add(DELIVERY_GUARANTEE);
        properties.add(ATTRIBUTE_NAME_REGEX);
        properties.add(MESSAGE_HEADER_ENCODING);
        properties.add(SECURITY_PROTOCOL);
        properties.add(SASL_MECHANISM);
        properties.add(KERBEROS_CREDENTIALS_SERVICE);
        properties.add(SELF_CONTAINED_KERBEROS_USER_SERVICE);
        properties.add(KERBEROS_SERVICE_NAME);
        properties.add(KERBEROS_PRINCIPAL);
        properties.add(KERBEROS_KEYTAB);
        properties.add(SASL_USERNAME);
        properties.add(SASL_PASSWORD);
        properties.add(TOKEN_AUTHENTICATION);
        properties.add(SSL_CONTEXT_SERVICE);
        properties.add(KEY);
        properties.add(KEY_ATTRIBUTE_ENCODING);
        properties.add(MAX_REQUEST_SIZE);
        properties.add(ACK_WAIT_TIME);
        properties.add(METADATA_WAIT_TIME);
        properties.add(PARTITION_CLASS);
        properties.add(PARTITION);
        properties.add(COMPRESSION_CODEC);
        PROPERTIES_EEP = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        RELATIONSHIPS_EEP = Collections.unmodifiableSet(relationships);
    }
}

