/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kafka.pubsub;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.authenticator.AbstractLogin;
import org.apache.kafka.common.security.kerberos.KerberosLogin;
import org.apache.kafka.common.utils.KafkaThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomKerberosLogin
extends AbstractLogin {
    private static final Logger log = LoggerFactory.getLogger(CustomKerberosLogin.class);
    private Thread refreshThread;
    private boolean isKrbTicket;
    private String principal;
    private double ticketRenewWindowFactor;
    private long minTimeBeforeRelogin;
    private volatile Subject subject;
    private LoginContext loginContext;
    private String serviceName;

    public void configure(Map<String, ?> configs, String contextName, Configuration configuration, AuthenticateCallbackHandler callbackHandler) {
        super.configure(configs, contextName, configuration, callbackHandler);
        this.ticketRenewWindowFactor = (Double)configs.get("sasl.kerberos.ticket.renew.window.factor");
        this.minTimeBeforeRelogin = (Long)configs.get("sasl.kerberos.min.time.before.relogin");
        this.serviceName = CustomKerberosLogin.getServiceName(configs, contextName, configuration);
    }

    public LoginContext login() throws LoginException {
        AppConfigurationEntry entry;
        this.loginContext = super.login();
        this.subject = this.loginContext.getSubject();
        this.isKrbTicket = !this.subject.getPrivateCredentials(KerberosTicket.class).isEmpty();
        AppConfigurationEntry[] entries = this.configuration().getAppConfigurationEntry(this.contextName());
        this.principal = entries.length == 0 ? null : ((entry = entries[0]).getOptions().get("principal") != null ? (String)entry.getOptions().get("principal") : null);
        if (!this.isKrbTicket) {
            log.debug("[Principal={}]: It is not a Kerberos ticket", (Object)this.principal);
            this.refreshThread = null;
            return this.loginContext;
        }
        log.debug("[Principal={}]: It is a Kerberos ticket", (Object)this.principal);
        this.refreshThread = KafkaThread.daemon((String)String.format("kafka-kerberos-refresh-thread-%s", this.principal), () -> {
            log.info("[Principal={}]: TGT refresh thread started, minTimeBeforeRelogin = {}", (Object)this.principal, (Object)this.minTimeBeforeRelogin);
            while (true) {
                try {
                    Thread.sleep(this.minTimeBeforeRelogin);
                }
                catch (InterruptedException ie) {
                    log.warn("[Principal={}]: TGT renewal thread has been interrupted and will exit.", (Object)this.principal);
                    return;
                }
                try {
                    this.checkTGTAndReLogin();
                    continue;
                }
                catch (Throwable t) {
                    log.error("[Principal={}]: Error from TGT refresh thread", (Object)this.principal, (Object)t);
                    continue;
                }
                break;
            }
        });
        this.refreshThread.start();
        return this.loginContext;
    }

    public void close() {
        if (this.refreshThread != null && this.refreshThread.isAlive()) {
            this.refreshThread.interrupt();
            try {
                this.refreshThread.join();
            }
            catch (InterruptedException e) {
                log.warn("[Principal={}]: Error while waiting for Login thread to shutdown.", (Object)this.principal, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public Subject subject() {
        return this.subject;
    }

    public String serviceName() {
        return this.serviceName;
    }

    private synchronized void checkTGTAndReLogin() throws LoginException {
        KerberosTicket tgt = this.getTGT();
        if (tgt == null) {
            log.info("[Principal={}]: TGT was not found, performing login", (Object)this.principal);
            this.reLogin();
            return;
        }
        if (System.currentTimeMillis() < this.getRefreshTime(tgt)) {
            log.debug("[Principal={}]: TGT was found, but has not reached expiration window", (Object)this.principal);
            return;
        }
        try {
            tgt.refresh();
            log.info("[Principal={}]: TGT refreshed", (Object)this.principal);
            this.getRefreshTime(tgt);
        }
        catch (RefreshFailedException rfe) {
            log.warn("[Principal={}]: TGT refresh failed, will attempt relogin", (Object)this.principal);
            log.debug("", (Throwable)rfe);
            this.reLogin();
        }
    }

    private static String getServiceName(Map<String, ?> configs, String contextName, Configuration configuration) {
        List<AppConfigurationEntry> configEntries = Arrays.asList(configuration.getAppConfigurationEntry(contextName));
        String jaasServiceName = JaasContext.configEntryOption(configEntries, (String)"serviceName", null);
        String configServiceName = (String)configs.get("sasl.kerberos.service.name");
        if (jaasServiceName != null && configServiceName != null && !jaasServiceName.equals(configServiceName)) {
            String message = String.format("Conflicting serviceName values found in JAAS and Kafka configs value in JAAS file %s, value in Kafka config %s", jaasServiceName, configServiceName);
            throw new IllegalArgumentException(message);
        }
        if (jaasServiceName != null) {
            return jaasServiceName;
        }
        if (configServiceName != null) {
            return configServiceName;
        }
        throw new IllegalArgumentException("No serviceName defined in either JAAS or Kafka config");
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long expires = tgt.getEndTime().getTime();
        log.debug("[Principal={}]: TGT valid starting at: {}", (Object)this.principal, (Object)tgt.getStartTime());
        log.debug("[Principal={}]: TGT expires: {}", (Object)this.principal, (Object)tgt.getEndTime());
        log.debug("[Principal={}]: TGT renew until: {}", (Object)this.principal, (Object)tgt.getRenewTill());
        return start + (long)((double)(expires - start) * this.ticketRenewWindowFactor);
    }

    private KerberosTicket getTGT() {
        Set<KerberosTicket> tickets = this.subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            KerberosPrincipal server = ticket.getServer();
            String expectedServerName = String.format("krbtgt/%s@%s", server.getRealm(), server.getRealm());
            if (!server.getName().equals(expectedServerName)) continue;
            log.debug("Found TGT with client principal '{}' and server principal '{}'.", (Object)ticket.getClient().getName(), (Object)ticket.getServer().getName());
            return ticket;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reLogin() throws LoginException {
        if (!this.isKrbTicket) {
            return;
        }
        if (this.loginContext == null) {
            throw new LoginException("Login must be done first");
        }
        Class<KerberosLogin> clazz = KerberosLogin.class;
        synchronized (KerberosLogin.class) {
            log.info("Initiating logout for {}", (Object)this.principal);
            this.loginContext.logout();
            this.loginContext = new LoginContext(this.contextName(), this.subject, null, this.configuration());
            log.info("Initiating re-login for {}", (Object)this.principal);
            this.loginContext.login();
            log.info("Successful re-login for {}", (Object)this.principal);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

