/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.dropbox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.dropbox.credentials.service.DropboxCredentialDetails;
import org.apache.nifi.dropbox.credentials.service.DropboxCredentialService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;

@CapabilityDescription(value="Defines credentials for Dropbox processors.")
@Tags(value={"dropbox", "credentials", "provider"})
public class StandardDropboxCredentialService
extends AbstractControllerService
implements DropboxCredentialService {
    public static final PropertyDescriptor APP_KEY = new PropertyDescriptor.Builder().name("app-key").displayName("App Key").description("App Key of the user's Dropbox app. See Additional Details for more information.").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).build();
    public static final PropertyDescriptor APP_SECRET = new PropertyDescriptor.Builder().name("app-secret").displayName("App Secret").description("App Secret of the user's Dropbox app. See Additional Details for more information.").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).build();
    public static final PropertyDescriptor ACCESS_TOKEN = new PropertyDescriptor.Builder().name("access-token").displayName("Access Token").description("Access Token of the user's Dropbox app. See Additional Details for more information about Access Token generation.").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).build();
    public static final PropertyDescriptor REFRESH_TOKEN = new PropertyDescriptor.Builder().name("refresh-token").displayName("Refresh Token").description("Refresh Token of the user's Dropbox app. See Additional Details for more information about Refresh Token generation.").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).build();
    private static final List<PropertyDescriptor> PROPERTIES;
    private DropboxCredentialDetails credential;

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        String appKey = context.getProperty(APP_KEY).evaluateAttributeExpressions().getValue();
        String appSecret = context.getProperty(APP_SECRET).evaluateAttributeExpressions().getValue();
        String accessToken = context.getProperty(ACCESS_TOKEN).evaluateAttributeExpressions().getValue();
        String refreshToken = context.getProperty(REFRESH_TOKEN).evaluateAttributeExpressions().getValue();
        this.credential = new DropboxCredentialDetails(appKey, appSecret, accessToken, refreshToken);
    }

    public DropboxCredentialDetails getDropboxCredential() {
        return this.credential;
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(APP_KEY);
        props.add(APP_SECRET);
        props.add(ACCESS_TOKEN);
        props.add(REFRESH_TOKEN);
        PROPERTIES = Collections.unmodifiableList(props);
    }
}

