/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.dropbox;

import com.dropbox.core.DbxApiException;
import com.dropbox.core.DbxException;
import com.dropbox.core.RateLimitException;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.CommitInfo;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.UploadErrorException;
import com.dropbox.core.v2.files.UploadSessionAppendV2Uploader;
import com.dropbox.core.v2.files.UploadSessionCursor;
import com.dropbox.core.v2.files.UploadSessionFinishErrorException;
import com.dropbox.core.v2.files.UploadSessionFinishUploader;
import com.dropbox.core.v2.files.UploadSessionStartResult;
import com.dropbox.core.v2.files.UploadSessionStartUploader;
import com.dropbox.core.v2.files.UploadUploader;
import com.dropbox.core.v2.files.WriteMode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.conflict.resolution.ConflictResolutionStrategy;
import org.apache.nifi.processors.dropbox.DropboxTrait;
import org.apache.nifi.processors.dropbox.FetchDropbox;
import org.apache.nifi.processors.dropbox.ListDropbox;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;

@SeeAlso(value={ListDropbox.class, FetchDropbox.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"dropbox", "storage", "put"})
@CapabilityDescription(value="Puts content to a Dropbox folder.")
@ReadsAttribute(attribute="filename", description="Uses the FlowFile's filename as the filename for the Dropbox object.")
@WritesAttributes(value={@WritesAttribute(attribute="error.message", description="The error message returned by Dropbox"), @WritesAttribute(attribute="dropbox.id", description="The Dropbox identifier of the file"), @WritesAttribute(attribute="path", description="The folder path where the file is located"), @WritesAttribute(attribute="filename", description="The name of the file"), @WritesAttribute(attribute="dropbox.size", description="The size of the file"), @WritesAttribute(attribute="dropbox.timestamp", description="The server modified time of the file"), @WritesAttribute(attribute="dropbox.revision", description="Revision of the file")})
public class PutDropbox
extends AbstractProcessor
implements DropboxTrait {
    public static final int SINGLE_UPLOAD_LIMIT_IN_BYTES = 0x9600000;
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Files that have been successfully written to Dropbox are transferred to this relationship.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Files that could not be written to Dropbox for some reason are transferred to this relationship.").build();
    public static final PropertyDescriptor FOLDER = new PropertyDescriptor.Builder().name("folder").displayName("Folder").description("The path of the Dropbox folder to upload files to. The folder will be created if it does not exist yet.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("/.*"))).defaultValue("/").build();
    public static final PropertyDescriptor FILE_NAME = new PropertyDescriptor.Builder().name("file-name").displayName("Filename").description("The full name of the file to upload.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("${filename}").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CONFLICT_RESOLUTION = new PropertyDescriptor.Builder().name("conflict-resolution-strategy").displayName("Conflict Resolution Strategy").description("Indicates what should happen when a file with the same name already exists in the specified Dropbox folder.").required(true).defaultValue(ConflictResolutionStrategy.FAIL.getValue()).allowableValues(ConflictResolutionStrategy.class).build();
    public static final PropertyDescriptor CHUNKED_UPLOAD_SIZE = new PropertyDescriptor.Builder().name("chunked-upload-size").displayName("Chunked Upload Size").description("Defines the size of a chunk. Used when a FlowFile's size exceeds 'Chunked Upload Threshold' and content is uploaded in smaller chunks. It is recommended to specify chunked upload size smaller than 'Chunked Upload Threshold' and as multiples of 4 MB. Maximum allowed value is 150 MB.").defaultValue("8 MB").addValidator(StandardValidators.createDataSizeBoundsValidator((long)1L, (long)0x9600000L)).required(false).build();
    public static final PropertyDescriptor CHUNKED_UPLOAD_THRESHOLD = new PropertyDescriptor.Builder().name("chunked-upload-threshold").displayName("Chunked Upload Threshold").description("The maximum size of the content which is uploaded at once. FlowFiles larger than this threshold are uploaded in chunks. Maximum allowed value is 150 MB.").defaultValue("150 MB").addValidator(StandardValidators.createDataSizeBoundsValidator((long)1L, (long)0x9600000L)).required(false).build();
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(CREDENTIAL_SERVICE, FOLDER, FILE_NAME, CONFLICT_RESOLUTION, CHUNKED_UPLOAD_THRESHOLD, CHUNKED_UPLOAD_SIZE, ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)false, (ProxySpec[])new ProxySpec[]{ProxySpec.HTTP_AUTH})));
    private static final Set<Relationship> RELATIONSHIPS;
    private volatile DbxClientV2 dropboxApiClient;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.dropboxApiClient = this.getDropboxApiClient(context, this.getIdentifier());
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String folder = context.getProperty(FOLDER).evaluateAttributeExpressions(flowFile).getValue();
        String filename = context.getProperty(FILE_NAME).evaluateAttributeExpressions(flowFile).getValue();
        long chunkUploadThreshold = context.getProperty(CHUNKED_UPLOAD_THRESHOLD).asDataSize(DataUnit.B).longValue();
        long uploadChunkSize = context.getProperty(CHUNKED_UPLOAD_SIZE).asDataSize(DataUnit.B).longValue();
        ConflictResolutionStrategy conflictResolution = ConflictResolutionStrategy.forValue((String)context.getProperty(CONFLICT_RESOLUTION).getValue());
        long size = flowFile.getSize();
        String uploadPath = this.convertFolderName(folder) + "/" + filename;
        long startNanos = System.nanoTime();
        FileMetadata fileMetadata = null;
        try {
            block21: {
                try (InputStream rawIn = session.read(flowFile);){
                    if (size <= chunkUploadThreshold) {
                        try (UploadUploader uploader = this.createUploadUploader(uploadPath, conflictResolution);){
                            fileMetadata = (FileMetadata)uploader.uploadAndFinish(rawIn);
                            break block21;
                        }
                    }
                    fileMetadata = this.uploadLargeFileInChunks(uploadPath, rawIn, size, uploadChunkSize, conflictResolution);
                }
                catch (UploadErrorException e) {
                    this.handleUploadError(conflictResolution, uploadPath, e);
                }
                catch (UploadSessionFinishErrorException e) {
                    this.handleUploadError(conflictResolution, uploadPath, e);
                }
                catch (RateLimitException e) {
                    context.yield();
                    throw new ProcessException("Dropbox API rate limit exceeded while uploading file", (Throwable)e);
                }
            }
            if (fileMetadata != null) {
                Map attributes = this.createAttributeMap(fileMetadata);
                String url = "https://www.dropbox.com/home" + fileMetadata.getPathDisplay();
                flowFile = session.putAllAttributes(flowFile, attributes);
                long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                session.getProvenanceReporter().send(flowFile, url, transferMillis);
            }
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (Exception e) {
            this.getLogger().error("Exception occurred while uploading file '{}' to Dropbox folder '{}'", new Object[]{filename, folder, e});
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private void handleUploadError(ConflictResolutionStrategy conflictResolution, String uploadPath, UploadErrorException e) {
        if (!e.errorValue.isPath() || !e.errorValue.getPathValue().getReason().isConflict()) {
            throw new ProcessException((Throwable)e);
        }
        this.handleConflict(conflictResolution, uploadPath, (DbxApiException)e);
    }

    private void handleUploadError(ConflictResolutionStrategy conflictResolution, String uploadPath, UploadSessionFinishErrorException e) {
        if (!e.errorValue.isPath() || !e.errorValue.getPathValue().isConflict()) {
            throw new ProcessException((Throwable)e);
        }
        this.handleConflict(conflictResolution, uploadPath, (DbxApiException)e);
    }

    private void handleConflict(ConflictResolutionStrategy conflictResolution, String uploadPath, DbxApiException e) {
        if (conflictResolution == ConflictResolutionStrategy.IGNORE) {
            this.getLogger().info("File with the same name [{}] already exists. Remote file is not modified due to {} being set to '{}'.", new Object[]{uploadPath, CONFLICT_RESOLUTION.getDisplayName(), conflictResolution});
        } else if (conflictResolution == ConflictResolutionStrategy.FAIL) {
            throw new ProcessException(String.format("File with the same name [%s] already exists.", uploadPath), (Throwable)e);
        }
    }

    private FileMetadata uploadLargeFileInChunks(String path, InputStream rawIn, long size, long uploadChunkSize, ConflictResolutionStrategy conflictResolution) throws DbxException, IOException {
        String sessionId;
        try (UploadSessionStartUploader uploader = this.createUploadSessionStartUploader();){
            sessionId = ((UploadSessionStartResult)uploader.uploadAndFinish(rawIn, uploadChunkSize)).getSessionId();
        }
        long uploadedBytes = uploadChunkSize;
        UploadSessionCursor cursor = new UploadSessionCursor(sessionId, uploadedBytes);
        while (size - uploadedBytes > uploadChunkSize) {
            UploadSessionAppendV2Uploader uploader = this.createUploadSessionAppendV2Uploader(cursor);
            try {
                uploader.uploadAndFinish(rawIn, uploadChunkSize);
                cursor = new UploadSessionCursor(sessionId, uploadedBytes += uploadChunkSize);
            }
            finally {
                if (uploader == null) continue;
                uploader.close();
            }
        }
        long remainingBytes = size - uploadedBytes;
        CommitInfo commitInfo = CommitInfo.newBuilder((String)path).withMode(this.getWriteMode(conflictResolution)).withStrictConflict(Boolean.valueOf(true)).withClientModified(new Date(System.currentTimeMillis())).build();
        try (UploadSessionFinishUploader uploader = this.createUploadSessionFinishUploader(cursor, commitInfo);){
            FileMetadata fileMetadata = (FileMetadata)uploader.uploadAndFinish(rawIn, remainingBytes);
            return fileMetadata;
        }
    }

    private WriteMode getWriteMode(ConflictResolutionStrategy conflictResolution) {
        if (conflictResolution == ConflictResolutionStrategy.REPLACE) {
            return WriteMode.OVERWRITE;
        }
        return WriteMode.ADD;
    }

    private UploadUploader createUploadUploader(String path, ConflictResolutionStrategy conflictResolution) throws DbxException {
        return this.dropboxApiClient.files().uploadBuilder(path).withMode(this.getWriteMode(conflictResolution)).withStrictConflict(Boolean.valueOf(true)).start();
    }

    private UploadSessionStartUploader createUploadSessionStartUploader() throws DbxException {
        return this.dropboxApiClient.files().uploadSessionStart();
    }

    private UploadSessionAppendV2Uploader createUploadSessionAppendV2Uploader(UploadSessionCursor cursor) throws DbxException {
        return this.dropboxApiClient.files().uploadSessionAppendV2(cursor);
    }

    private UploadSessionFinishUploader createUploadSessionFinishUploader(UploadSessionCursor cursor, CommitInfo commitInfo) throws DbxException {
        return this.dropboxApiClient.files().uploadSessionFinish(cursor, commitInfo);
    }

    static {
        HashSet<Relationship> rels = new HashSet<Relationship>();
        rels.add(REL_SUCCESS);
        rels.add(REL_FAILURE);
        RELATIONSHIPS = Collections.unmodifiableSet(rels);
    }
}

