/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server.codec;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.distributed.cache.operations.CacheOperation;
import org.apache.nifi.distributed.cache.operations.MapOperation;
import org.apache.nifi.distributed.cache.server.map.MapCache;
import org.apache.nifi.distributed.cache.server.map.MapCacheRecord;
import org.apache.nifi.distributed.cache.server.map.MapPutResult;
import org.apache.nifi.distributed.cache.server.protocol.CacheOperationResult;
import org.apache.nifi.distributed.cache.server.protocol.MapCacheRequest;
import org.apache.nifi.distributed.cache.server.protocol.MapRemoveResponse;
import org.apache.nifi.distributed.cache.server.protocol.MapSizeResponse;
import org.apache.nifi.distributed.cache.server.protocol.MapValueResponse;
import org.apache.nifi.logging.ComponentLog;

@ChannelHandler.Sharable
public class MapCacheRequestHandler
extends SimpleChannelInboundHandler<MapCacheRequest> {
    private static final long REVISION_NOT_FOUND = -1L;
    private final ComponentLog log;
    private final MapCache mapCache;

    public MapCacheRequestHandler(ComponentLog log, MapCache mapCache) {
        this.log = Objects.requireNonNull(log, "Component Log required");
        this.mapCache = Objects.requireNonNull(mapCache, "Map Cache required");
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, MapCacheRequest mapCacheRequest) throws Exception {
        CacheOperation cacheOperation = mapCacheRequest.getCacheOperation();
        if (MapOperation.CLOSE == cacheOperation) {
            this.log.debug("Map Cache Operation [{}] received", new Object[]{cacheOperation});
            channelHandlerContext.close();
        } else if (MapOperation.CONTAINS_KEY == cacheOperation) {
            ByteBuffer key = ByteBuffer.wrap(mapCacheRequest.getKey());
            boolean success = this.mapCache.containsKey(key);
            this.writeResult(channelHandlerContext, cacheOperation, success);
        } else if (MapOperation.GET == cacheOperation) {
            ByteBuffer key = ByteBuffer.wrap(mapCacheRequest.getKey());
            ByteBuffer cached = this.mapCache.get(key);
            this.writeBytes(channelHandlerContext, cacheOperation, cached);
        } else if (MapOperation.GET_AND_PUT_IF_ABSENT == cacheOperation) {
            ByteBuffer value;
            ByteBuffer key = ByteBuffer.wrap(mapCacheRequest.getKey());
            MapPutResult result = this.mapCache.putIfAbsent(key, value = ByteBuffer.wrap(mapCacheRequest.getValue()));
            ByteBuffer cached = result.isSuccessful() ? null : result.getExisting().getValue();
            this.writeBytes(channelHandlerContext, cacheOperation, cached);
        } else if (MapOperation.FETCH == cacheOperation) {
            ByteBuffer key = ByteBuffer.wrap(mapCacheRequest.getKey());
            MapCacheRecord mapCacheRecord = this.mapCache.fetch(key);
            this.writeMapCacheRecord(channelHandlerContext, cacheOperation, mapCacheRecord);
        } else if (MapOperation.KEYSET == cacheOperation) {
            Set<ByteBuffer> keySet = this.mapCache.keySet();
            this.writeSize(channelHandlerContext, cacheOperation, keySet.size());
            for (ByteBuffer key : keySet) {
                this.writeBytes(channelHandlerContext, cacheOperation, key);
            }
        } else if (MapOperation.PUT == cacheOperation) {
            ByteBuffer key = ByteBuffer.wrap(mapCacheRequest.getKey());
            ByteBuffer value = ByteBuffer.wrap(mapCacheRequest.getValue());
            MapPutResult result = this.mapCache.put(key, value);
            this.writeResult(channelHandlerContext, cacheOperation, result.isSuccessful());
        } else if (MapOperation.PUT_IF_ABSENT == cacheOperation) {
            ByteBuffer key = ByteBuffer.wrap(mapCacheRequest.getKey());
            ByteBuffer value = ByteBuffer.wrap(mapCacheRequest.getValue());
            MapPutResult result = this.mapCache.putIfAbsent(key, value);
            this.writeResult(channelHandlerContext, cacheOperation, result.isSuccessful());
        } else if (MapOperation.REMOVE == cacheOperation) {
            ByteBuffer key = ByteBuffer.wrap(mapCacheRequest.getKey());
            ByteBuffer removed = this.mapCache.remove(key);
            boolean success = removed != null;
            this.writeResult(channelHandlerContext, cacheOperation, success);
        } else if (MapOperation.REMOVE_AND_GET == cacheOperation) {
            ByteBuffer key = ByteBuffer.wrap(mapCacheRequest.getKey());
            ByteBuffer removed = this.mapCache.remove(key);
            this.writeBytes(channelHandlerContext, cacheOperation, removed);
        } else if (MapOperation.REMOVE_BY_PATTERN == cacheOperation) {
            String pattern = mapCacheRequest.getPattern();
            Map<ByteBuffer, ByteBuffer> removed = this.mapCache.removeByPattern(pattern);
            int size = removed == null ? 0 : removed.size();
            this.writeRemoved(channelHandlerContext, cacheOperation, size);
        } else if (MapOperation.REMOVE_BY_PATTERN_AND_GET == cacheOperation) {
            String pattern = mapCacheRequest.getPattern();
            Map<ByteBuffer, ByteBuffer> removed = this.mapCache.removeByPattern(pattern);
            if (removed == null) {
                this.writeRemoved(channelHandlerContext, cacheOperation, 0L);
            } else {
                this.writeSize(channelHandlerContext, cacheOperation, removed.size());
                for (Map.Entry<ByteBuffer, ByteBuffer> entry : removed.entrySet()) {
                    this.writeBytes(channelHandlerContext, cacheOperation, entry.getKey());
                    this.writeBytes(channelHandlerContext, cacheOperation, entry.getValue());
                }
            }
        } else if (MapOperation.REPLACE == cacheOperation) {
            ByteBuffer key = ByteBuffer.wrap(mapCacheRequest.getKey());
            ByteBuffer value = ByteBuffer.wrap(mapCacheRequest.getValue());
            MapCacheRecord mapCacheRecord = new MapCacheRecord(key, value, mapCacheRequest.getRevision());
            MapPutResult result = this.mapCache.replace(mapCacheRecord);
            this.writeResult(channelHandlerContext, cacheOperation, result.isSuccessful());
        } else if (MapOperation.SUBMAP == cacheOperation) {
            List<byte[]> keys = mapCacheRequest.getKeys();
            for (byte[] key : keys) {
                ByteBuffer requestedKey = ByteBuffer.wrap(key);
                ByteBuffer value = this.mapCache.get(requestedKey);
                this.writeBytes(channelHandlerContext, cacheOperation, value);
            }
        } else {
            this.log.warn("Map Cache Operation [{}] not supported", new Object[]{cacheOperation});
        }
    }

    private void writeResult(ChannelHandlerContext channelHandlerContext, CacheOperation cacheOperation, boolean success) {
        this.log.debug("Map Cache Operation [{}] Success [{}]", new Object[]{cacheOperation, success});
        CacheOperationResult cacheOperationResult = new CacheOperationResult(success);
        channelHandlerContext.writeAndFlush((Object)cacheOperationResult);
    }

    private void writeRemoved(ChannelHandlerContext channelHandlerContext, CacheOperation cacheOperation, long size) {
        MapRemoveResponse mapRemoveResponse = new MapRemoveResponse(size);
        this.log.debug("Map Cache Operation [{}] Size [{}]", new Object[]{cacheOperation, size});
        channelHandlerContext.writeAndFlush((Object)mapRemoveResponse);
    }

    private void writeSize(ChannelHandlerContext channelHandlerContext, CacheOperation cacheOperation, int size) {
        MapSizeResponse mapSizeResponse = new MapSizeResponse(size);
        this.log.debug("Map Cache Operation [{}] Size [{}]", new Object[]{cacheOperation, size});
        channelHandlerContext.writeAndFlush((Object)mapSizeResponse);
    }

    private void writeBytes(ChannelHandlerContext channelHandlerContext, CacheOperation cacheOperation, ByteBuffer buffer) {
        byte[] bytes = buffer == null ? null : buffer.array();
        int length = bytes == null ? 0 : bytes.length;
        MapValueResponse mapValueResponse = new MapValueResponse(length, bytes);
        this.log.debug("Map Cache Operation [{}] Length [{}]", new Object[]{cacheOperation, length});
        channelHandlerContext.writeAndFlush((Object)mapValueResponse);
    }

    private void writeMapCacheRecord(ChannelHandlerContext channelHandlerContext, CacheOperation cacheOperation, MapCacheRecord mapCacheRecord) {
        long revision = mapCacheRecord == null ? -1L : mapCacheRecord.getRevision();
        byte[] value = mapCacheRecord == null ? null : mapCacheRecord.getValue().array();
        int length = value == null ? 0 : value.length;
        MapValueResponse mapValueResponse = new MapValueResponse(length, value, revision);
        this.log.debug("Map Cache Operation [{}] Length [{}]", new Object[]{cacheOperation, length});
        channelHandlerContext.writeAndFlush((Object)mapValueResponse);
    }
}

