/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server.map;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.distributed.cache.server.map.MapCache;
import org.apache.nifi.distributed.cache.server.map.MapCacheRecord;
import org.apache.nifi.distributed.cache.server.map.MapPutResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wali.MinimalLockingWriteAheadLog;
import org.wali.SerDe;
import org.wali.UpdateType;
import org.wali.WriteAheadRepository;

public class PersistentMapCache
implements MapCache {
    private static final Logger logger = LoggerFactory.getLogger(PersistentMapCache.class);
    private final MapCache wrapped;
    private final WriteAheadRepository<MapWaliRecord> wali;
    private final AtomicLong modifications = new AtomicLong(0L);

    public PersistentMapCache(String serviceIdentifier, File persistencePath, MapCache cacheToWrap) throws IOException {
        try {
            this.wali = new MinimalLockingWriteAheadLog(persistencePath.toPath(), 1, (SerDe)new Serde(), null);
        }
        catch (OverlappingFileLockException ex) {
            logger.error("OverlappingFileLockException thrown: Check lock location - possible duplicate persistencePath conflict in PersistentMapCache.");
            throw ex;
        }
        this.wrapped = cacheToWrap;
    }

    synchronized void restore() throws IOException {
        Collection recovered = this.wali.recoverRecords();
        for (MapWaliRecord record : recovered) {
            if (record.getUpdateType() != UpdateType.CREATE) continue;
            this.wrapped.putIfAbsent(record.getKey(), record.getValue());
        }
    }

    @Override
    public MapPutResult putIfAbsent(ByteBuffer key, ByteBuffer value) throws IOException {
        MapPutResult putResult = this.wrapped.putIfAbsent(key, value);
        this.putWriteAheadLog(key, value, putResult);
        return putResult;
    }

    @Override
    public MapPutResult put(ByteBuffer key, ByteBuffer value) throws IOException {
        MapPutResult putResult = this.wrapped.put(key, value);
        this.putWriteAheadLog(key, value, putResult);
        return putResult;
    }

    protected void putWriteAheadLog(ByteBuffer key, ByteBuffer value, MapPutResult putResult) throws IOException {
        if (putResult.isSuccessful()) {
            MapWaliRecord record = new MapWaliRecord(UpdateType.CREATE, key, value);
            ArrayList<MapWaliRecord> records = new ArrayList<MapWaliRecord>();
            records.add(record);
            MapCacheRecord evicted = putResult.getEvicted();
            if (evicted != null) {
                records.add(new MapWaliRecord(UpdateType.DELETE, evicted.getKey(), evicted.getValue()));
            }
            this.wali.update(records, false);
            long modCount = this.modifications.getAndIncrement();
            if (modCount > 0L && modCount % 100000L == 0L) {
                this.wali.checkpoint();
            }
        }
    }

    @Override
    public boolean containsKey(ByteBuffer key) throws IOException {
        return this.wrapped.containsKey(key);
    }

    @Override
    public ByteBuffer get(ByteBuffer key) throws IOException {
        return this.wrapped.get(key);
    }

    @Override
    public Map<ByteBuffer, ByteBuffer> subMap(List<ByteBuffer> keys) throws IOException {
        if (keys == null) {
            return null;
        }
        HashMap<ByteBuffer, ByteBuffer> results = new HashMap<ByteBuffer, ByteBuffer>(keys.size());
        for (ByteBuffer key : keys) {
            results.put(key, this.wrapped.get(key));
        }
        return results;
    }

    @Override
    public MapCacheRecord fetch(ByteBuffer key) throws IOException {
        return this.wrapped.fetch(key);
    }

    @Override
    public MapPutResult replace(MapCacheRecord record) throws IOException {
        MapPutResult putResult = this.wrapped.replace(record);
        this.putWriteAheadLog(record.getKey(), record.getValue(), putResult);
        return putResult;
    }

    @Override
    public ByteBuffer remove(ByteBuffer key) throws IOException {
        ByteBuffer removeResult = this.wrapped.remove(key);
        if (removeResult != null) {
            MapWaliRecord record = new MapWaliRecord(UpdateType.DELETE, key, removeResult);
            ArrayList<MapWaliRecord> records = new ArrayList<MapWaliRecord>(1);
            records.add(record);
            this.wali.update(records, false);
            long modCount = this.modifications.getAndIncrement();
            if (modCount > 0L && modCount % 1000L == 0L) {
                this.wali.checkpoint();
            }
        }
        return removeResult;
    }

    @Override
    public Map<ByteBuffer, ByteBuffer> removeByPattern(String regex) throws IOException {
        Map<ByteBuffer, ByteBuffer> removeResult = this.wrapped.removeByPattern(regex);
        if (removeResult != null) {
            ArrayList<MapWaliRecord> records = new ArrayList<MapWaliRecord>(removeResult.size());
            for (Map.Entry<ByteBuffer, ByteBuffer> entry : removeResult.entrySet()) {
                MapWaliRecord record = new MapWaliRecord(UpdateType.DELETE, entry.getKey(), entry.getValue());
                records.add(record);
                this.wali.update(records, false);
                long modCount = this.modifications.getAndIncrement();
                if (modCount <= 0L || modCount % 1000L != 0L) continue;
                this.wali.checkpoint();
            }
        }
        return removeResult;
    }

    @Override
    public Set<ByteBuffer> keySet() throws IOException {
        return this.wrapped.keySet();
    }

    @Override
    public void shutdown() throws IOException {
        this.wali.shutdown();
    }

    private static class Serde
    implements SerDe<MapWaliRecord> {
        private Serde() {
        }

        public void serializeEdit(MapWaliRecord previousRecordState, MapWaliRecord newRecordState, DataOutputStream out) throws IOException {
            UpdateType updateType = newRecordState.getUpdateType();
            if (updateType == UpdateType.DELETE) {
                out.write(0);
            } else {
                out.write(1);
            }
            byte[] key = newRecordState.getKey().array();
            byte[] value = newRecordState.getValue().array();
            out.writeInt(key.length);
            out.write(key);
            out.writeInt(value.length);
            out.write(value);
        }

        public void serializeRecord(MapWaliRecord record, DataOutputStream out) throws IOException {
            this.serializeEdit(null, record, out);
        }

        public MapWaliRecord deserializeEdit(DataInputStream in, Map<Object, MapWaliRecord> currentRecordStates, int version) throws IOException {
            int updateTypeValue = in.read();
            if (updateTypeValue < 0) {
                throw new EOFException();
            }
            UpdateType updateType = updateTypeValue == 0 ? UpdateType.DELETE : UpdateType.CREATE;
            int keySize = in.readInt();
            byte[] key = new byte[keySize];
            in.readFully(key);
            int valueSize = in.readInt();
            byte[] value = new byte[valueSize];
            in.readFully(value);
            return new MapWaliRecord(updateType, ByteBuffer.wrap(key), ByteBuffer.wrap(value));
        }

        public MapWaliRecord deserializeRecord(DataInputStream in, int version) throws IOException {
            return this.deserializeEdit(in, (Map)new HashMap(), version);
        }

        public Object getRecordIdentifier(MapWaliRecord record) {
            return record.getKey();
        }

        public UpdateType getUpdateType(MapWaliRecord record) {
            return record.getUpdateType();
        }

        public String getLocation(MapWaliRecord record) {
            return null;
        }

        public int getVersion() {
            return 1;
        }
    }

    private static class MapWaliRecord {
        private final UpdateType updateType;
        private final ByteBuffer key;
        private final ByteBuffer value;

        public MapWaliRecord(UpdateType updateType, ByteBuffer key, ByteBuffer value) {
            this.updateType = updateType;
            this.key = key;
            this.value = value;
        }

        public UpdateType getUpdateType() {
            return this.updateType;
        }

        public ByteBuffer getKey() {
            return this.key;
        }

        public ByteBuffer getValue() {
            return this.value;
        }
    }
}

