/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client.adapter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import org.apache.nifi.distributed.cache.client.adapter.InboundAdapter;

public class LongInboundAdapter
implements InboundAdapter {
    private final ByteBuf byteBuf = Unpooled.buffer();
    private Long result = null;

    public Long getResult() {
        return this.result;
    }

    @Override
    public boolean isComplete() {
        return this.result != null;
    }

    @Override
    public void queue(byte[] bytes) {
        this.byteBuf.writeBytes(bytes);
    }

    @Override
    public void dequeue() throws IOException {
        if (this.byteBuf.readableBytes() >= 8) {
            this.result = this.byteBuf.readLong();
        }
    }
}

