/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.nifi.distributed.cache.client.Serializer;

public class CacheClientSerde {
    public static <T> byte[] serialize(T value, Serializer<T> serializer) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        serializer.serialize(value, (OutputStream)os);
        return os.toByteArray();
    }

    public static <T> Collection<byte[]> serialize(Set<T> values, Serializer<T> serializer) throws IOException {
        ArrayList<byte[]> bytesValues = new ArrayList<byte[]>();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (T value : values) {
            serializer.serialize(value, (OutputStream)os);
            bytesValues.add(os.toByteArray());
            os.reset();
        }
        return bytesValues;
    }
}

