/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp;

import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.service.lookup.AbstractSingleAttributeBasedControllerServiceLookup;

@Tags(value={"dbcp", "jdbc", "database", "connection", "pooling", "store"})
@CapabilityDescription(value="Provides a DBCPService that can be used to dynamically select another DBCPService. This service requires an attribute named 'database.name' to be passed in when asking for a connection, and will throw an exception if the attribute is missing. The value of 'database.name' will be used to select the DBCPService that has been registered with that name. This will allow multiple DBCPServices to be defined and registered, and then selected dynamically at runtime by tagging flow files with the appropriate 'database.name' attribute.")
@DynamicProperty(name="The name to register DBCPService", value="The DBCPService", description="If 'database.name' attribute contains the name of the dynamic property, then the DBCPService (registered in the value) will be selected.", expressionLanguageScope=ExpressionLanguageScope.NONE)
public class DBCPConnectionPoolLookup
extends AbstractSingleAttributeBasedControllerServiceLookup<DBCPService>
implements DBCPService {
    public static final String DATABASE_NAME_ATTRIBUTE = "database.name";

    protected String getLookupAttribute() {
        return DATABASE_NAME_ATTRIBUTE;
    }

    public Class<DBCPService> getServiceType() {
        return DBCPService.class;
    }

    public Connection getConnection() throws ProcessException {
        throw new UnsupportedOperationException("Cannot lookup DBCPConnectionPool without attributes");
    }

    public Connection getConnection(Map<String, String> attributes) {
        return ((DBCPService)this.lookupService(attributes)).getConnection(attributes);
    }

    public FlowFileFilter getFlowFileFilter() {
        AtomicReference ref = new AtomicReference();
        return flowFile -> {
            String flowFileDBName = flowFile.getAttribute(DATABASE_NAME_ATTRIBUTE);
            if (StringUtils.isEmpty((CharSequence)flowFileDBName)) {
                throw new ProcessException("FlowFile attributes must contain an attribute name 'database.name'");
            }
            String databaseName = ref.compareAndSet(null, flowFileDBName) ? flowFileDBName : (String)ref.get();
            return flowFileDBName.equals(databaseName) ? FlowFileFilter.FlowFileFilterResult.ACCEPT_AND_CONTINUE : FlowFileFilter.FlowFileFilterResult.REJECT_AND_CONTINUE;
        };
    }
}

