/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.db;

import org.apache.avro.file.CodecFactory;

public class AvroUtil {
    public static CodecFactory getCodecFactory(String property) {
        CodecType type = CodecType.valueOf(property);
        switch (type) {
            case BZIP2: {
                return CodecFactory.bzip2Codec();
            }
            case DEFLATE: {
                return CodecFactory.deflateCodec((int)-1);
            }
            case LZO: {
                return CodecFactory.xzCodec((int)6);
            }
            case SNAPPY: {
                return CodecFactory.snappyCodec();
            }
        }
        return CodecFactory.nullCodec();
    }

    public static enum CodecType {
        BZIP2,
        DEFLATE,
        NONE,
        SNAPPY,
        LZO;

    }
}

