/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.cybersecurity.matchers;

import info.debatty.java.spamsum.SpamSum;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Scanner;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.cybersecurity.matchers.FuzzyHashMatcher;

public class SSDeepHashMatcher
implements FuzzyHashMatcher {
    ComponentLog logger;

    public SSDeepHashMatcher() {
    }

    public SSDeepHashMatcher(ComponentLog logger) {
        this.logger = logger;
    }

    @Override
    public BufferedReader getReader(String source) throws IOException {
        File file = new File(source);
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileInputStream));
        reader.readLine();
        return reader;
    }

    @Override
    public boolean matchExceedsThreshold(double similarity, double matchThreshold) {
        return similarity >= matchThreshold;
    }

    @Override
    public double getSimilarity(String inputHash, String existingHash) {
        String[] hashToCompare = existingHash.split(",", 2);
        if (hashToCompare.length > 0) {
            return new SpamSum().match(inputHash, hashToCompare[0]);
        }
        return Double.NaN;
    }

    @Override
    public boolean isValidHash(String inputHash) {
        String[] fields = inputHash.split(":", 3);
        if (fields.length == 3) {
            boolean hashTwoIsNotEmpty;
            Scanner sc = new Scanner(fields[0]);
            boolean isNumber = sc.hasNextInt();
            if (!isNumber && this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Field should be numeric but got '{}'. Will tell processor to ignore.", new Object[]{fields[0]});
            }
            boolean hashOneIsNotEmpty = !fields[1].isEmpty();
            boolean bl = hashTwoIsNotEmpty = !fields[2].isEmpty();
            if (isNumber && hashOneIsNotEmpty && hashTwoIsNotEmpty) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getHash(String line) {
        if (this.isValidHash(line)) {
            return line.split(",", 2)[0];
        }
        return null;
    }

    @Override
    public String getMatch(String line) {
        String[] match;
        if (this.isValidHash(line) && (match = line.split(",", 2)).length == 2) {
            return match[1];
        }
        return null;
    }
}

