/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.cybersecurity;

import com.idealista.tlsh.TLSH;
import info.debatty.java.spamsum.SpamSum;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;

abstract class AbstractFuzzyHashProcessor
extends AbstractProcessor {
    protected static final String ssdeep = "ssdeep";
    protected static final String tlsh = "tlsh";
    public static final AllowableValue allowableValueSSDEEP = new AllowableValue("ssdeep", "ssdeep", "Uses ssdeep / SpamSum 'context triggered piecewise hash'.");
    public static final AllowableValue allowableValueTLSH = new AllowableValue("tlsh", "tlsh", "Uses TLSH (Trend 'Locality Sensitive Hash'). Note: FlowFile Content must be at least 512 characters long");
    public static final PropertyDescriptor ATTRIBUTE_NAME = new PropertyDescriptor.Builder().name("ATTRIBUTE_NAME").displayName("Hash Attribute Name").description("The name of the FlowFile Attribute that should hold the Fuzzy Hash Value").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("fuzzyhash.value").build();
    public static final PropertyDescriptor HASH_ALGORITHM = new PropertyDescriptor.Builder().name("HASH_ALGORITHM").displayName("Hashing Algorithm").description("The hashing algorithm utilised").allowableValues(new AllowableValue[]{allowableValueSSDEEP, allowableValueTLSH}).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    protected List<PropertyDescriptor> descriptors;
    protected Set<Relationship> relationships;

    AbstractFuzzyHashProcessor() {
    }

    protected boolean checkMinimumAlgorithmRequirements(String algorithm, FlowFile flowFile) {
        return !algorithm.equals(tlsh) || flowFile.getSize() >= 512L;
    }

    protected String generateHash(String algorithm, String content) {
        switch (algorithm) {
            case "tlsh": {
                return new TLSH(content).hash();
            }
            case "ssdeep": {
                return new SpamSum().HashString(content);
            }
        }
        return null;
    }
}

