/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.confluent.schemaregistry;

import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.processor.util.StandardValidators;

public class MultipleURLValidator
implements Validator {
    public ValidationResult validate(String subject, String input, ValidationContext context) {
        String[] splits = input.split(",");
        if (splits.length == 0) {
            return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("At least one URL must be specified").build();
        }
        for (String split : splits) {
            String url = split.trim();
            ValidationResult result = StandardValidators.URL_VALIDATOR.validate(subject, url, context);
            if (result == null || result.isValid()) continue;
            return result;
        }
        return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
    }
}

