/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.annotations.ApiModelProperty;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ComponentDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;

@XmlType(name="reportingTask")
public class ReportingTaskDTO
extends ComponentDTO {
    public static final String VALID = "VALID";
    public static final String INVALID = "INVALID";
    public static final String VALIDATING = "VALIDATING";
    private String name;
    private String type;
    private BundleDTO bundle;
    private String state;
    private String comments;
    private Boolean persistsState;
    private Boolean restricted;
    private Boolean deprecated;
    private Boolean isExtensionMissing;
    private Boolean multipleVersionsAvailable;
    private Boolean supportsSensitiveDynamicProperties;
    private String schedulingPeriod;
    private String schedulingStrategy;
    private Map<String, String> defaultSchedulingPeriod;
    private Map<String, String> properties;
    private Map<String, PropertyDescriptorDTO> descriptors;
    private Set<String> sensitiveDynamicPropertyNames;
    private String customUiUrl;
    private String annotationData;
    private Collection<String> validationErrors;
    private String validationStatus;
    private Integer activeThreadCount;

    @ApiModelProperty(value="The name of the reporting task.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The comments of the reporting task.")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @ApiModelProperty(value="The fully qualified type of the reporting task.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @ApiModelProperty(value="The details of the artifact that bundled this reporting task type.")
    public BundleDTO getBundle() {
        return this.bundle;
    }

    public void setBundle(BundleDTO bundle) {
        this.bundle = bundle;
    }

    @ApiModelProperty(value="The frequency with which to schedule the reporting task. The format of the value will depend on the value of the schedulingStrategy.")
    public String getSchedulingPeriod() {
        return this.schedulingPeriod;
    }

    public void setSchedulingPeriod(String schedulingPeriod) {
        this.schedulingPeriod = schedulingPeriod;
    }

    @ApiModelProperty(value="Whether the reporting task persists state.")
    public Boolean getPersistsState() {
        return this.persistsState;
    }

    public void setPersistsState(Boolean persistsState) {
        this.persistsState = persistsState;
    }

    @ApiModelProperty(value="Whether the reporting task requires elevated privileges.")
    public Boolean getRestricted() {
        return this.restricted;
    }

    public void setRestricted(Boolean restricted) {
        this.restricted = restricted;
    }

    @ApiModelProperty(value="Whether the reporting task has been deprecated.")
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    @ApiModelProperty(value="Whether the underlying extension is missing.")
    public Boolean getExtensionMissing() {
        return this.isExtensionMissing;
    }

    public void setExtensionMissing(Boolean extensionMissing) {
        this.isExtensionMissing = extensionMissing;
    }

    @ApiModelProperty(value="Whether the reporting task has multiple versions available.")
    public Boolean getMultipleVersionsAvailable() {
        return this.multipleVersionsAvailable;
    }

    public void setMultipleVersionsAvailable(Boolean multipleVersionsAvailable) {
        this.multipleVersionsAvailable = multipleVersionsAvailable;
    }

    @ApiModelProperty(value="Whether the reporting task supports sensitive dynamic properties.")
    public Boolean getSupportsSensitiveDynamicProperties() {
        return this.supportsSensitiveDynamicProperties;
    }

    public void setSupportsSensitiveDynamicProperties(Boolean supportsSensitiveDynamicProperties) {
        this.supportsSensitiveDynamicProperties = supportsSensitiveDynamicProperties;
    }

    @ApiModelProperty(value="The state of the reporting task.", allowableValues="RUNNING, STOPPED, DISABLED")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @ApiModelProperty(value="The scheduling strategy that determines how the schedulingPeriod value should be interpreted.")
    public String getSchedulingStrategy() {
        return this.schedulingStrategy;
    }

    public void setSchedulingStrategy(String schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy;
    }

    @ApiModelProperty(value="The properties of the reporting task.")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @ApiModelProperty(value="The descriptors for the reporting tasks properties.")
    public Map<String, PropertyDescriptorDTO> getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(Map<String, PropertyDescriptorDTO> descriptors) {
        this.descriptors = descriptors;
    }

    @ApiModelProperty(value="Set of sensitive dynamic property names")
    public Set<String> getSensitiveDynamicPropertyNames() {
        return this.sensitiveDynamicPropertyNames;
    }

    public void setSensitiveDynamicPropertyNames(Set<String> sensitiveDynamicPropertyNames) {
        this.sensitiveDynamicPropertyNames = sensitiveDynamicPropertyNames;
    }

    @ApiModelProperty(value="The URL for the custom configuration UI for the reporting task.")
    public String getCustomUiUrl() {
        return this.customUiUrl;
    }

    public void setCustomUiUrl(String customUiUrl) {
        this.customUiUrl = customUiUrl;
    }

    @ApiModelProperty(value="The annotation data for the repoting task. This is how the custom UI relays configuration to the reporting task.")
    public String getAnnotationData() {
        return this.annotationData;
    }

    public void setAnnotationData(String annotationData) {
        this.annotationData = annotationData;
    }

    @ApiModelProperty(value="Gets the validation errors from the reporting task. These validation errors represent the problems with the reporting task that must be resolved before it can be scheduled to run.")
    public Collection<String> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(Collection<String> validationErrors) {
        this.validationErrors = validationErrors;
    }

    @ApiModelProperty(value="Indicates whether the Reporting Task is valid, invalid, or still in the process of validating (i.e., it is unknown whether or not the Reporting Task is valid)", accessMode=ApiModelProperty.AccessMode.READ_ONLY, allowableValues="VALID, INVALID, VALIDATING")
    public String getValidationStatus() {
        return this.validationStatus;
    }

    public void setValidationStatus(String validationStatus) {
        this.validationStatus = validationStatus;
    }

    @ApiModelProperty(value="The default scheduling period for the different scheduling strategies.")
    public Map<String, String> getDefaultSchedulingPeriod() {
        return this.defaultSchedulingPeriod;
    }

    public void setDefaultSchedulingPeriod(Map<String, String> defaultSchedulingPeriod) {
        this.defaultSchedulingPeriod = defaultSchedulingPeriod;
    }

    @ApiModelProperty(value="The number of active threads for the reporting task.")
    public Integer getActiveThreadCount() {
        return this.activeThreadCount;
    }

    public void setActiveThreadCount(Integer activeThreadCount) {
        this.activeThreadCount = activeThreadCount;
    }
}

