/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.cipher.compatibility;

import java.nio.charset.StandardCharsets;
import org.apache.nifi.components.DescribedValue;

public enum CompatibilityModeKeyDerivationStrategy implements DescribedValue
{
    OPENSSL_EVP_BYTES_TO_KEY("OpenSSL Envelope BytesToKey using a digest algorithm with one iteration and optional salt of eight bytes", 0, 8, 16, "Salted__".getBytes(StandardCharsets.US_ASCII)),
    JASYPT_STANDARD("Jasypt Java Simplified Encryption using a digest algorithm with 1000 iterations and required salt of eight or sixteen bytes", 1000, 8, 16, new byte[0]);

    private final String description;
    private final int iterations;
    private final byte[] saltHeader;
    private final int saltStandardLength;
    private final int saltBufferLength;

    private CompatibilityModeKeyDerivationStrategy(String description, int iterations, int saltStandardLength, int saltBufferLength, byte[] saltHeader) {
        this.description = description;
        this.iterations = iterations;
        this.saltStandardLength = saltStandardLength;
        this.saltBufferLength = saltBufferLength;
        this.saltHeader = saltHeader;
    }

    public String getValue() {
        return this.name();
    }

    public String getDisplayName() {
        return this.name();
    }

    public String getDescription() {
        return this.description;
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getSaltStandardLength() {
        return this.saltStandardLength;
    }

    public int getSaltBufferLength() {
        return this.saltBufferLength;
    }

    public byte[] getSaltHeader() {
        return this.saltHeader;
    }
}

